% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_historicals_crypto.R
\name{get_historicals_crypto}
\alias{get_historicals_crypto}
\title{Get historical crypto price history from RobinHood}
\usage{
get_historicals_crypto(RH, symbol, interval, span, bounds, tz = Sys.timezone())
}
\arguments{
\item{RH}{object of class RobinHood}

\item{symbol}{(string) ticker symbol of crypto (BTC, ETH, ETC)}

\item{interval}{(string) Interval of time to aggregate to (examples: hour, day, week, month)}

\item{span}{(string) Period of time you are interested in (examples: day, week, month, year)}

\item{bounds}{(string) One of regular (6 hours), trading (9 hours), extended (16 hours), 24_7}

\item{tz}{(string) timezone returned by OlsonNames() (eg: "America/Chicago")}
}
\description{
Returns a data frame of historical crypto price history for a given symbol. Note that not all combinations of interval/span and bounds will return results. Spans that go beyond day (week, month, year) will not return results for certain bounds values (trading, extended). The function should return a message if you specify a combination of inputs that returns no results.
}
\examples{
\dontrun{
# Login in to your RobinHood account
RH <- RobinHood("username", "password")

get_historicals_crypto(RH, symbol = "ETC", interval = "5minute", span = "day", bounds = 'regular')
get_historicals_crypto(RH, symbol = "ETC", interval = "5minute", span = "day", bounds = 'trading')
get_historicals_crypto(RH, symbol = "ETC", interval = "5minute", span = "day", bounds = 'extended')
get_historicals_crypto(RH, symbol = "ETC", interval = "5minute", span = "day", bounds = '24_7')

}
}
