% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{summary.RoBMA}
\alias{summary.RoBMA}
\title{Summarize fitted RoBMA object}
\usage{
\method{summary}{RoBMA}(
  object,
  type = "ensemble",
  conditional = FALSE,
  output_scale = NULL,
  probs = c(0.025, 0.975),
  logBF = FALSE,
  BF01 = FALSE,
  short_name = FALSE,
  remove_spike_0 = FALSE,
  ...
)
}
\arguments{
\item{object}{a fitted RoBMA object}

\item{type}{whether to show the overall RoBMA results (\code{"ensemble"}),
an overview of the individual models (\code{"models"}), an overview of
the individual models MCMC diagnostics (\code{"diagnostics"}), or a detailed summary
of the individual models (\code{"individual"}). Can be abbreviated to first letters.}

\item{conditional}{show the conditional estimates (assuming that the
alternative is true). Defaults to \code{FALSE}. Only available for
\code{type == "conditional"}.}

\item{output_scale}{transform the  meta-analytic estimates to a different
scale. Defaults to \code{NULL} which returns the same scale as the model was estimated on.}

\item{probs}{quantiles of the posterior samples to be displayed.
Defaults to \code{c(.025, .975)}}

\item{logBF}{show log of Bayes factors. Defaults to \code{FALSE}.}

\item{BF01}{show Bayes factors in support of the null hypotheses. Defaults to
\code{FALSE}.}

\item{short_name}{whether priors names should be shortened to the first
(couple) of letters. Defaults to \code{FALSE}.}

\item{remove_spike_0}{whether spike prior distributions with location at zero should
be omitted from the summary. Defaults to \code{FALSE}.}

\item{...}{additional arguments}
}
\value{
\code{summary.RoBMA} returns a list of tables of class 'BayesTools_table'.
}
\description{
\code{summary.RoBMA} creates summary tables for a
RoBMA object.
}
\note{
See \code{\link[=diagnostics]{diagnostics()}} for visual convergence checks of the individual models.
}
\examples{
\dontrun{
# using the example data from Anderson et al. 2010 and fitting the default model
# (note that the model can take a while to fit)
fit <- RoBMA(r = Anderson2010$r, n = Anderson2010$n, study_names = Anderson2010$labels)

# summary can provide many details about the model
summary(fit)

# estimates from the conditional models can be obtained with
summary(fit, conditional = TRUE)

# overview of the models and their prior and posterior probability, marginal likelihood,
# and inclusion Bayes factor can be obtained with
summary(fit, type = "models")

# diagnostics overview, containing the maximum R-hat, minimum ESS, maximum MCMC error, and
# maximum MCMC error / sd across parameters for each individual model can be obtained with
summary(fit, type = "diagnostics")

# summary of individual models and their parameters can be further obtained by
summary(fit, type = "individual")
}

}
\seealso{
\code{\link[=RoBMA]{RoBMA()}}, \code{\link[=diagnostics]{diagnostics()}}, \code{\link[=check_RoBMA]{check_RoBMA()}}
}
