% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transformations.R
\name{effect_sizes}
\alias{effect_sizes}
\alias{d2r}
\alias{d2z}
\alias{d2logOR}
\alias{d2OR}
\alias{r2d}
\alias{r2z}
\alias{r2logOR}
\alias{r2OR}
\alias{z2r}
\alias{z2d}
\alias{z2logOR}
\alias{z2OR}
\alias{logOR2r}
\alias{logOR2z}
\alias{logOR2d}
\alias{logOR2OR}
\alias{OR2r}
\alias{OR2z}
\alias{OR2logOR}
\alias{OR2d}
\title{Effect size transformations}
\usage{
d2r(d)

d2z(d)

d2logOR(d)

d2OR(d)

r2d(r)

r2z(r)

r2logOR(r)

r2OR(r)

z2r(z)

z2d(z)

z2logOR(z)

z2OR(z)

logOR2r(logOR)

logOR2z(logOR)

logOR2d(logOR)

logOR2OR(logOR)

OR2r(OR)

OR2z(OR)

OR2logOR(OR)

OR2d(OR)
}
\arguments{
\item{d}{Cohen's d.}

\item{r}{correlation coefficient.}

\item{z}{Fisher's z.}

\item{logOR}{log(odds ratios).}

\item{OR}{offs ratios.}
}
\description{
Functions for transforming between different
effect size measures.
}
\details{
All transformations are based on
\insertCite{borenstein2011introduction}{RoBMA}. In case that
a direct transformation is not available, the transformations
are chained to provide the effect size of interest.
}
\references{
\insertAllCited{}
}
\seealso{
\code{\link[=standard_errors]{standard_errors()}}, \code{\link[=sample_sizes]{sample_sizes()}}
}
