# This file was generated by Rcpp::compileAttributes
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Convert MySQL ATONs to Rip4
#'
#' When you query a MySQL db, you should use INET_ATON(ip_field) to convert a string IP 
#' to an (unsigned) int.
#' 
#' Unfortunately, the RMySQL driver will convert these to doubles because not all
#' unsigned ints are representable as ints. Because doubles get normalized, we 
#' can't mask subnets directly.
#'  
#' Instead, we can map the top half of unsigned integers to the negative half of signed
#' ints using 2s-complement.  
#'
#' @param x input numeric vector
#' @return integer format IP addresses
#'
#'
mySqlToIp4 <- function(x) {
    .Call('Rip46_mySqlToIp4', PACKAGE = 'Rip46', x)
}

hostToIp4 <- function(x) {
    .Call('Rip46_hostToIp4', PACKAGE = 'Rip46', x)
}

ip4ToHost <- function(x) {
    .Call('Rip46_ip4ToHost', PACKAGE = 'Rip46', x)
}

#' Extract Networks from IP addresses
#'
#' @rdname network-mask
#' @param x an \code{ip4} object
#' @param m a bit mask
#' @export
mask <- function(x, m) {
    .Call('Rip46_mask', PACKAGE = 'Rip46', x, m)
}

#' @rdname network-mask
#' @export
classA <- function(x) {
    .Call('Rip46_classA', PACKAGE = 'Rip46', x)
}

#' @rdname network-mask 
#' @export
classB <- function(x) {
    .Call('Rip46_classB', PACKAGE = 'Rip46', x)
}

#' @rdname network-mask
#' @export
classC <- function(x) {
    .Call('Rip46_classC', PACKAGE = 'Rip46', x)
}

hostToIp6 <- function(x) {
    .Call('Rip46_hostToIp6', PACKAGE = 'Rip46', x)
}

ip6ToHost <- function(x) {
    .Call('Rip46_ip6ToHost', PACKAGE = 'Rip46', x)
}

