% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/removeBurnin.R
\name{removeBurnin}
\alias{removeBurnin}
\title{Remove Burnin}
\usage{
removeBurnin(trace, burnin)
}
\arguments{
\item{trace}{(list of data frames; no default) Name of a list of data frames,
such as produced by readTrace().}

\item{burnin}{(single numeric value; 0.1) Fraction of generations to
discard (if value provided is between 0 and 1) or number of generations (if
value provided is greater than 1).}
}
\value{
List of dataframes (of length 1 if only 1 log file provided).
}
\description{
Removes burnin from MCMC trace
}
\details{
Removes burnin from an MCMC trace, such as the output of readTrace(). If
multiple traces are provided, this function will remove the burnin from each.
}
\examples{

\donttest{
# download the example dataset to working directory
url_gtr <-
    "https://revbayes.github.io/tutorials/intro/data/primates_cytb_GTR.log"
dest_path_gtr <- "primates_cytb_GTR.log"
download.file(url_gtr, dest_path_gtr)

# to run on your own data, change this to the path to your data file
file_single <- dest_path_gtr

one_trace <- readTrace(paths = file_single)
one_trace_burnin <- removeBurnin(trace = one_trace, burnin = 0.1)

# remove file
# WARNING: only run for example dataset!
# otherwise you might delete your data!
file.remove(dest_path_gtr)
}

}
