% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Require2.R
\name{sysInstallAndDownload}
\alias{sysInstallAndDownload}
\title{download.files or install.packages in a separate process}
\usage{
sysInstallAndDownload(
  args,
  splitOn = "pkgs",
  doLine = "outfiles <- do.call(download.packages, args)",
  returnOutfile = FALSE,
  doLineVectorized = TRUE,
  tmpdir,
  libPaths,
  verbose
)
}
\arguments{
\item{args}{A list with all arguments for a do.call to either \verb{download.file, }install.packages\verb{or a custom other function e.g.,}downloadAndBuildToLocalFile`.}

\item{splitOn}{A character vector of the names in \code{args} to parallelize over.
Defaults to \code{pkgs}. All other named elements in \code{args} will be assumed to
be length 1 and used for every parallel process.}

\item{doLine}{A character string with the \code{"outfiles <- do.call(..., args)"} line.}

\item{returnOutfile}{A logical. If \code{TRUE}, then the names of the \code{outfiles} will
be returned.}

\item{doLineVectorized}{A logical. If \code{TRUE}, and parallism is being used, this
indicates that the \code{doLine} is a function that allows for multiple elements
in \verb{args[[splitOn[[1]]]}. If \code{FALSE}, the function will make multiple
sequential calls within each parallel process to the \code{doLine} call.}

\item{tmpdir}{A single path where all downloads will be put}

\item{libPaths}{The library path (or libraries) where all packages should be
installed, and looked for to load (i.e., call \code{library}). This can be used
to create isolated, stand alone package installations, if used with
\code{standAlone = TRUE}. Currently, the path supplied here will be prepended to
\code{.libPaths()} (temporarily during this call) to \code{Require} if
\code{standAlone = FALSE} or will set (temporarily) \code{.libPaths()} to
\verb{c(libPaths, tail(libPaths(), 1)} to keep base packages.}

\item{verbose}{Numeric or logical indicating how verbose should the function
be. If -1 or -2, then as little verbosity as possible. If 0 or FALSE,
then minimal outputs; if \code{1} or TRUE, more outputs; \code{2} even more. NOTE: in
\code{Require} function, when \code{verbose >= 2}, also returns details as if
\code{returnDetails = TRUE} (for backwards compatibility).}
}
\value{
Mostly for side effects, namely installed packages or downloaded packages or
files. However, in the case of \code{returnOutfile = TRUE}, then a list of
filenames will be returned with any outputs from the \code{doLine}.
}
\description{
This uses \code{sys} package so that messaging can be controlled. This also provides
the option to parallelize by spawning multiple \code{background} process to allow
parallel e.g., downloads. Noting that if \code{libcurl} is installed (and detected
using \code{capabilities("libcurl")}), then no explicit parallelism will be allowed,
instead \code{method = "libcurl"} will be passed enabling parallel downloads.
}
