/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.openpackaging.parts;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashMap;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.UnmarshalException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.util.JAXBResult;
import javax.xml.transform.Result;
import javax.xml.transform.Templates;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.io.IOUtils;
import org.docx4j.XmlUtils;
import org.docx4j.jaxb.Context;
import org.docx4j.jaxb.JaxbValidationEventHandler;
import org.docx4j.jaxb.NamespacePrefixMapperUtils;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.exceptions.InvalidFormatException;
import org.docx4j.openpackaging.io3.stores.PartStore;
import org.docx4j.openpackaging.parts.Part;
import org.docx4j.openpackaging.parts.PartName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JaxbXmlPart<E>
extends Part {
    protected static Logger log = LoggerFactory.getLogger(JaxbXmlPart.class);
    protected JAXBContext jc;
    protected E jaxbElement = null;

    public JaxbXmlPart(PartName partName) throws InvalidFormatException {
        super(partName);
        this.setJAXBContext(Context.jc);
    }

    public JaxbXmlPart(PartName partName, JAXBContext jc) throws InvalidFormatException {
        super(partName);
        this.setJAXBContext(jc);
    }

    public void setJAXBContext(JAXBContext jc) {
        this.jc = jc;
    }

    public JAXBContext getJAXBContext() {
        return this.jc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public E getJaxbElement() {
        block13: {
            InputStream is = null;
            if (this.jaxbElement == null) {
                PartStore partStore = this.getPackage().getSourcePartStore();
                try {
                    String name = this.partName.getName();
                    try {
                        if (partStore != null) {
                            this.setContentLengthAsLoaded(partStore.getPartSize(name.substring(1)));
                        }
                    }
                    catch (UnsupportedOperationException uoe) {
                        // empty catch block
                    }
                    is = partStore.loadPart(name.substring(1));
                    if (is == null) {
                        log.warn(name + " missing from part store");
                    } else {
                        log.info("Lazily unmarshalling " + name);
                        this.unmarshal(is);
                    }
                    IOUtils.closeQuietly((InputStream)is);
                }
                catch (JAXBException e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
                catch (Docx4JException e2) {
                    log.error(e2.getMessage(), (Throwable)e2);
                    break block13;
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }
                finally {
                    IOUtils.closeQuietly(is);
                }
            }
        }
        return this.jaxbElement;
    }

    public E getContents() {
        return this.getJaxbElement();
    }

    public void setJaxbElement(E jaxbElement) {
        this.jaxbElement = jaxbElement;
    }

    public void setContents(E jaxbElement) {
        this.jaxbElement = jaxbElement;
    }

    public void setJaxbElement(JAXBResult result) throws JAXBException {
        this.setJaxbElement(result.getResult());
    }

    public String getXML() {
        return XmlUtils.marshaltoString(this.getJaxbElement(), true, true, this.jc);
    }

    public boolean isUnmarshalled() {
        return this.jaxbElement != null;
    }

    public void variableReplace(HashMap<String, String> mappings) throws JAXBException, Docx4JException {
        String wmlTemplateString = null;
        if (this.jaxbElement == null) {
            String name;
            PartStore partStore = this.getPackage().getSourcePartStore();
            InputStream is = partStore.loadPart((name = this.partName.getName()).substring(1));
            if (is == null) {
                log.warn(name + " missing from part store");
                throw new Docx4JException(name + " missing from part store");
            }
            log.info("Lazily unmarshalling " + name);
            try {
                wmlTemplateString = IOUtils.toString((InputStream)is, (String)"UTF-8");
            }
            catch (IOException e) {
                throw new Docx4JException(e.getMessage(), e);
            }
        } else {
            wmlTemplateString = XmlUtils.marshaltoString(this.jaxbElement, true, false, this.jc);
        }
        this.jaxbElement = XmlUtils.unmarshallFromTemplate(wmlTemplateString, mappings);
    }

    public void marshal(Node node) throws JAXBException {
        this.marshal(node, NamespacePrefixMapperUtils.getPrefixMapper());
    }

    public void marshal(Node node, Object namespacePrefixMapper) throws JAXBException {
        try {
            Marshaller marshaller = this.jc.createMarshaller();
            NamespacePrefixMapperUtils.setProperty(marshaller, namespacePrefixMapper);
            this.getJaxbElement();
            this.setMceIgnorable();
            marshaller.marshal(this.jaxbElement, node);
        }
        catch (JAXBException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    public void marshal(OutputStream os) throws JAXBException {
        this.marshal(os, NamespacePrefixMapperUtils.getPrefixMapper());
    }

    public void marshal(OutputStream os, Object namespacePrefixMapper) throws JAXBException {
        try {
            Marshaller marshaller = this.jc.createMarshaller();
            NamespacePrefixMapperUtils.setProperty(marshaller, namespacePrefixMapper);
            log.info("marshalling " + this.getClass().getName());
            this.getJaxbElement();
            if (this.jaxbElement == null) {
                log.error("No JAXBElement has been created for this part, yet!");
                throw new JAXBException("No JAXBElement has been created for this part, yet!");
            }
            this.setMceIgnorable();
            marshaller.marshal(this.jaxbElement, os);
        }
        catch (JAXBException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    protected void setMceIgnorable() {
    }

    public E unmarshal(InputStream is) throws JAXBException {
        block8: {
            try {
                Unmarshaller u = this.jc.createUnmarshaller();
                JaxbValidationEventHandler eventHandler = new JaxbValidationEventHandler();
                if (is.markSupported()) {
                    eventHandler.setContinue(false);
                }
                u.setEventHandler((ValidationEventHandler)eventHandler);
                try {
                    this.jaxbElement = XmlUtils.unwrap(u.unmarshal(is));
                }
                catch (UnmarshalException ue) {
                    if (is.markSupported()) {
                        log.info("encountered unexpected content; pre-processing");
                        eventHandler.setContinue(true);
                        try {
                            Templates mcPreprocessorXslt = JaxbValidationEventHandler.getMcPreprocessor();
                            is.reset();
                            JAXBResult result = XmlUtils.prepareJAXBResult(this.jc);
                            XmlUtils.transform(new StreamSource(is), mcPreprocessorXslt, null, (Result)result);
                            this.jaxbElement = XmlUtils.unwrap(result.getResult());
                            break block8;
                        }
                        catch (Exception e) {
                            throw new JAXBException("Preprocessing exception", (Throwable)e);
                        }
                    }
                    log.error(ue.getMessage(), (Throwable)ue);
                    log.error(".. and mark not supported");
                    throw ue;
                }
            }
            catch (JAXBException e) {
                log.error(e.getMessage(), (Throwable)e);
                throw e;
            }
        }
        return this.jaxbElement;
    }

    public E unmarshal(Element el) throws JAXBException {
        try {
            Unmarshaller u = this.jc.createUnmarshaller();
            JaxbValidationEventHandler eventHandler = new JaxbValidationEventHandler();
            eventHandler.setContinue(false);
            u.setEventHandler((ValidationEventHandler)eventHandler);
            try {
                this.jaxbElement = XmlUtils.unwrap(u.unmarshal((Node)el));
            }
            catch (UnmarshalException ue) {
                log.info("encountered unexpected content; pre-processing");
                try {
                    Document doc = el instanceof Document ? (Document)((Object)el) : el.getOwnerDocument();
                    eventHandler.setContinue(true);
                    JAXBResult result = XmlUtils.prepareJAXBResult(this.jc);
                    Templates mcPreprocessorXslt = JaxbValidationEventHandler.getMcPreprocessor();
                    XmlUtils.transform(doc, mcPreprocessorXslt, null, (Result)result);
                    this.jaxbElement = XmlUtils.unwrap(result.getResult());
                }
                catch (Exception e) {
                    throw new JAXBException("Preprocessing exception", (Throwable)e);
                }
            }
            return this.jaxbElement;
        }
        catch (JAXBException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    @Override
    public boolean isContentEqual(Part other) throws Docx4JException {
        log.debug("Comparing " + this.getPartName().getName() + " : " + other.getPartName().getName());
        if (!(other instanceof JaxbXmlPart)) {
            log.debug(other.getPartName().getName() + " is not a JaxbXmlPart");
            return false;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ByteArrayOutputStream baos2 = new ByteArrayOutputStream();
        try {
            this.marshal(baos);
            ((JaxbXmlPart)other).marshal(baos2);
        }
        catch (JAXBException e) {
            throw new Docx4JException("Error marshalling parts", (Exception)((Object)e));
        }
        return Arrays.equals(baos.toByteArray(), baos2.toByteArray());
    }
}

