/*
 * Decompiled with CFR 0.152.
 */
package org.lysis.reporters.text;

import java.math.BigInteger;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Vector;
import org.docx4j.openpackaging.parts.Part;
import org.docx4j.openpackaging.parts.WordprocessingML.FootnotesPart;
import org.docx4j.wml.CTFootnotes;
import org.docx4j.wml.CTFtnEdn;
import org.docx4j.wml.ObjectFactory;
import org.docx4j.wml.P;
import org.docx4j.wml.R;
import org.lysis.reporters.formats.TextProperties;
import org.lysis.reporters.text.ParagraphSet;
import org.lysis.reporters.text.RScript;
import org.lysis.reporters.tools.DOCX4R;
import org.lysis.reporters.tools.Debug;
import org.lysis.reporters.tools.DocComponent;
import org.lysis.reporters.tools.HTML4R;

public class FootNote
extends DocComponent
implements HTML4R,
DOCX4R {
    private LinkedHashMap<Integer, ParagraphSet> parList;
    private int footnoteid;
    private TextProperties textProperties;

    public FootNote(TextProperties textProp) {
        this.textProperties = textProp;
        this.parList = new LinkedHashMap();
        this.footnoteid = -1;
    }

    public TextProperties getTextProperties() {
        return this.textProperties;
    }

    public int getFootnoteID() {
        return this.footnoteid;
    }

    public void addParagraph(ParagraphSet par) {
        this.parList.put(this.size(), par);
    }

    public void addParagraph(RScript par) {
        this.parList.put(this.size(), par);
    }

    public int size() {
        return this.parList.size();
    }

    public String toString() {
        String out = "";
        if (this.size() > 0) {
            int i = 0;
            while (i < this.size()) {
                out = String.valueOf(out) + this.parList.get(i).toString();
                ++i;
            }
        }
        return out;
    }

    @Override
    public String getHTML() {
        if (this.size() < 1) {
            return "";
        }
        String out = "";
        if (this.size() > 0) {
            int i = 0;
            while (i < this.size()) {
                this.parList.get(i).setHTMLReference(this.list_id, this.counters, this.numbDefinition);
                out = String.valueOf(out) + this.parList.get(i).getHTML();
                ++i;
            }
        }
        return out;
    }

    @Override
    public boolean validateDOCXComponent() {
        return this.docx_mlp != null;
    }

    private void addFootnoteDefinition(Vector<P> pars) throws Exception {
        CTFootnotes footnotes;
        if (Debug.debug_list) {
            System.err.println("addFootnoteDefinition");
        }
        try {
            footnotes = (CTFootnotes)this.getDOCXMLPackage().getMainDocumentPart().getFootnotesPart().getJaxbElement();
        }
        catch (Exception e) {
            footnotes = new CTFootnotes();
        }
        FootnotesPart footnotespart = new FootnotesPart();
        CTFtnEdn fotterEndNote = new CTFtnEdn();
        fotterEndNote.getContent().addAll(pars);
        this.footnoteid = footnotes.getFootnote().size() + 1;
        fotterEndNote.setId(BigInteger.valueOf(this.footnoteid));
        footnotes.getFootnote().add(fotterEndNote);
        footnotespart.setJaxbElement((Object)footnotes);
        this.getDOCXMLPackage().getMainDocumentPart().addTargetPart((Part)footnotespart);
    }

    @Override
    public Vector<P> get_docx_elt() throws Exception {
        Vector<P> out = new Vector<P>();
        if (!this.validateDOCXComponent()) {
            throw new Exception("class Footnote: elements need to be set...");
        }
        if (this.size() > 0) {
            int i = 0;
            while (i < this.size()) {
                this.parList.get(i).getParProperties().setOrderedNumid(this.ordered_num_id);
                this.parList.get(i).setNumberingDefinitionsPart(this.ndp);
                this.parList.get(i).setOrderedNumID(this.ordered_num_id);
                this.parList.get(i).setUnorderedNumID(this.unordered_num_id);
                this.parList.get(i).setDOCXMLPackage(this.getDOCXMLPackage());
                Object temp = this.parList.get(i).get_docx_elt();
                if (i == 0) {
                    R.FootnoteRef ff = new R.FootnoteRef();
                    ObjectFactory of = new ObjectFactory();
                    R run = new R();
                    run.setRPr(this.textProperties.get_docx_pr());
                    run.getContent().add(of.createRFootnoteRef(ff));
                    ((P)((Vector)temp).get(0)).getContent().add(0, run);
                }
                out.addAll((Collection<P>)temp);
                ++i;
            }
        }
        this.addFootnoteDefinition(out);
        return out;
    }

    @Override
    public String getCSS() {
        return null;
    }

    @Override
    public String getJS() {
        return null;
    }

    @Override
    public boolean hasJS() {
        return false;
    }

    @Override
    public boolean hasHTML() {
        return true;
    }

    @Override
    public boolean hasCSS() {
        return false;
    }
}

