% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mfdClass.R
\name{mfd}
\alias{mfd}
\alias{Mfd}
\title{Define a Set of Multidimensional Functional Data objects}
\usage{
Mfd(argval = NULL, X, mdbs, method = "data")
}
\arguments{
\item{argval}{A list of numeric vectors of argument values at which the `mfd` object is to be evaluated}

\item{X}{A numeric matrix corresponds to basis expansion coefficients
if `method="coefs"` and discrete observations if `method="data"`.}

\item{mdbs}{a basismfd object}

\item{method}{determine the `X` matrix type as "coefs" and "data".}
}
\description{
The `mfd` class represents a set of multidimensional functional data with 
`basismfd` object. Functional data objects are constructed by 
specifying a set of basis functions and a set of coefficients defining a 
linear combination of these basis functions.

Constructor for `mfd` objects (same as Mfd(...) )
}
\examples{
require(fda)
bs1 <- create.fourier.basis(c(0,2*pi),5)
bs2 <- create.bspline.basis(c(0,1),7)
bs3 <- create.exponential.basis(c(0,2),3)

#1-D mfd :_____________________________
argval <- seq(0,2*pi,length.out=100)
nobs <- 10;
X <- outer(sin(argval),seq(0.5,1.5,length.out=nobs))
mdbs1 <- Basismfd(bs1)
mfd1 <- Mfd(X=X, mdbs = mdbs1)
inprod_mfd(mfd1,mfd1)
norm_mfd(mfd1)
mfd0 <- 2.5*mfd1
mfd1-mfd0
mfd1[1:3]

mfd1$eval(argval)
mfd1c <- Mfd(X=mfd1$coefs, mdbs = mdbs1, method = "coefs")
all.equal(c(mfd1$basis,mfd1$coefs,mfd1$nobs),c(mfd1c$basis,mfd1c$coefs,mfd1c$nobs))
length(mfd1)
mean(mfd1)
plot(mfd1)

}
\seealso{
\code{\link{basismfd}}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{basis}}{an object of the class `basismfd`.}

\item{\code{coefs}}{a matrix of the coefficients.}

\item{\code{nobs}}{number of the observation}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-mfd-new}{\code{mfd$new()}}
\item \href{#method-mfd-eval}{\code{mfd$eval()}}
\item \href{#method-mfd-print}{\code{mfd$print()}}
\item \href{#method-mfd-clone}{\code{mfd$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-mfd-new"></a>}}
\if{latex}{\out{\hypertarget{method-mfd-new}{}}}
\subsection{Method \code{new()}}{
Constructor for `mfd` objects (same as Mfd(...) )
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{mfd$new(argval = NULL, X, mdbs, method = "data")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{argval}}{A list of numeric vectors of argument values at which the `mfd` object is to be evaluated}

\item{\code{X}}{A numeric matrix corresponds to basis expansion coefficients
if `method="coefs"` and discrete observations if `method="data"`.}

\item{\code{mdbs}}{a basismfd object}

\item{\code{method}}{determine the `X` matrix type as "coefs" and "data".}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-mfd-eval"></a>}}
\if{latex}{\out{\hypertarget{method-mfd-eval}{}}}
\subsection{Method \code{eval()}}{
Evaluation an `mfd` object in some arguments.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{mfd$eval(evalarg)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{evalarg}}{a list of numeric vector of argument values at which the \code{mfd} is to be evaluated.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A matrix of evaluated values
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-mfd-print"></a>}}
\if{latex}{\out{\hypertarget{method-mfd-print}{}}}
\subsection{Method \code{print()}}{
Print method for `mfd` objects
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{mfd$print(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Additional arguments to be passed to `print`}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-mfd-clone"></a>}}
\if{latex}{\out{\hypertarget{method-mfd-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{mfd$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
