/*
 * Decompiled with CFR 0.152.
 */
package org.drools.base.evaluators;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import org.drools.base.BaseEvaluator;
import org.drools.base.ValueType;
import org.drools.base.evaluators.EvaluatorDefinition;
import org.drools.base.evaluators.Operator;
import org.drools.common.InternalWorkingMemory;
import org.drools.factmodel.traits.Thing;
import org.drools.factmodel.traits.Traitable;
import org.drools.factmodel.traits.TraitableBean;
import org.drools.rule.VariableRestriction;
import org.drools.spi.Evaluator;
import org.drools.spi.FieldValue;
import org.drools.spi.InternalReadAccessor;

public class IsAEvaluatorDefinition
implements EvaluatorDefinition {
    public static final Operator ISA = Operator.addOperatorToRegistry("isA", false);
    public static final Operator NOT_ISA = Operator.addOperatorToRegistry("isA", true);
    private static final String[] SUPPORTED_IDS = new String[]{ISA.getOperatorString()};
    private Evaluator[] evaluator;

    public Evaluator getEvaluator(ValueType type, Operator operator) {
        return this.getEvaluator(type, operator.getOperatorString(), operator.isNegated(), null);
    }

    public Evaluator getEvaluator(ValueType type, Operator operator, String parameterText) {
        return this.getEvaluator(type, operator.getOperatorString(), operator.isNegated(), parameterText);
    }

    public Evaluator getEvaluator(ValueType type, String operatorId, boolean isNegated, String parameterText) {
        return this.getEvaluator(type, operatorId, isNegated, parameterText, EvaluatorDefinition.Target.FACT, EvaluatorDefinition.Target.FACT);
    }

    public Evaluator getEvaluator(ValueType type, String operatorId, boolean isNegated, String parameterText, EvaluatorDefinition.Target leftTarget, EvaluatorDefinition.Target rightTarget) {
        IsAEvaluator evaluator = new IsAEvaluator(type, isNegated);
        evaluator.setParameterText(parameterText);
        return evaluator;
    }

    public String[] getEvaluatorIds() {
        return SUPPORTED_IDS;
    }

    public EvaluatorDefinition.Target getTarget() {
        return EvaluatorDefinition.Target.FACT;
    }

    public boolean isNegatable() {
        return true;
    }

    public boolean supportsType(ValueType type) {
        return type.equals(ValueType.TRAIT_TYPE);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.evaluator = (Evaluator[])in.readObject();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.evaluator);
    }

    public static class IsAEvaluator
    extends BaseEvaluator {
        public void setParameterText(String parameterText) {
        }

        public IsAEvaluator(ValueType type, boolean isNegated) {
            super(type, isNegated ? NOT_ISA : ISA);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor, Object object, FieldValue value) {
            Object objectValue = extractor.getValue(workingMemory, object);
            Object typeName = value.getValue();
            if (typeName instanceof Class) {
                typeName = ((Class)typeName).getName();
            }
            TraitableBean core = null;
            if (objectValue instanceof Thing) {
                Thing thing = (Thing)objectValue;
                core = (TraitableBean)thing.getCore();
                return this.getOperator().isNegated() ^ core.hasTrait(typeName.toString());
            }
            if (objectValue.getClass().getAnnotation(Traitable.class) != null) {
                core = (TraitableBean)objectValue;
                return this.getOperator().isNegated() ^ core.hasTrait(typeName.toString());
            }
            return false;
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor leftExtractor, Object left, InternalReadAccessor rightExtractor, Object right) {
            Object value1 = leftExtractor.getValue(workingMemory, left);
            Object value2 = rightExtractor.getValue(workingMemory, right);
            Object target = value1;
            Object source = value2;
            return this.compare(source, target);
        }

        public boolean evaluateCachedLeft(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object right) {
            Object target = right;
            Object source = context.getObject();
            return this.compare(source, target);
        }

        public boolean evaluateCachedRight(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object left) {
            Object target = left;
            Object source = context.getObject();
            return this.compare(source, target);
        }

        private boolean compare(Object source, Object target) {
            Collection<String> sourceTraits = null;
            Collection<String> targetTraits = null;
            if (source instanceof Thing) {
                sourceTraits = ((TraitableBean)((Thing)source).getCore()).getTraits();
            } else if (source.getClass().getAnnotation(Traitable.class) != null) {
                sourceTraits = ((TraitableBean)source).getTraits();
            }
            if (target instanceof Thing) {
                targetTraits = ((TraitableBean)((Thing)target).getCore()).getTraits();
            } else if (source.getClass().getAnnotation(Traitable.class) != null) {
                targetTraits = ((TraitableBean)target).getTraits();
            }
            return targetTraits != null && this.getOperator().isNegated() ^ sourceTraits.containsAll(targetTraits);
        }

        public String toString() {
            return "IsAEvaluatorDefinition isA";
        }
    }
}

