/*
 * Decompiled with CFR 0.152.
 */
package org.mvel2.ast;

import org.mvel2.CompileException;
import org.mvel2.MVEL;
import org.mvel2.ParserContext;
import org.mvel2.PropertyAccessor;
import org.mvel2.ast.ASTNode;
import org.mvel2.ast.Assignment;
import org.mvel2.compiler.CompiledAccExpression;
import org.mvel2.compiler.ExecutableStatement;
import org.mvel2.integration.VariableResolverFactory;
import org.mvel2.util.ArrayTools;
import org.mvel2.util.ParseTools;

public class AssignmentNode
extends ASTNode
implements Assignment {
    private String varName;
    private transient CompiledAccExpression accExpr;
    private char[] indexTarget;
    private String index;
    private ExecutableStatement statement;
    private boolean col = false;

    public AssignmentNode(char[] expr, int start, int offset, int fields, ParserContext pCtx) {
        this.expr = expr;
        this.start = start;
        this.offset = offset;
        int assignStart = ParseTools.find(expr, start, offset, '=');
        if (assignStart != -1) {
            this.varName = ParseTools.createStringTrimmed(expr, start, assignStart - start);
            this.start = ParseTools.skipWhitespace(expr, assignStart + 1);
            if (this.start >= start + offset) {
                throw new CompileException("unexpected end of statement", expr, assignStart + 1);
            }
            this.offset = offset - (this.start - start);
            if ((fields & 0x10) != 0) {
                this.statement = (ExecutableStatement)ParseTools.subCompileExpression(expr, this.start, this.offset, pCtx);
                this.egressType = this.statement.getKnownEgressType();
            }
            this.indexTarget = this.varName.toCharArray();
            this.endOfName = ArrayTools.findFirst('[', 0, this.varName.length(), this.indexTarget);
            this.col = this.endOfName > 0;
            if (this.col) {
                if (((this.fields |= 0x100) & 0x10) != 0) {
                    this.accExpr = (CompiledAccExpression)MVEL.compileSetExpression(this.indexTarget, pCtx);
                }
                this.varName = new String(expr, start, this.endOfName);
                this.index = new String(this.indexTarget, this.endOfName, this.indexTarget.length - this.endOfName);
            }
            try {
                ParseTools.checkNameSafety(this.varName);
            }
            catch (RuntimeException e) {
                throw new CompileException(e.getMessage(), expr, start);
            }
        }
        try {
            this.varName = new String(expr, start, offset);
            ParseTools.checkNameSafety(this.varName);
        }
        catch (RuntimeException e) {
            throw new CompileException(e.getMessage(), expr, start);
        }
        if ((fields & 0x10) != 0) {
            pCtx.addVariable(this.varName, this.egressType);
        }
    }

    public Object getReducedValueAccelerated(Object ctx, Object thisValue, VariableResolverFactory factory) {
        if (this.accExpr == null && this.indexTarget != null) {
            this.accExpr = (CompiledAccExpression)MVEL.compileSetExpression(this.indexTarget);
        }
        if (this.col) {
            return this.accExpr.setValue(ctx, thisValue, factory, this.statement.getValue(ctx, thisValue, factory));
        }
        if (this.statement != null) {
            if (factory == null) {
                throw new CompileException("cannot assign variables; no variable resolver factory available", this.expr, this.start);
            }
            return factory.createVariable(this.varName, this.statement.getValue(ctx, thisValue, factory)).getValue();
        }
        if (factory == null) {
            throw new CompileException("cannot assign variables; no variable resolver factory available", this.expr, this.start);
        }
        factory.createVariable(this.varName, null);
        return null;
    }

    public Object getReducedValue(Object ctx, Object thisValue, VariableResolverFactory factory) {
        ParseTools.checkNameSafety(this.varName);
        if (!this.col) {
            return factory.createVariable(this.varName, MVEL.eval(this.expr, this.start, this.offset, ctx, factory)).getValue();
        }
        ctx = MVEL.eval(this.expr, this.start, this.offset, ctx, factory);
        PropertyAccessor.set(factory.getVariableResolver(this.varName).getValue(), factory, this.index, ctx);
        return ctx;
    }

    public String getAssignmentVar() {
        return this.varName;
    }

    public char[] getExpression() {
        return ParseTools.subset(this.expr, this.start, this.offset);
    }

    public boolean isNewDeclaration() {
        return false;
    }

    public void setValueStatement(ExecutableStatement stmt) {
        this.statement = stmt;
    }

    public String toString() {
        return this.varName + " = " + new String(this.expr, this.start, this.offset);
    }
}

