\name{insert_ref}
\alias{insert_ref}
\alias{insertRef}
\title{Insert bibtex references in Rd and roxygen2 documentation}
\description{

  Package Rdpack provides an Rd macro for inserting references from
  bibtex files into R documentation.  Function insert_ref() is the
  workhorse behind this mechanism. The description given in this page
  should be sufficient, for more details see the vignette.

}
\usage{
insert_ref(key, package = NULL, ...)
}
\arguments{
  \item{key}{the bibtex key of the reference, a character string.}
  \item{package}{the package in which to look for the the bibtex file.}
  \item{\dots}{further arguments to pass on to \code{bibtex::read.bib}}
}
\details{
  \code{insert_ref} extracts a reference from a bibtex file, converts
  it to Rd format and returns a single string with embedded newline
  characters. It is the workhorse in the provided mechanism but most
  users do not even need to know about \code{insert_ref}.

  The documentation of a package using the mechanism provided here
  relies on the Rd macro \verb{\\insertRef} and needs to be prepared as
  follows: 
  % To prepare a package to use this mechanism, the following preparation
  % steps need to be done:
  \enumerate{
    \item{
      File `DESCRIPTION' should contain the following line: \cr

      \verb{RdMacros: Rdpack} \cr
      
      (If there is already a line starting with 'RdMacros:', Rdpack
      should be added to the list on that line.)
    }

    \item{
      `Rdpack' should be added to the list of imports in file
      `DESCRIPTION'. 
    }
    
    \item{
      The BibTeX references should be put in file
      \code{"REFERENCES.bib"} in subdirectory \code{"inst/"} of the 
      package.
    }

  }
  
  References are inserted in documentation using the syntax
  \verb{\\insertRef{key}{package}}, where \verb{key} is the bibtex key
  of the reference and \verb{package} is an R package containing file
  \code{"REFERENCES.bib"} from which the reference should be taken.

  This works in manually written Rd files and in `roxygen2' documentation
  chunks. The references will appear in the place where the macro is put,
  usually in a dedicated references section (\verb{\\references}
  in Rd files, \verb{@references} in roxygen chunks).

  Argument 'package' can be any installed R package, not necessarily the
  one of the documentation object.  This works for
  packages that have \code{"REFERENCES.bib"} in their installation
  directory and for the default packages.
  
  For example, the references in the references section of this help
  page are generated by the following lines in the Rd file:
  \preformatted{
    \\insertRef{Rpack:bibtex}{Rdpack}

    \\insertRef{R}{bibtex}
  }

  A roxygen2 documentation chunk might look like this:
  \preformatted{
    #' \@references
    #' \\insertRef{Rpack:bibtex}{Rdpack}
    #'
    #' \\insertRef{R}{bibtex}
  }

  The first reference has label \verb{Rpack:bibtex} and is taken from
  file \code{"REFERENCES.bib"} in package `Rdpack'. The second reference
  is from the file with the same name in package \verb{"bibtex"}.
  
  For more details see vignette:
  \code{vignette("Inserting_bibtex_references", package = "Rdpack")}


  The references are processed when the package is built.
  % 2017-08-09 commenting out:
  %
  % So, there is
  % \emph{no need} to depend/import/suggest package \verb{"Rdpack"}, it
  % only needs to be installed on your machine.

}
\value{
  for \code{insert_ref}, a character string
}
\references{
  \insertRef{Rpack:bibtex}{Rdpack}

  \insertRef{R}{bibtex}
}
\author{Georgi N. Boshnakov}
\seealso{
  \code{\link{rebib}}
}
\examples{
  cat(insert_ref("R", package = "bibtex"), sep ="\n")

}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{Rd}
