% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nonlinear_SPLAPEIG.R
\name{do.splapeig}
\alias{do.splapeig}
\title{Supervised Laplacian Eigenmaps}
\usage{
do.splapeig(
  X,
  label,
  ndim = 2,
  preprocess = c("null", "center", "scale", "cscale", "whiten", "decorrelate"),
  beta = 1,
  gamma = 0.5
)
}
\arguments{
\item{X}{an \eqn{(n\times p)} matrix or data frame whose rows are observations
and columns represent independent variables.}

\item{label}{a length-\eqn{n} vector of data class labels.}

\item{ndim}{an integer-valued target dimension.}

\item{preprocess}{an additional option for preprocessing the data.
Default is "null". See also \code{\link{aux.preprocess}} for more details.}

\item{beta}{bandwidth parameter for heat kernel in \eqn{[0,\infty)}.}

\item{gamma}{a balancing parameter in \eqn{[0,1]} between within- and between-class information.}
}
\value{
a named list containing
\describe{
\item{Y}{an \eqn{(n\times ndim)} matrix whose rows are embedded observations.}
\item{trfinfo}{a list containing information for out-of-sample prediction.}
}
}
\description{
Supervised Laplacian Eigenmaps (SPLAPEIG) is a supervised variant of Laplacian Eigenmaps.
Instead of setting up explicit neighborhood, it utilizes an adaptive threshold strategy
to define neighbors for both within- and between-class neighborhood. It then builds affinity
matrices for each information and solves generalized eigenvalue problem. This algorithm
may be quite sensitive in the choice of \code{beta} value.
}
\examples{
\donttest{
## load iris data
data(iris)
X     = as.matrix(iris[,1:4])
label = as.factor(iris$Species)

## try different balancing parameters with beta=100
out1 = do.splapeig(X, label, beta=100, gamma=0.1)
out2 = do.splapeig(X, label, beta=100, gamma=0.5)
out3 = do.splapeig(X, label, beta=100, gamma=0.9)

## visualize
opar <- par(no.readonly=TRUE)
par(mfrow=c(1,3))
plot(out1$Y, col=label, main="gamma=0.1")
plot(out2$Y, col=label, main="gamma=0.5")
plot(out3$Y, col=label, main="gamma=0.9")
par(opar)
}


}
\references{
\insertRef{raducanu_supervised_2012}{Rdimtools}
}
\seealso{
\code{\link{do.lapeig}}
}
\author{
Kisung You
}
\concept{nonlinear_methods}
