% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linear_PPCA.R
\name{do.ppca}
\alias{do.ppca}
\title{Probabilistic Principal Component Analysis}
\usage{
do.ppca(
  X,
  ndim = 2,
  preprocess = c("center", "scale", "cscale", "decorrelate", "whiten")
)
}
\arguments{
\item{X}{an \eqn{(n\times p)} matrix or data frame whose rows are observations
and columns represent independent variables.}

\item{ndim}{an integer-valued target dimension.}

\item{preprocess}{an option for preprocessing the data. This supports three methods.
Default is "center". See also \code{\link{aux.preprocess}} for more details.}
}
\value{
a named list containing
\describe{
\item{Y}{an \eqn{(n\times ndim)} matrix whose rows are embedded observations.}
\item{trfinfo}{a list containing information for out-of-sample prediction.}
\item{projection}{a \eqn{(p\times ndim)} whose columns are principal components.}
\item{mle.sigma2}{MLE for \eqn{\sigma^2}.}
\item{mle.W}{MLE of a \eqn{(p\times ndim)} mapping from latent to observation in column major.}
}
}
\description{
Probabilistic PCA (PPCA) is a probabilistic framework to explain the well-known PCA model. Using
the conjugacy of normal model, we compute MLE for values explicitly derived in the paper. Note that
unlike PCA where loadings are directly used for projection, PPCA uses \eqn{WM^{-1}} as projection matrix,
as it is relevant to the error model. Also, for high-dimensional problem, it is possible that MLE can have
negative values if sample covariance given the data is rank-deficient.
}
\examples{
\donttest{
## use iris data
data(iris)
X     = as.matrix(iris[,1:4])
label = as.integer(iris$Species)

## Compare PCA and PPCA
PCA  <- do.pca(X, ndim=2, preprocess="center")
PPCA <- do.ppca(X, ndim=2, preprocess="center")

## Visualize
opar <- par(no.readonly=TRUE)
par(mfrow=c(1,2))
plot(PCA$Y,  col=label, main="PCA")
plot(PPCA$Y, col=label, main="PPCA")
par(opar)
}

}
\references{
\insertRef{tipping_probabilistic_1999}{Rdimtools}
}
\seealso{
\code{\link{do.pca}}
}
\author{
Kisung You
}
\concept{linear_methods}
