% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ver2_linear_PCA.R
\name{do.pca}
\alias{do.pca}
\title{Principal Component Analysis}
\usage{
do.pca(
  X,
  ndim = 2,
  cor = FALSE,
  preprocess = c("center", "scale", "cscale", "decorrelate", "whiten")
)
}
\arguments{
\item{X}{an \eqn{(n\times p)} matrix whose rows are observations
and columns represent independent variables.}

\item{ndim}{an integer-valued target dimension.}

\item{cor}{mode of eigendecomposition. \code{FALSE} for decomposing covariance matrix,
and \code{TRUE} for correlation matrix.}

\item{preprocess}{an option for preprocessing the data. This supports three methods,
where default is \code{"center"}. See also \code{\link{aux.preprocess}} for more details.}
}
\value{
a named list containing
\describe{
\item{Y}{an \eqn{(n\times ndim)} matrix whose rows are embedded observations.}
\item{vars}{a vector containing variances of projected data onto principal components.}
\item{projection}{a \eqn{(p\times ndim)} whose columns are principal components.}
\item{trfinfo}{a list containing information for out-of-sample prediction.}
}
}
\description{
\code{do.pca} performs a classical principal component analysis (PCA) using
\code{RcppArmadillo} package for faster and efficient computation.
}
\examples{
## use iris data
data(iris)
X     = as.matrix(iris[,1:4])
label = as.integer(iris$Species)

## try different preprocessing procedure
out1 <- do.pca(X, ndim=2, preprocess="center")
out2 <- do.pca(X, ndim=2, preprocess="decorrelate")
out3 <- do.pca(X, ndim=2, preprocess="whiten")

## embeddings for each procedure
Y1 <- out1$Y; Y2 <- out2$Y; Y3 <- out3$Y

## visualize
opar <- par(no.readonly=TRUE)
par(mfrow=c(1,3))
plot(Y1, col=label, pch=19, main="PCA::'center'")
plot(Y2, col=label, pch=19, main="PCA::'decorrelate'")
plot(Y3, col=label, pch=19, main="PCA::'whiten'")
par(opar)

}
\references{
\insertRef{pearson_liii_1901}{Rdimtools}
}
\author{
Kisung You
}
\concept{linear_methods}
