% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oos_LINPROJ.R
\name{oos.linproj}
\alias{oos.linproj}
\title{OOS : Linear Projection}
\usage{
oos.linproj(Xold, Yold, trfinfo, Xnew)
}
\arguments{
\item{Xold}{an \eqn{(n\times p)} matrix of data in original high-dimensional space.}

\item{Yold}{an \eqn{(n\times ndim)} matrix of data in reduced-dimensional space.}

\item{trfinfo}{a list containing transformation information generated from manifold learning algorithms.
See also \code{\link{aux.preprocess}} for more details.}

\item{Xnew}{an \eqn{(m\times p)} matrix for out-of-sample extension.}
}
\value{
a named list containing
\describe{
\item{Ynew}{an \eqn{(m\times ndim)} matrix whose rows are embedded observations.}
}
}
\description{
The simplest way of out-of-sample extension might be linear regression even though the original embedding
is not the linear type by solving
\deqn{\textrm{min}_{\beta} \|X_{old} \beta - Y_{old}\|_2^2} and use the estimate \eqn{\hat{beta}} to acquire
\deqn{Y_{new} = X_{new} \hat{\beta}}. Due to the choice of original preprocessing, \code{trfinfo} must be brought
from the original model you trained.
}
\examples{
\dontrun{
## generate sample data and separate them
X = aux.gensamples(n=500)
set.seed(46556)
idxselect  = sample(1:500,20)

Xold = X[setdiff(1:500,idxselect),]  # 80\% of data for training
Xnew = X[idxselect,]                 # 20\% of data for testing

## run PCA for train data
training = do.pca(Xold,ndim=2,preprocess="whiten")
Yold     = training$Y       # embedded data points
oldinfo  = training$trfinfo # preprocessing information

## perform out-of-sample extension
output  = oos.linproj(Xold, Yold, oldinfo, Xnew)
Ynew    = output$Ynew

## let's compare via visualization
xx = c(-2,2) # range of axis 1 for compact visualization
yy = c(-2,2) # range of axis 2 for compact visualization
mm = "black=train / red=test data" # figure title

plot(Yold[,1], Yold[,2], type="p", xlim=xx, ylim=yy, main=mm, xlab="axis 1", ylab="axis 2")
par(new=TRUE)
plot(Ynew[,1], Ynew[,2], type="p", lwd=3, col="red", xlim=xx, ylim=yy, xlab="", ylab="")
}

}
\author{
Kisung You
}
