% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LoginSession.R
\name{LoginSession}
\alias{LoginSession}
\title{Open a logged in Session}
\usage{
LoginSession(Browser, LoginURL, LoginCredentials, cssLoginFields,
  cssLoginButton, cssRadioToCheck, XpathLoginFields, XpathLoginButton,
  XpathRadioToCheck)
}
\arguments{
\item{Browser}{object, phatomjs web driver use \code{\link{run_browser}} function to create this object.}

\item{LoginURL}{character, login page URL}

\item{LoginCredentials, }{login Credentials values eg: email and password}

\item{cssLoginFields, }{vector of login fields css pattern.}

\item{cssLoginButton, }{the css pattern of the login button that should be clicked to access protected zone.}

\item{cssRadioToCheck, }{the radio/checkbox css pattern to be checked(if exist)}

\item{XpathLoginFields, }{vector of login fields xpath pattern.}

\item{XpathLoginButton, }{the xpath pattern of the login button.}

\item{XpathRadioToCheck}{the radio/checkbox xpath pattern to be checked(if exist)}
}
\value{
return authentified browser session object
}
\description{
Simulate authentifaction using web driver automation
This function Fetch login page using phantomjs web driver(virtual browser), sets login and password values + other required values then clicks on login button.
You should provide these agruments for the function to work correctly :
- Login page URL
- Login Credentials eg: email & password
- css Or Xpath of Login Credential fields
- css or xpath of Login Button
- If a checkbox is required in the login page then provide provide its css or xpath pattern
}
\examples{

\dontrun{


 #This function is based on web browser automation, so, before start,
 make sure you have successfully installed web driver (phantomjs).
 install_browser()
 # Run browser process and get its reference object
 br<- run_browser()

  brs<-LoginSession(Browser = br, LoginURL = 'http://glofile.com/wp-login.php',
                LoginCredentials = c('demo','rc@pass@r'),
                cssLoginFields =c('#user_login', '#user_pass'),
                cssLoginButton='#wp-submit' )

 # To make sure that you have been successfully authenticated
 # Check URL of the current page after login redirection
 brs$getUrl()
 # Or Take screenshot of the website dashborad
 brs$takeScreenshot(file = "sc.png")


 brs$delete()
 brs$status()
 brs$go(url)
 brs$getUrl()
 brs$goBack()
 brs$goForward()
 brs$refresh()
 brs$getTitle()
 brs$getSource()
 brs$takeScreenshot(file = NULL)
 brs$findElement(css = NULL, linkText = NULL,
              partialLinkText = NULL, xpath = NULL)
 brs$findElements(css = NULL, linkText = NULL,
               partialLinkText = NULL, xpath = NULL)
 brs$executeScript(script, ...)
 brs$executeScriptAsync(script, ...)
 brs$setTimeout(script = NULL, pageLoad = NULL, implicit = NULL)
 brs$moveMouseTo(xoffset = 0, yoffset = 0)
 brs$click(button = c("left", "middle", "right"))
 brs$doubleClick(button = c("left", "middle", "right"))
 brs$mouseButtonDown(button = c("left", "middle", "right"))
 brs$mouseButtonUp(button = c("left", "middle", "right"))
 brs$readLog(type = c("browser", "har"))
 brs$getLogTypes()

}
}
\author{
salim khalil
}
