% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validationindex.R
\name{validation.index}
\alias{validation.index}
\title{Validation Index of Fuzzy Clustering}
\usage{
validation.index(cluster)
}
\arguments{
\item{cluster}{Cluster Result from Fuzzy Clustering}
}
\value{
XB.index Xie Beni index

MPC.index Modified Partition Coeeficient

CE.index Classification Entropy
}
\description{
Validation Index of Fuzzy Clustering
}
\details{
This function provide validation index that calculated from fuzzy clustering
result. There are 3 index that calculated, Xie Beni, MPC, and CE index. Both three indexes
calculated from fuzzy membership and data point.

Xie Beni index calculated compactness and separation of clustering.

The best cluster result can be decided with minimum value of index.
}
\examples{
library(RcmdrPlugin.FuzzyClust)
fuzzy.CM(X=iris[,1:4],K = 3,m = 2,RandomNumber = 1234)->cl
validation.index(cl)
}
\references{
Wang, W., & Zhang, Y. (2007). On Fuzzy Cluster Validity Indices. Fuzzy Sets and System, 2095-2117.
}

