% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sampleBuilding.R
\name{applyPreprocessing}
\alias{applyPreprocessing}
\title{Preprocessing application}
\usage{
applyPreprocessing(
  data.sample,
  operations = NULL,
  RclusTool.env = initParameters(),
  reset = TRUE,
  preprocessed.only = FALSE
)
}
\arguments{
\item{data.sample}{sample object.}

\item{operations}{list of data.frames describing all preprocessing operations.}

\item{RclusTool.env}{environment in which all global parameters, raw data and results are stored.}

\item{reset}{boolean : if TRUE (default) the configuration is reset.}

\item{preprocessed.only}{boolean : if TRUE (default) processing are restricted to the "preprocessed" features.}
}
\value{
The \code{data.sample} sample object on which was applied the \code{operations} or NULL if preprocessing operations fail.
}
\description{
Apply a new preprocess to a data.sample object.
}
\details{
applyPreprocessing applies a new preprocess to a data.sample object
}
\examples{
dat <- rbind(matrix(rnorm(150, mean = 2, sd = 0.3), ncol = 3), 
             matrix(rnorm(150, mean = 4, sd = 0.3), ncol = 3), 
             matrix(rnorm(150, mean = 6, sd = 0.3), ncol = 3))
colnames(dat) <- c("x","y","z")
tf1 <- tempfile()
write.table(dat, tf1, sep=";", dec=",")
x <- importSample(file.features=tf1, sepFeat=";", decFeat=",")

instr <- rbind(c("select","x","log",""), c("select","y","log",""))
tf2 <- tempfile()
write.table(instr, tf2, sep=",", col.names = FALSE, row.names = FALSE)

operations <- loadPreprocessFile(tf2)
x <- applyPreprocessing(x, operations)


}
\seealso{
\code{\link{loadPreprocessFile}}
}
