% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bdh.R
\name{bdh}
\alias{bdh}
\title{Run 'Bloomberg Data History' Queries}
\usage{
bdh(securities, fields, start.date, end.date = NULL,
  include.non.trading.days = FALSE, options = NULL, overrides = NULL,
  verbose = FALSE, identity = NULL, con = defaultConnection(),
  int.as.double = getOption("blpIntAsDouble", FALSE))
}
\arguments{
\item{securities}{A character vector with security symbols in
Bloomberg notation.}

\item{fields}{A character vector with Bloomberg query fields.}

\item{start.date}{A Date variable with the query start date.}

\item{end.date}{An optional Date variable with the query end date;
if omitted the most recent available date is used.}

\item{include.non.trading.days}{An optional logical variable
indicating whether non-trading days should be included.}

\item{options}{An optional named character vector with option
values. Each field must have both a name (designating the option
being set) as well as a value.}

\item{overrides}{An optional named character vector with override
values. Each field must have both a name (designating the override
being set) as well as a value.}

\item{verbose}{A boolean indicating whether verbose operation is
desired, defaults to \sQuote{FALSE}}

\item{identity}{An optional identity object.}

\item{con}{A connection object as created by a \code{blpConnect}
call, and retrieved via the internal function
\code{defaultConnection}.}

\item{int.as.double}{A boolean indicating whether integer fields should
be retrieved as doubles instead. This option is a workaround for very
large values which would overflow int32. Defaults to \sQuote{FALSE}}
}
\value{
A list with as a many entries as there are entries in
\code{securities}; each list contains a data.frame with one row
per observations and as many columns as entries in
\code{fields}. If the list is of length one, it is collapsed into
a single data frame. Note that the order of securities returned
is determined by the backend and may be different from the order
of securities in the \code{securities} field.
}
\description{
This function uses the Bloomberg API to retrieve 'bdh' (Bloomberg
Data History) queries
}
\examples{
\dontrun{
  bdh("SPY US Equity", c("PX_LAST", "VOLUME"), start.date=Sys.Date()-31)

  ## example for an options field: request monthly data; see section A.2.4 of
  ##  http://www.bloomberglabs.com/content/uploads/sites/2/2014/07/blpapi-developers-guide-2.54.pdf
  ## for more
  opt <- c("periodicitySelection"="MONTHLY")
  bdh("SPY US Equity", c("PX_LAST", "VOLUME"),
      start.date=Sys.Date()-31*6, options=opt)

  ## example for non-date start
  bdh("SPY US Equity", c("PX_LAST", "VOLUME"),
      start.date="-6CM", options=opt)

  ## example for options and overrides
  opt <- c("periodicitySelection" = "QUARTERLY")
  ovrd <- c("BEST_FPERIOD_OVERRIDE"="1GQ")
  bdh("IBM US Equity", "BEST_SALES", start.date=Sys.Date()-365.25*4,
      options=opt, overrides=ovrd)

  ## example for returnRelativeDate option
  opt <- c(periodicitySelection="YEARLY", periodicityAdjustment="FISCAL", returnRelativeDate=TRUE)
  bdh("GLB ID Equity", "CUR_MKT_CAP", as.Date("1997-12-31"), as.Date("2017-12-31"), options=opt)
}
}
\seealso{
For historical futures series, see \sQuote{DOCS #2072138 <GO>}
on the Bloomberg terminal about selecting different rolling conventions.
}
\author{
Whit Armstrong and Dirk Eddelbuettel
}
