% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/StemID.R
\name{projback}
\alias{projback}
\title{Compute Cell Projections for Randomized Background Distribution}
\usage{
projback(object, pdishuf = 500, fast = FALSE, rseed = 17000, verbose = TRUE)
}
\arguments{
\item{object}{\code{Ltree} class object.}

\item{pdishuf}{Number of randomizations of cell positions for which to compute projections of cells on inter-cluster links. Default is 2000.
No randomizations are needed in this mode and the function will do nothing. Default is \code{TRUE}.}

\item{fast}{logical. If \code{TRUE} and \code{nmode=FALSE} cells will still be assigned to links based on maximum projections but a fast approximate background model
will be used to infer significance. The function will do nothing in this case. Default is \code{FALSE}.}

\item{rseed}{Integer number used as seed to ensure reproducibility of randomizations. Defaut is 17000.}

\item{verbose}{logical. If \code{FALSE} then status output messages are disabled. Default is \code{TRUE}.}
}
\value{
An Ltree class object with all information on randomized cell projections onto links stored in the \code{prbacka} slot.
}
\description{
This function computes the projections of cells onto inter-cluster links for randomized cell positions in a high-dimensional embedded space. Significance
of link based on an increased number of cells on a link is inferred based on this background model.
}
\examples{
sc <- SCseq(intestinalDataSmall)
sc <- filterdata(sc)
sc <- compdist(sc)
sc <- clustexp(sc)
sc <- findoutliers(sc)
sc <- comptsne(sc)
ltr <- Ltree(sc)
ltr <- compentropy(ltr)
ltr <- projcells(ltr,nmode=FALSE)
ltr <- projback(ltr,pdishuf=50)
}
