% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RaceID.R
\name{compfr}
\alias{compfr}
\title{Computation of a two dimensional Fruchterman-Rheingold representation}
\usage{
compfr(object, knn = 10, rseed = 15555)
}
\arguments{
\item{object}{\code{SCseq} class object.}

\item{knn}{Positive integer number of nearest neighbours used for the inference of the Fruchterman-Rheingold layout. Default is \code{10}.}

\item{rseed}{Integer number. Random seed to enforce reproducible layouts.}
}
\value{
\code{SCseq} object with layout coordinates stored in slot \code{fr}.
}
\description{
This functions performs the computation of a Fruchterman-Rheingold graph layout based on an adjacency matrix derived
from the distance object in slot \code{distances} using the \pkg{igraph} package.
}
\examples{
sc <- SCseq(intestinalDataSmall)
sc <- filterdata(sc)
sc <- compdist(sc)
sc <- clustexp(sc)
sc <- findoutliers(sc)
sc <- compfr(sc)
}
