% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grabMzmlFunctions.R
\name{grabMzmlMS1}
\alias{grabMzmlMS1}
\title{Extract the MS1 data from an mzML nodeset}
\usage{
grabMzmlMS1(xml_data, rtrange, file_metadata, prefilter)
}
\arguments{
\item{xml_data}{An `xml2` nodeset, usually created by applying `read_xml` to
an mzML file.}

\item{rtrange}{A vector of length 2 containing an upper and lower bound on
retention times of interest. Providing a range here can speed up load times
(although not enormously, as the entire file must still be read) and reduce
the final object's size.}

\item{file_metadata}{Information about the file used to decode the binary
arrays containing m/z and intensity information.}

\item{prefilter}{The lowest intensity value of interest, used to reduce file
size (and especially useful for profile mode data with many 0 values)}
}
\value{
A `data.table` with columns for retention time (rt), m/z (mz), and
  intensity (int).
}
\description{
Extract the MS1 data from an mzML nodeset
}
