% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{BPSGaussian}
\alias{BPSGaussian}
\title{BPSGaussian}
\usage{
BPSGaussian(V, mu, n_iter = -1L, finalTime = -1, x0 = numeric(0),
  v0 = numeric(0), refresh_rate = 1, unit_velocity = FALSE)
}
\arguments{
\item{V}{the inverse covariance matrix (or precision matrix) of the Gaussian target distribution.}

\item{mu}{mean of the Gaussian target distribution}

\item{n_iter}{Number of algorithm iterations; will result in the equivalent amount of skeleton points in Gaussian case because no rejections are needed.}

\item{finalTime}{If provided and nonnegative, run the BPS sampler until a trajectory of continuous time length finalTime is obtained (ignoring the value of \code{n_iterations})}

\item{x0}{starting point (optional, if not specified taken to be the origin)}

\item{v0}{starting direction (optional, if not specified taken to be a random vector)}

\item{refresh_rate}{\code{lambda_refresh}}

\item{unit_velocity}{TRUE indicates velocities uniform on unit sphere, FALSE (default) indicates standard normal velocities}
}
\value{
Returns a list with the following objects:

\code{Times}: Vector of switching times

\code{Positions}: Matrix whose columns are locations of switches. The number of columns is identical to the length of \code{skeletonTimes}. Be aware that the skeleton points themselves are NOT samples from the target distribution.

\code{Velocities}: Matrix whose columns are velocities just after switches. The number of columns is identical to the length of \code{skeletonTimes}.
}
\description{
Applies the BPS Sampler to a Gaussian target distribution, as detailed in Bouchard-Côté et al, 2017.
Assume potential of the form \deqn{U(x) = (x - mu)^T V (x - mu)/2,} i.e. a Gaussian with mean vector \code{mu} and covariance matrix \code{inv(V)}
}
\examples{
V <- matrix(c(3,1,1,3),nrow=2)
mu <- c(2,2)
x0 <- c(0,0)
result <- BPSGaussian(V, mu, n_iter = 100, x0 = x0)
plot(result$Positions[1,], result$Positions[2,],type='l',asp=1)
}
