/*
 * Decompiled with CFR 0.152.
 */
package weka.knowledgeflow.steps;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import weka.core.OptionMetadata;
import weka.core.WekaException;
import weka.knowledgeflow.Data;
import weka.knowledgeflow.LoggingLevel;
import weka.knowledgeflow.StepManager;
import weka.knowledgeflow.steps.BaseStep;
import weka.knowledgeflow.steps.KFStep;

@KFStep(name="WriteToWekaLog", category="Flow", toolTipText="Write data to the log", iconPath="weka/gui/knowledgeflow/icons/WriteWekaLog.gif")
public class WriteWekaLog
extends BaseStep {
    private static final long serialVersionUID = -2306717547200779711L;
    protected String m_incrementalWriteFrequency = "1000";
    protected int m_incrFreq = 1000;
    protected int m_incrCount;
    protected boolean m_isReset;
    protected boolean m_inputIsIncremental;
    protected LoggingLevel m_logLevel = LoggingLevel.BASIC;

    @OptionMetadata(displayName="Logging level", description="The level at which to write log messages", displayOrder=1)
    public void setLoggingLevel(LoggingLevel level) {
        this.m_logLevel = level;
    }

    public LoggingLevel getLoggingLevel() {
        return this.m_logLevel;
    }

    @OptionMetadata(displayName="Incremental logging frequency", description="How often to write an incremental/streaming data point to the log", displayOrder=2)
    public void setIncrementalLoggingFrequency(String frequency) {
        this.m_incrementalWriteFrequency = frequency;
    }

    public String getIncrementalLoggingFrequency() {
        return this.m_incrementalWriteFrequency;
    }

    @Override
    public void stepInit() throws WekaException {
        this.m_isReset = true;
        this.m_incrCount = 0;
        this.m_inputIsIncremental = false;
        String resolvedFreq = this.getStepManager().environmentSubstitute(this.m_incrementalWriteFrequency);
        if (resolvedFreq.length() > 0) {
            try {
                this.m_incrFreq = Integer.parseInt(this.m_incrementalWriteFrequency);
            }
            catch (NumberFormatException ex) {
                this.getStepManager().logWarning("Unable to parse incremental write frequency setting " + resolvedFreq);
            }
        }
    }

    @Override
    public void processIncoming(Data data) throws WekaException {
        if (this.m_isReset) {
            this.m_isReset = false;
            this.m_inputIsIncremental = data.getPayloadElement("incremental_stream", false);
        }
        if (this.m_inputIsIncremental) {
            this.processStreaming(data);
            if (this.isStopRequested()) {
                this.getStepManager().interrupted();
            }
        } else {
            this.getStepManager().processing();
            this.processBatch(data);
            if (this.isStopRequested()) {
                this.getStepManager().interrupted();
            } else {
                this.getStepManager().finished();
            }
        }
    }

    protected void processStreaming(Data data) throws WekaException {
        Object payload = data.getPrimaryPayload();
        if (this.m_incrCount % this.m_incrFreq == 0 && payload != null) {
            this.getStepManager().log(payload.toString(), this.m_logLevel);
        }
        ++this.m_incrCount;
    }

    protected void processBatch(Data data) throws WekaException {
        Object payload = data.getPrimaryPayload();
        if (payload != null) {
            this.getStepManager().log(payload.toString(), this.m_logLevel);
        }
    }

    @Override
    public List<String> getIncomingConnectionTypes() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.getStepManager().numIncomingConnections() == 0) {
            result.add("instance");
        }
        if (this.getStepManager().numIncomingConnectionsOfType("instance") == 0) {
            result.addAll(Arrays.asList("dataSet", "trainingSet", "testSet", "text", "batchAssociator", "batchClassifier", "batchClusterer"));
        }
        return result;
    }

    @Override
    public List<String> getOutgoingConnectionTypes() {
        Map<String, List<StepManager>> incoming = this.getStepManager().getIncomingConnections();
        return new ArrayList<String>(incoming.keySet());
    }
}

