/*
 * Decompiled with CFR 0.152.
 */
package weka.knowledgeflow;

import java.io.PrintWriter;
import java.io.StringWriter;
import weka.core.LogHandler;
import weka.core.OptionHandler;
import weka.core.Utils;
import weka.gui.Logger;
import weka.knowledgeflow.LoggingLevel;
import weka.knowledgeflow.StepManagerImpl;
import weka.knowledgeflow.steps.Step;
import weka.knowledgeflow.steps.WekaAlgorithmWrapper;

public class LogManager
implements LogHandler {
    protected String m_statusMessagePrefix = "";
    protected Logger m_log;
    protected boolean m_status;
    protected LoggingLevel m_levelToLogAt = LoggingLevel.BASIC;

    public LogManager(Step source) {
        Object wrappedAlgo;
        this.m_status = true;
        String prefix = (source != null ? source.getName() : "Unknown") + "$";
        prefix = prefix + (source != null ? source.hashCode() : 1) + "|";
        if (source instanceof WekaAlgorithmWrapper && (wrappedAlgo = ((WekaAlgorithmWrapper)source).getWrappedAlgorithm()) instanceof OptionHandler) {
            prefix = prefix + Utils.joinOptions(((OptionHandler)wrappedAlgo).getOptions()) + "|";
        }
        this.m_statusMessagePrefix = prefix;
        if (source != null) {
            this.m_log = ((StepManagerImpl)source.getStepManager()).getLog();
            this.setLoggingLevel(((StepManagerImpl)source.getStepManager()).getLoggingLevel());
        }
    }

    public LogManager(Logger log) {
        this(log, true);
    }

    public LogManager(Logger log, boolean status) {
        this.m_log = log;
        this.m_status = status;
    }

    public static String stackTraceToString(Throwable throwable) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        throwable.printStackTrace(pw);
        return sw.toString();
    }

    @Override
    public void setLog(Logger log) {
        this.m_log = log;
    }

    @Override
    public Logger getLog() {
        return this.m_log;
    }

    public LoggingLevel getLoggingLevel() {
        return this.m_levelToLogAt;
    }

    public void setLoggingLevel(LoggingLevel level) {
        this.m_levelToLogAt = level;
    }

    public void logLow(String message) {
        this.log(message, LoggingLevel.LOW);
    }

    public void logBasic(String message) {
        this.log(message, LoggingLevel.BASIC);
    }

    public void logDetailed(String message) {
        this.log(message, LoggingLevel.DETAILED);
    }

    public void logDebug(String message) {
        this.log(message, LoggingLevel.DEBUGGING);
    }

    public void logWarning(String message) {
        this.log(message, LoggingLevel.WARNING);
        if (this.m_status) {
            this.statusMessage("WARNING: " + message);
        }
    }

    public void logError(String message, Exception cause) {
        this.log(message, LoggingLevel.ERROR, cause);
        if (this.m_status) {
            this.statusMessage("ERROR: " + message);
        }
    }

    public void statusMessage(String message) {
        if (this.m_log != null) {
            this.m_log.statusMessage(this.statusMessagePrefix() + message);
        }
    }

    public void log(String message, LoggingLevel messageLevel) {
        this.log(message, messageLevel, null);
    }

    protected void log(String message, LoggingLevel messageLevel, Throwable cause) {
        if (messageLevel == LoggingLevel.WARNING || messageLevel == LoggingLevel.ERROR || messageLevel.ordinal() <= this.m_levelToLogAt.ordinal()) {
            String logMessage = "[" + messageLevel.toString() + "] " + this.statusMessagePrefix() + message;
            if (cause != null) {
                logMessage = logMessage + "\n" + LogManager.stackTraceToString(cause);
            }
            if (this.m_log != null) {
                this.m_log.logMessage(logMessage);
                if (messageLevel == LoggingLevel.ERROR || messageLevel == LoggingLevel.WARNING) {
                    this.statusMessage(messageLevel.toString() + " (see log for details)");
                }
            } else {
                System.err.println(logMessage);
            }
        }
    }

    private String statusMessagePrefix() {
        return this.m_statusMessagePrefix;
    }
}

