/*
 * Decompiled with CFR 0.152.
 */
package weka.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import weka.Run;
import weka.core.Capabilities;
import weka.core.CapabilitiesHandler;
import weka.core.ClassDiscovery;
import weka.core.Defaults;
import weka.core.Instances;
import weka.core.OptionHandler;
import weka.core.Trie;
import weka.core.Utils;
import weka.gui.ComponentHelper;
import weka.gui.GUIApplication;
import weka.gui.Logger;
import weka.gui.Perspective;
import weka.gui.PerspectiveInfo;
import weka.gui.knowledgeflow.StepVisual;
import weka.gui.scripting.ScriptingPanel;

@PerspectiveInfo(ID="simplecli", title="Simple CLI", toolTipText="Simple CLI for Weka", iconPath="weka/gui/weka_icon_new_small.png")
public class SimpleCLIPanel
extends ScriptingPanel
implements ActionListener,
Perspective {
    private static final long serialVersionUID = 1089039734615114942L;
    protected static String FILENAME = "SimpleCLI.props";
    protected static String PROPERTY_FILE = "weka/gui/" + FILENAME;
    protected static Properties PROPERTIES;
    protected GUIApplication m_mainApp;
    protected Icon m_perspectiveIcon;
    protected JTextPane m_OutputArea;
    protected JTextField m_Input;
    protected Vector<String> m_CommandHistory;
    protected int m_HistoryPos;
    protected Thread m_RunThread;
    protected CommandlineCompletion m_Completion;

    @Override
    public void instantiationComplete() {
    }

    @Override
    public boolean okToBeActive() {
        return true;
    }

    @Override
    public void setActive(boolean active) {
    }

    @Override
    public void setLoaded(boolean loaded) {
    }

    @Override
    public void setMainApplication(GUIApplication main) {
        this.m_mainApp = main;
    }

    @Override
    public GUIApplication getMainApplication() {
        return this.m_mainApp;
    }

    @Override
    public String getPerspectiveID() {
        return "simplecli";
    }

    @Override
    public String getPerspectiveTitle() {
        return "Simple CLI";
    }

    @Override
    public Icon getPerspectiveIcon() {
        if (this.m_perspectiveIcon != null) {
            return this.m_perspectiveIcon;
        }
        PerspectiveInfo perspectiveA = this.getClass().getAnnotation(PerspectiveInfo.class);
        if (perspectiveA != null && perspectiveA.iconPath() != null && perspectiveA.iconPath().length() > 0) {
            this.m_perspectiveIcon = StepVisual.loadIcon(perspectiveA.iconPath());
        }
        return this.m_perspectiveIcon;
    }

    @Override
    public String getPerspectiveTipText() {
        return "Simple CLI interface for Weka";
    }

    @Override
    public List<JMenu> getMenus() {
        return null;
    }

    @Override
    public Defaults getDefaultSettings() {
        return null;
    }

    @Override
    public void settingsChanged() {
    }

    @Override
    public boolean acceptsInstances() {
        return false;
    }

    @Override
    public void setInstances(Instances instances) {
    }

    @Override
    public boolean requiresLog() {
        return false;
    }

    @Override
    public void setLog(Logger log) {
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_CommandHistory = new Vector();
        this.m_HistoryPos = 0;
        this.m_Completion = new CommandlineCompletion();
    }

    @Override
    protected void initGUI() {
        super.initGUI();
        this.setLayout(new BorderLayout());
        this.m_OutputArea = new JTextPane();
        this.m_OutputArea.setEditable(false);
        this.m_OutputArea.setFont(new Font("Monospaced", 0, 12));
        this.add((Component)new JScrollPane(this.m_OutputArea), "Center");
        this.m_Input = new JTextField();
        this.m_Input.setFont(new Font("Monospaced", 0, 12));
        this.m_Input.addActionListener(this);
        this.m_Input.setFocusTraversalKeysEnabled(false);
        this.m_Input.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                SimpleCLIPanel.this.doHistory(e);
                SimpleCLIPanel.this.doCommandlineCompletion(e);
            }
        });
        this.add((Component)this.m_Input, "South");
    }

    @Override
    protected void initFinish() {
        super.initFinish();
        System.out.println("\nWelcome to the WEKA SimpleCLI\n\nEnter commands in the textfield at the bottom of \nthe window. Use the up and down arrows to move \nthrough previous commands.\nCommand completion for classnames and files is \ninitiated with <Tab>. In order to distinguish \nbetween files and classnames, file names must \nbe either absolute or start with '." + File.separator + "' or '~/'\n(the latter is a shortcut for the home directory).\n<Alt+BackSpace> is used for deleting the text\nin the commandline in chunks.\n");
        try {
            this.runCommand("help");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.loadHistory();
    }

    @Override
    public ImageIcon getIcon() {
        return ComponentHelper.getImageIcon("weka_icon_new_48.png");
    }

    @Override
    public String getTitle() {
        return "SimpleCLI";
    }

    @Override
    public JTextPane getOutput() {
        return this.m_OutputArea;
    }

    @Override
    public JMenuBar getMenuBar() {
        return null;
    }

    public void runCommand(String commands) throws Exception {
        block45: {
            System.out.println("> " + commands + '\n');
            System.out.flush();
            String[] commandArgs = Utils.splitOptions(commands);
            if (commandArgs.length == 0) {
                return;
            }
            if (commandArgs[0].equals("java")) {
                commandArgs[0] = "";
                try {
                    if (commandArgs.length == 1) {
                        throw new Exception("No class name given");
                    }
                    String className = commandArgs[1];
                    commandArgs[1] = "";
                    if (this.m_RunThread != null) {
                        throw new Exception("An object is already running, use \"break\" to interrupt it.");
                    }
                    Class<?> theClass = Class.forName(className);
                    Vector<String> argv = new Vector<String>();
                    for (int i = 2; i < commandArgs.length; ++i) {
                        argv.add(commandArgs[i]);
                    }
                    this.m_RunThread = new ClassRunner(theClass, argv.toArray(new String[argv.size()]));
                    this.m_RunThread.setPriority(1);
                    this.m_RunThread.start();
                }
                catch (Exception ex) {
                    System.err.println(ex.getMessage());
                }
            } else if (commandArgs[0].equals("capabilities")) {
                try {
                    Object obj = Class.forName(commandArgs[1]).newInstance();
                    if (obj instanceof CapabilitiesHandler) {
                        if (obj instanceof OptionHandler) {
                            Vector<String> args = new Vector<String>();
                            for (int i = 2; i < commandArgs.length; ++i) {
                                args.add(commandArgs[i]);
                            }
                            ((OptionHandler)obj).setOptions(args.toArray(new String[args.size()]));
                        }
                        Capabilities caps = ((CapabilitiesHandler)obj).getCapabilities();
                        System.out.println(caps.toString().replace("[", "\n").replace("]", "\n"));
                        break block45;
                    }
                    System.out.println("'" + commandArgs[1] + "' is not a " + CapabilitiesHandler.class.getName() + "!");
                }
                catch (Exception e) {
                    System.err.println(e.getMessage());
                }
            } else if (commandArgs[0].equals("cls")) {
                this.m_OutputArea.setText("");
            } else if (commandArgs[0].equals("history")) {
                System.out.println("Command history:");
                for (int i = 0; i < this.m_CommandHistory.size(); ++i) {
                    System.out.println(this.m_CommandHistory.get(i));
                }
                System.out.println();
            } else if (commandArgs[0].equals("kill")) {
                if (this.m_RunThread == null) {
                    System.err.println("Nothing is currently running.");
                } else {
                    System.out.println("[Kill...]");
                    this.m_RunThread.stop();
                    this.m_RunThread = null;
                }
            } else if (commandArgs[0].equals("exit")) {
                Container parent = this.getParent();
                Container frame = null;
                boolean finished = false;
                while (!finished) {
                    if (parent instanceof JFrame || parent instanceof Frame || parent instanceof JInternalFrame) {
                        frame = parent;
                        finished = true;
                    }
                    if (finished) continue;
                    finished = (parent = parent.getParent()) == null;
                }
                if (frame != null) {
                    if (frame instanceof JInternalFrame) {
                        ((JInternalFrame)frame).doDefaultCloseAction();
                    } else {
                        ((Window)frame).dispatchEvent(new WindowEvent((Window)frame, 201));
                    }
                }
            } else {
                boolean help;
                boolean bl = help = commandArgs.length > 1 && commandArgs[0].equals("help");
                if (help && commandArgs[1].equals("java")) {
                    System.out.println("java <classname> <args>\n\nStarts the main method of <classname> with the supplied command line arguments (if any).\nThe command is started in a separate thread, and may be interrupted with the \"break\"\ncommand (friendly), or killed with the \"kill\" command (unfriendly).\nRedirecting can be done with '>' followed by the file to write to, e.g.:\n  java some.Class > ." + File.separator + "some.txt");
                } else if (help && commandArgs[1].equals("break")) {
                    System.out.println("break\n\nAttempts to nicely interrupt the running job, if any. If this doesn't respond in an\nacceptable time, use \"kill\".\n");
                } else if (help && commandArgs[1].equals("kill")) {
                    System.out.println("kill\n\nKills the running job, if any. You should only use this if the job doesn't respond to\n\"break\".\n");
                } else if (help && commandArgs[1].equals("capabilities")) {
                    System.out.println("capabilities <classname> <args>\n\nLists the capabilities of the specified class.\nIf the class is a " + OptionHandler.class.getName() + " then\ntrailing options after the classname will be\nset as well.\n");
                } else if (help && commandArgs[1].equals("cls")) {
                    System.out.println("cls\n\nClears the output area.\n");
                } else if (help && commandArgs[1].equals("history")) {
                    System.out.println("history\n\nPrints all issued commands.\n");
                } else if (help && commandArgs[1].equals("exit")) {
                    System.out.println("exit\n\nExits the SimpleCLI program.\n");
                } else {
                    System.out.println("Command must be one of:\n\tjava <classname> <args> [ > file]\n\tkill\n\tcapabilities <classname> <args>\n\tcls\n\thistory\n\texit\n\thelp <command>\n");
                }
            }
        }
    }

    public void doHistory(KeyEvent e) {
        if (e.getSource() == this.m_Input) {
            switch (e.getKeyCode()) {
                case 38: {
                    if (this.m_HistoryPos <= 0) break;
                    --this.m_HistoryPos;
                    String command = this.m_CommandHistory.elementAt(this.m_HistoryPos);
                    this.m_Input.setText(command);
                    break;
                }
                case 40: {
                    if (this.m_HistoryPos >= this.m_CommandHistory.size()) break;
                    ++this.m_HistoryPos;
                    String command = "";
                    if (this.m_HistoryPos < this.m_CommandHistory.size()) {
                        command = this.m_CommandHistory.elementAt(this.m_HistoryPos);
                    }
                    this.m_Input.setText(command);
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doCommandlineCompletion(KeyEvent e) {
        if (e.getSource() == this.m_Input) {
            switch (e.getKeyCode()) {
                case 9: {
                    if (e.getModifiers() != 0) break;
                    this.m_Input.setCursor(Cursor.getPredefinedCursor(3));
                    this.m_OutputArea.setCursor(Cursor.getPredefinedCursor(3));
                    try {
                        String txt = this.m_Input.getText();
                        if (!txt.trim().startsWith("java ")) break;
                        int pos = this.m_Input.getCaretPosition();
                        int nonNameCharPos = -1;
                        for (int i = pos - 1; i >= 0; --i) {
                            if (txt.charAt(i) != '\"' && txt.charAt(i) != ' ') continue;
                            nonNameCharPos = i;
                            break;
                        }
                        if (nonNameCharPos <= -1) break;
                        String search = txt.substring(nonNameCharPos + 1, pos);
                        Vector<String> list = this.m_Completion.getMatches(search);
                        String common = this.m_Completion.getCommonPrefix(list);
                        if ((search.toLowerCase() + File.separator).equals(common.toLowerCase())) {
                            common = search;
                        }
                        if (common.length() > search.length()) {
                            try {
                                this.m_Input.getDocument().remove(nonNameCharPos + 1, search.length());
                                this.m_Input.getDocument().insertString(nonNameCharPos + 1, common, null);
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                            }
                            break;
                        }
                        if (list.size() <= 1) break;
                        System.out.println("\nPossible matches:");
                        for (int i = 0; i < list.size(); ++i) {
                            System.out.println("  " + list.get(i));
                        }
                        break;
                    }
                    finally {
                        this.m_Input.setCursor(null);
                        this.m_OutputArea.setCursor(null);
                    }
                }
                case 8: {
                    int pos;
                    if (e.getModifiers() != 8) break;
                    String txt = this.m_Input.getText();
                    int start = pos = this.m_Input.getCaretPosition();
                    --start;
                    while (start >= 0 && (txt.charAt(start) == '.' || txt.charAt(start) == ' ' || txt.charAt(start) == '\\' || txt.charAt(start) == '/')) {
                        --start;
                    }
                    int newPos = -1;
                    for (int i = start; i >= 0; --i) {
                        if (txt.charAt(i) != '.' && txt.charAt(i) != ' ' && txt.charAt(i) != '\\' && txt.charAt(i) != '/') continue;
                        newPos = i;
                        break;
                    }
                    try {
                        this.m_Input.getDocument().remove(newPos + 1, pos - newPos - 1);
                        break;
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (e.getSource() == this.m_Input) {
                String command = this.m_Input.getText();
                int last = this.m_CommandHistory.size() - 1;
                if (last < 0 || !command.equals(this.m_CommandHistory.elementAt(last))) {
                    this.m_CommandHistory.addElement(command);
                    this.saveHistory();
                }
                this.m_HistoryPos = this.m_CommandHistory.size();
                this.runCommand(command);
                this.m_Input.setText("");
            }
        }
        catch (Exception ex) {
            System.err.println(ex.getMessage());
        }
    }

    protected void loadHistory() {
        String cmd;
        int size = Integer.parseInt(PROPERTIES.getProperty("HistorySize", "50"));
        this.m_CommandHistory.clear();
        for (int i = 0; i < size && (cmd = PROPERTIES.getProperty("Command" + i, "")).length() != 0; ++i) {
            this.m_CommandHistory.add(cmd);
        }
        this.m_HistoryPos = this.m_CommandHistory.size();
    }

    protected void saveHistory() {
        int size = Integer.parseInt(PROPERTIES.getProperty("HistorySize", "50"));
        int from = this.m_CommandHistory.size() - size;
        if (from < 0) {
            from = 0;
        }
        PROPERTIES.setProperty("HistorySize", "" + size);
        for (int i = from; i < this.m_CommandHistory.size(); ++i) {
            PROPERTIES.setProperty("Command" + (i - from), this.m_CommandHistory.get(i));
        }
        try {
            String filename = System.getProperties().getProperty("user.home") + File.separatorChar + FILENAME;
            BufferedOutputStream stream = new BufferedOutputStream(new FileOutputStream(filename));
            PROPERTIES.store(stream, "SimpleCLI");
            stream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        SimpleCLIPanel.showPanel(new SimpleCLIPanel(), args);
    }

    static {
        try {
            PROPERTIES = Utils.readProperties(PROPERTY_FILE);
            Enumeration<?> keys = PROPERTIES.propertyNames();
            if (!keys.hasMoreElements()) {
                throw new Exception("Failed to read a property file for the SimpleCLI");
            }
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(null, "Could not read a configuration file for the SimpleCLI.\nAn example file is included with the Weka distribution.\nThis file should be named \"" + PROPERTY_FILE + "\" and\nshould be placed either in your user home (which is set\nto \"" + System.getProperties().getProperty("user.home") + "\")\nor the directory that java was started from\n", "SimpleCLI", 0);
        }
    }

    public static class CommandlineCompletion {
        protected Vector<String> m_Packages;
        protected Trie m_Trie;
        protected boolean m_Debug = false;

        public CommandlineCompletion() {
            if (this.m_Packages == null) {
                Vector<String> list = ClassDiscovery.findPackages();
                HashSet<String> set = new HashSet<String>();
                for (int i = 0; i < list.size(); ++i) {
                    String[] parts = list.get(i).split("\\.");
                    for (int n = 1; n < parts.length; ++n) {
                        String pkg = "";
                        for (int m = 0; m <= n; ++m) {
                            if (m > 0) {
                                pkg = pkg + ".";
                            }
                            pkg = pkg + parts[m];
                        }
                        set.add(pkg);
                    }
                }
                this.m_Packages = new Vector();
                this.m_Packages.addAll(set);
                Collections.sort(this.m_Packages);
                this.m_Trie = new Trie();
                this.m_Trie.addAll((Collection<? extends String>)this.m_Packages);
            }
        }

        public boolean getDebug() {
            return this.m_Debug;
        }

        public void setDebug(boolean value) {
            this.m_Debug = value;
        }

        public boolean isClassname(String partial) {
            return partial.replaceAll("[a-zA-Z0-9\\-\\.]*", "").length() == 0;
        }

        public String getPackage(String partial) {
            String result = "";
            boolean wasDot = false;
            for (int i = 0; i < partial.length(); ++i) {
                char c = partial.charAt(i);
                if (wasDot && c >= 'A' && c <= 'Z') break;
                if (c == '.') {
                    wasDot = true;
                    result = result + "" + c;
                    continue;
                }
                wasDot = false;
                result = result + "" + c;
            }
            if (result.endsWith(".")) {
                result = result.substring(0, result.length() - 1);
            }
            return result;
        }

        public String getClassname(String partial) {
            String pkg = this.getPackage(partial);
            String result = pkg.length() + 1 < partial.length() ? partial.substring(pkg.length() + 1) : "";
            return result;
        }

        public Vector<String> getFileMatches(String partial) {
            int i;
            boolean caseSensitive;
            Vector<String> result = new Vector<String>();
            boolean bl = caseSensitive = File.separatorChar != '\\';
            if (this.m_Debug) {
                System.out.println("case-sensitive=" + caseSensitive);
            }
            if (partial.startsWith("~")) {
                partial = System.getProperty("user.home") + partial.substring(1);
            }
            File file = new File(partial);
            File dir = null;
            String prefix = null;
            if (file.exists()) {
                if (file.isDirectory()) {
                    dir = file;
                    prefix = null;
                } else {
                    dir = file.getParentFile();
                    prefix = file.getName();
                }
            } else {
                dir = file.getParentFile();
                prefix = file.getName();
            }
            if (this.m_Debug) {
                System.out.println("search in dir=" + dir + ", prefix=" + prefix);
            }
            if (dir != null) {
                File[] files = dir.listFiles();
                if (files != null) {
                    for (i = 0; i < files.length; ++i) {
                        String name = files[i].getName();
                        boolean match = prefix != null && caseSensitive ? name.startsWith(prefix) : (prefix != null && !caseSensitive ? name.toLowerCase().startsWith(prefix.toLowerCase()) : true);
                        if (!match) continue;
                        if (prefix != null) {
                            result.add(partial.substring(0, partial.length() - prefix.length()) + name);
                            continue;
                        }
                        if (partial.endsWith("\\") || partial.endsWith("/")) {
                            result.add(partial + name);
                            continue;
                        }
                        result.add(partial + File.separator + name);
                    }
                } else {
                    System.err.println("Invalid path: " + partial);
                }
            }
            if (result.size() > 1) {
                Collections.sort(result);
            }
            if (this.m_Debug) {
                System.out.println("file matches:");
                for (i = 0; i < result.size(); ++i) {
                    System.out.println(result.get(i));
                }
            }
            return result;
        }

        public Vector<String> getClassMatches(String partial) {
            int i;
            Vector<String> list;
            String pkg = this.getPackage(partial);
            String cls = this.getClassname(partial);
            if (this.getDebug()) {
                System.out.println("\nsearch for: '" + partial + "' => package=" + pkg + ", class=" + cls);
            }
            Vector<String> result = new Vector<String>();
            if (cls.length() == 0) {
                list = this.m_Trie.getWithPrefix(pkg);
                HashSet<String> set = new HashSet<String>();
                for (i = 0; i < list.size(); ++i) {
                    String tmpStr = list.get(i);
                    if (tmpStr.length() < partial.length() || tmpStr.equals(partial)) continue;
                    int index = tmpStr.indexOf(46, partial.length() + 1);
                    if (index > -1) {
                        set.add(tmpStr.substring(0, index));
                        continue;
                    }
                    set.add(tmpStr);
                }
                result.addAll(set);
                if (result.size() > 1) {
                    Collections.sort(result);
                }
            }
            list = ClassDiscovery.find(Object.class, pkg);
            Trie tmpTrie = new Trie();
            tmpTrie.addAll((Collection<? extends String>)list);
            list = tmpTrie.getWithPrefix(partial);
            result.addAll(list);
            if (result.size() > 1) {
                Collections.sort(result);
            }
            if (this.m_Debug) {
                System.out.println("class/package matches:");
                for (i = 0; i < result.size(); ++i) {
                    System.out.println(result.get(i));
                }
            }
            return result;
        }

        public Vector<String> getMatches(String partial) {
            if (this.isClassname(partial)) {
                return this.getClassMatches(partial);
            }
            return this.getFileMatches(partial);
        }

        public String getCommonPrefix(Vector<String> list) {
            Trie trie = new Trie();
            trie.addAll((Collection<? extends String>)list);
            String result = trie.getCommonPrefix();
            if (this.m_Debug) {
                System.out.println(list + "\n  --> common prefix: '" + result + "'");
            }
            return result;
        }
    }

    class ClassRunner
    extends Thread {
        protected Method m_MainMethod;
        String[] m_CommandArgs;
        protected boolean m_classIsRun;

        public ClassRunner(Class<?> theClass, String[] commandArgs) throws Exception {
            this.m_classIsRun = theClass == Run.class;
            this.setDaemon(true);
            Class[] argTemplate = new Class[]{String[].class};
            this.m_CommandArgs = commandArgs;
            if (this.m_classIsRun && !commandArgs[0].equalsIgnoreCase("-h") && !commandArgs[0].equalsIgnoreCase("-help")) {
                this.m_CommandArgs = new String[commandArgs.length + 1];
                System.arraycopy(commandArgs, 0, this.m_CommandArgs, 1, commandArgs.length);
                this.m_CommandArgs[0] = "-do-not-prompt-if-multiple-matches";
            }
            this.m_MainMethod = theClass.getMethod("main", argTemplate);
            if ((this.m_MainMethod.getModifiers() & 8) == 0 || (this.m_MainMethod.getModifiers() & 1) == 0) {
                throw new NoSuchMethodException("main(String[]) method of " + theClass.getName() + " is not public and static.");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            String action;
            PrintStream outOld = null;
            PrintStream outNew = null;
            String outFilename = null;
            if (this.m_CommandArgs.length > 2 && (action = this.m_CommandArgs[this.m_CommandArgs.length - 2]).equals(">")) {
                outOld = System.out;
                try {
                    outFilename = this.m_CommandArgs[this.m_CommandArgs.length - 1];
                    if (outFilename.startsWith("~")) {
                        outFilename = outFilename.replaceFirst("~", System.getProperty("user.home"));
                    }
                    outNew = new PrintStream(new File(outFilename));
                    System.setOut(outNew);
                    this.m_CommandArgs[this.m_CommandArgs.length - 2] = "";
                    this.m_CommandArgs[this.m_CommandArgs.length - 1] = "";
                    String[] newArgs = new String[this.m_CommandArgs.length - 2];
                    System.arraycopy(this.m_CommandArgs, 0, newArgs, 0, this.m_CommandArgs.length - 2);
                    this.m_CommandArgs = newArgs;
                }
                catch (Exception e) {
                    System.setOut(outOld);
                    outOld = null;
                }
            }
            try {
                Object[] args = new Object[]{this.m_CommandArgs};
                this.m_MainMethod.invoke(null, args);
                if (this.isInterrupted()) {
                    System.err.println("[...Interrupted]");
                }
            }
            catch (Exception ex) {
                if (ex.getMessage() == null) {
                    System.err.println("[...Killed]");
                } else {
                    System.err.println("[Run exception] " + ex.getMessage());
                }
            }
            finally {
                SimpleCLIPanel.this.m_RunThread = null;
            }
            if (outOld != null) {
                outNew.flush();
                outNew.close();
                System.setOut(outOld);
                System.out.println("Finished redirecting output to '" + outFilename + "'.");
            }
        }
    }
}

