/*
 * Decompiled with CFR 0.152.
 */
package weka.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.regex.Pattern;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;

public class ListSelectorDialog
extends JDialog {
    private static final long serialVersionUID = 906147926840288895L;
    protected JButton m_SelectBut = new JButton("Select");
    protected JButton m_CancelBut = new JButton("Cancel");
    protected JButton m_PatternBut = new JButton("Pattern");
    protected JList m_List;
    protected int m_Result;
    public static final int APPROVE_OPTION = 0;
    public static final int CANCEL_OPTION = 1;
    protected String m_PatternRegEx = ".*";

    public ListSelectorDialog(Frame parentFrame, JList userList) {
        super(parentFrame, "Select items", true);
        this.m_List = userList;
        this.m_CancelBut.setMnemonic('C');
        this.m_CancelBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ListSelectorDialog.this.m_Result = 1;
                ListSelectorDialog.this.setVisible(false);
            }
        });
        this.m_SelectBut.setMnemonic('S');
        this.m_SelectBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ListSelectorDialog.this.m_Result = 0;
                ListSelectorDialog.this.setVisible(false);
            }
        });
        this.m_PatternBut.setMnemonic('P');
        this.m_PatternBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ListSelectorDialog.this.selectPattern();
            }
        });
        Container c = this.getContentPane();
        c.setLayout(new BorderLayout());
        Box b1 = new Box(0);
        b1.add(this.m_SelectBut);
        b1.add(Box.createHorizontalStrut(10));
        b1.add(this.m_PatternBut);
        b1.add(Box.createHorizontalStrut(10));
        b1.add(this.m_CancelBut);
        c.add((Component)b1, "South");
        c.add((Component)new JScrollPane(this.m_List), "Center");
        this.getRootPane().setDefaultButton(this.m_SelectBut);
        this.pack();
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        int width = (double)this.getWidth() > screen.getWidth() ? (int)screen.getWidth() : this.getWidth();
        int height = (double)this.getHeight() > screen.getHeight() ? (int)screen.getHeight() : this.getHeight();
        this.setSize(width, height);
    }

    public int showDialog() {
        this.m_Result = 1;
        int[] origSelected = this.m_List.getSelectedIndices();
        this.setVisible(true);
        if (this.m_Result == 1) {
            this.m_List.setSelectedIndices(origSelected);
        }
        return this.m_Result;
    }

    protected void selectPattern() {
        String pattern = JOptionPane.showInputDialog(this.m_PatternBut.getParent(), "Enter a Perl regular expression ('.*' for all)", this.m_PatternRegEx);
        if (pattern != null) {
            try {
                Pattern.compile(pattern);
                this.m_PatternRegEx = pattern;
                this.m_List.clearSelection();
                for (int i = 0; i < this.m_List.getModel().getSize(); ++i) {
                    if (!Pattern.matches(pattern, this.m_List.getModel().getElementAt(i).toString())) continue;
                    this.m_List.addSelectionInterval(i, i);
                }
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(this.m_PatternBut.getParent(), "'" + pattern + "' is not a valid Perl regular expression!\n" + "Error: " + ex, "Error in Pattern...", 0);
            }
        }
    }

    public static void main(String[] args) {
        try {
            DefaultListModel<String> lm = new DefaultListModel<String>();
            lm.addElement("one");
            lm.addElement("two");
            lm.addElement("three");
            lm.addElement("four");
            lm.addElement("five");
            JList jl = new JList(lm);
            ListSelectorDialog jd = new ListSelectorDialog(null, jl);
            int result = jd.showDialog();
            if (result == 0) {
                System.err.println("Fields Selected");
                int[] selected = jl.getSelectedIndices();
                for (int i = 0; i < selected.length; ++i) {
                    System.err.println("" + selected[i] + " " + lm.elementAt(selected[i]));
                }
            } else {
                System.err.println("Cancelled");
            }
            System.exit(0);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.err.println(ex.getMessage());
        }
    }
}

