/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.supervised.attribute;

import java.util.Enumeration;
import java.util.Vector;
import weka.core.AbstractInstance;
import weka.core.Attribute;
import weka.core.Capabilities;
import weka.core.DenseInstance;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionUtils;
import weka.core.SparseInstance;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.UnassignedClassException;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.SupervisedFilter;

public class NominalToBinary
extends Filter
implements SupervisedFilter,
OptionHandler,
TechnicalInformationHandler {
    static final long serialVersionUID = -5004607029857673950L;
    private int[][] m_Indices = null;
    private boolean m_Numeric = true;
    private boolean m_TransformAll = false;

    public String globalInfo() {
        return "Converts all nominal attributes into binary numeric attributes. An attribute with k values is transformed into k binary attributes if the class is nominal (using the one-attribute-per-value approach). Binary attributes are left binary, if option '-A' is not given.If the class is numeric, k - 1 new binary attributes are generated in the manner described in \"Classification and Regression Trees\" by Breiman et al. (i.e. taking the average class value associated with each attribute value into account)\n\nFor more information, see:\n\n" + this.getTechnicalInformation().toString();
    }

    @Override
    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.BOOK);
        result.setValue(TechnicalInformation.Field.AUTHOR, "L. Breiman and J.H. Friedman and R.A. Olshen and C.J. Stone");
        result.setValue(TechnicalInformation.Field.TITLE, "Classification and Regression Trees");
        result.setValue(TechnicalInformation.Field.YEAR, "1984");
        result.setValue(TechnicalInformation.Field.PUBLISHER, "Wadsworth Inc");
        result.setValue(TechnicalInformation.Field.ISBN, "0412048418");
        return result;
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAll();
        result.enableAllAttributes();
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enable(Capabilities.Capability.NUMERIC_CLASS);
        result.enable(Capabilities.Capability.DATE_CLASS);
        result.enable(Capabilities.Capability.NOMINAL_CLASS);
        return result;
    }

    @Override
    public boolean setInputFormat(Instances instanceInfo) throws Exception {
        super.setInputFormat(instanceInfo);
        if (instanceInfo.classIndex() < 0) {
            throw new UnassignedClassException("No class has been assigned to the instances");
        }
        this.setOutputFormat();
        this.m_Indices = null;
        return instanceInfo.classAttribute().isNominal();
    }

    @Override
    public boolean input(Instance instance) {
        if (this.getInputFormat() == null) {
            throw new IllegalStateException("No input instance format defined");
        }
        if (this.m_NewBatch) {
            this.resetQueue();
            this.m_NewBatch = false;
        }
        if (this.m_Indices != null || this.getInputFormat().classAttribute().isNominal()) {
            this.convertInstance(instance);
            return true;
        }
        this.bufferInput(instance);
        return false;
    }

    @Override
    public boolean batchFinished() {
        if (this.getInputFormat() == null) {
            throw new IllegalStateException("No input instance format defined");
        }
        if (this.m_Indices == null && this.getInputFormat().classAttribute().isNumeric()) {
            this.computeAverageClassValues();
            this.setOutputFormat();
            for (int i = 0; i < this.getInputFormat().numInstances(); ++i) {
                this.convertInstance(this.getInputFormat().instance(i));
            }
        }
        this.flushInput();
        this.m_NewBatch = true;
        return this.numPendingOutput() != 0;
    }

    @Override
    public Enumeration listOptions() {
        Vector<Option> newVector = new Vector<Option>(1);
        newVector.addElement(new Option("\tSets if binary attributes are to be coded as nominal ones.", "N", 0, "-N"));
        newVector.addElement(new Option("\tFor each nominal value a new attribute is created, \n\tnot only if there are more than 2 values.", "A", 0, "-A"));
        return newVector.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        this.setBinaryAttributesNominal(Utils.getFlag('N', options));
        this.setTransformAllValues(Utils.getFlag('A', options));
        if (this.getInputFormat() != null) {
            this.setInputFormat(this.getInputFormat());
        }
    }

    @Override
    public String[] getOptions() {
        String[] options = new String[1];
        int current = 0;
        if (this.getBinaryAttributesNominal()) {
            options[current++] = "-N";
        }
        if (this.getTransformAllValues()) {
            options[current++] = "-A";
        }
        while (current < options.length) {
            options[current++] = "";
        }
        return options;
    }

    public String binaryAttributesNominalTipText() {
        return "Whether resulting binary attributes will be nominal.";
    }

    public boolean getBinaryAttributesNominal() {
        return !this.m_Numeric;
    }

    public void setBinaryAttributesNominal(boolean bool) {
        this.m_Numeric = !bool;
    }

    public String transformAllValuesTipText() {
        return "Whether all nominal values are turned into new attributes, not only if there are more than 2.";
    }

    public boolean getTransformAllValues() {
        return this.m_TransformAll;
    }

    public void setTransformAllValues(boolean bool) {
        this.m_TransformAll = bool;
    }

    private void computeAverageClassValues() {
        double[][] avgClassValues = new double[this.getInputFormat().numAttributes()][0];
        this.m_Indices = new int[this.getInputFormat().numAttributes()][0];
        for (int j = 0; j < this.getInputFormat().numAttributes(); ++j) {
            Attribute att = this.getInputFormat().attribute(j);
            if (!att.isNominal()) continue;
            avgClassValues[j] = new double[att.numValues()];
            double[] counts = new double[att.numValues()];
            for (int i = 0; i < this.getInputFormat().numInstances(); ++i) {
                Instance instance = this.getInputFormat().instance(i);
                if (instance.classIsMissing() || instance.isMissing(j)) continue;
                int n = (int)instance.value(j);
                counts[n] = counts[n] + instance.weight();
                double[] dArray = avgClassValues[j];
                int n2 = (int)instance.value(j);
                dArray[n2] = dArray[n2] + instance.weight() * instance.classValue();
            }
            double sum = Utils.sum(avgClassValues[j]);
            double totalCounts = Utils.sum(counts);
            if (Utils.gr(totalCounts, 0.0)) {
                for (int k = 0; k < att.numValues(); ++k) {
                    if (Utils.gr(counts[k], 0.0)) {
                        double[] dArray = avgClassValues[j];
                        int n = k;
                        dArray[n] = dArray[n] / counts[k];
                        continue;
                    }
                    avgClassValues[j][k] = sum / totalCounts;
                }
            }
            this.m_Indices[j] = Utils.sort(avgClassValues[j]);
        }
    }

    private void setOutputFormat() {
        if (this.getInputFormat().classAttribute().isNominal()) {
            this.setOutputFormatNominal();
        } else {
            this.setOutputFormatNumeric();
        }
    }

    private void convertInstance(Instance inst) {
        if (this.getInputFormat().classAttribute().isNominal()) {
            this.convertInstanceNominal(inst);
        } else {
            this.convertInstanceNumeric(inst);
        }
    }

    private void setOutputFormatNominal() {
        int newClassIndex = this.getInputFormat().classIndex();
        FastVector<Attribute> newAtts = new FastVector<Attribute>();
        for (int j = 0; j < this.getInputFormat().numAttributes(); ++j) {
            Attribute att = this.getInputFormat().attribute(j);
            if (!att.isNominal() || j == this.getInputFormat().classIndex()) {
                newAtts.addElement((Attribute)att.copy());
                continue;
            }
            if (att.numValues() <= 2 && !this.m_TransformAll) {
                if (this.m_Numeric) {
                    newAtts.addElement(new Attribute(att.name()));
                    continue;
                }
                newAtts.addElement((Attribute)att.copy());
                continue;
            }
            if (j < this.getInputFormat().classIndex()) {
                newClassIndex += att.numValues() - 1;
            }
            for (int k = 0; k < att.numValues(); ++k) {
                StringBuffer attributeName = new StringBuffer(att.name() + "=");
                attributeName.append(att.value(k));
                if (this.m_Numeric) {
                    newAtts.addElement(new Attribute(attributeName.toString()));
                    continue;
                }
                FastVector<String> vals = new FastVector<String>(2);
                vals.addElement("f");
                vals.addElement("t");
                newAtts.addElement(new Attribute(attributeName.toString(), vals));
            }
        }
        Instances outputFormat = new Instances(this.getInputFormat().relationName(), newAtts, 0);
        outputFormat.setClassIndex(newClassIndex);
        this.setOutputFormat(outputFormat);
    }

    private void setOutputFormatNumeric() {
        if (this.m_Indices == null) {
            this.setOutputFormat(null);
            return;
        }
        int newClassIndex = this.getInputFormat().classIndex();
        FastVector<Attribute> newAtts = new FastVector<Attribute>();
        for (int j = 0; j < this.getInputFormat().numAttributes(); ++j) {
            Attribute att = this.getInputFormat().attribute(j);
            if (!att.isNominal() || j == this.getInputFormat().classIndex()) {
                newAtts.addElement((Attribute)att.copy());
                continue;
            }
            if (j < this.getInputFormat().classIndex()) {
                newClassIndex += att.numValues() - 2;
            }
            for (int k = 1; k < att.numValues(); ++k) {
                StringBuffer attributeName = new StringBuffer(att.name() + "=");
                for (int l = k; l < att.numValues(); ++l) {
                    if (l > k) {
                        attributeName.append(',');
                    }
                    attributeName.append(att.value(this.m_Indices[j][l]));
                }
                if (this.m_Numeric) {
                    newAtts.addElement(new Attribute(attributeName.toString()));
                    continue;
                }
                FastVector<String> vals = new FastVector<String>(2);
                vals.addElement("f");
                vals.addElement("t");
                newAtts.addElement(new Attribute(attributeName.toString(), vals));
            }
        }
        Instances outputFormat = new Instances(this.getInputFormat().relationName(), newAtts, 0);
        outputFormat.setClassIndex(newClassIndex);
        this.setOutputFormat(outputFormat);
    }

    private void convertInstanceNominal(Instance instance) {
        double[] vals = new double[this.outputFormatPeek().numAttributes()];
        int attSoFar = 0;
        for (int j = 0; j < this.getInputFormat().numAttributes(); ++j) {
            int k;
            Attribute att = this.getInputFormat().attribute(j);
            if (!att.isNominal() || j == this.getInputFormat().classIndex()) {
                vals[attSoFar] = instance.value(j);
                ++attSoFar;
                continue;
            }
            if (att.numValues() <= 2 && !this.m_TransformAll) {
                vals[attSoFar] = instance.value(j);
                ++attSoFar;
                continue;
            }
            if (instance.isMissing(j)) {
                for (k = 0; k < att.numValues(); ++k) {
                    vals[attSoFar + k] = instance.value(j);
                }
            } else {
                for (k = 0; k < att.numValues(); ++k) {
                    vals[attSoFar + k] = k == (int)instance.value(j) ? 1.0 : 0.0;
                }
            }
            attSoFar += att.numValues();
        }
        AbstractInstance inst = null;
        inst = instance instanceof SparseInstance ? new SparseInstance(instance.weight(), vals) : new DenseInstance(instance.weight(), vals);
        inst.setDataset(this.getOutputFormat());
        this.copyValues(inst, false, instance.dataset(), this.getOutputFormat());
        inst.setDataset(this.getOutputFormat());
        this.push(inst);
    }

    private void convertInstanceNumeric(Instance instance) {
        double[] vals = new double[this.outputFormatPeek().numAttributes()];
        int attSoFar = 0;
        for (int j = 0; j < this.getInputFormat().numAttributes(); ++j) {
            int k;
            Attribute att = this.getInputFormat().attribute(j);
            if (!att.isNominal() || j == this.getInputFormat().classIndex()) {
                vals[attSoFar] = instance.value(j);
                ++attSoFar;
                continue;
            }
            if (instance.isMissing(j)) {
                for (k = 0; k < att.numValues() - 1; ++k) {
                    vals[attSoFar + k] = instance.value(j);
                }
            } else {
                k = 0;
                while ((int)instance.value(j) != this.m_Indices[j][k]) {
                    vals[attSoFar + k] = 1.0;
                    ++k;
                }
                while (k < att.numValues() - 1) {
                    vals[attSoFar + k] = 0.0;
                    ++k;
                }
            }
            attSoFar += att.numValues() - 1;
        }
        AbstractInstance inst = null;
        inst = instance instanceof SparseInstance ? new SparseInstance(instance.weight(), vals) : new DenseInstance(instance.weight(), vals);
        inst.setDataset(this.getOutputFormat());
        this.copyValues(inst, false, instance.dataset(), this.getOutputFormat());
        inst.setDataset(this.getOutputFormat());
        this.push(inst);
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 5987 $");
    }

    public static void main(String[] argv) {
        NominalToBinary.runFilter(new NominalToBinary(), argv);
    }
}

