/*
 * Decompiled with CFR 0.152.
 */
package weka.core.pmml;

import java.util.ArrayList;
import weka.core.Attribute;
import weka.core.Utils;
import weka.core.pmml.Function;

public class BuiltInMath
extends Function {
    private static final long serialVersionUID = -8092338695602573652L;
    protected MathFunc m_func = MathFunc.ABS;

    public BuiltInMath(MathFunc func) {
        this.m_func = func;
        this.m_functionName = this.m_func.toString();
    }

    @Override
    public void setParameterDefs(ArrayList<Attribute> paramDefs) throws Exception {
        this.m_parameterDefs = paramDefs;
        if (!this.m_func.legalNumParams(this.m_parameterDefs.size())) {
            throw new Exception("[BuiltInMath] illegal number of parameters for function: " + this.m_functionName);
        }
    }

    @Override
    public Attribute getOutputDef() {
        return new Attribute("BuiltInMathResult:" + this.m_func.toString());
    }

    @Override
    public String[] getParameterNames() {
        return this.m_func.getParameterNames();
    }

    @Override
    public double getResult(double[] incoming) throws Exception {
        if (this.m_parameterDefs == null) {
            throw new Exception("[BuiltInMath] incoming parameter structure has not been set");
        }
        if (!this.m_func.legalNumParams(incoming.length)) {
            throw new Exception("[BuiltInMath] wrong number of parameters!");
        }
        double result = this.m_func.eval(incoming);
        return result;
    }

    @Override
    public String toString() {
        String result = this.m_func.toString() + "(";
        for (int i = 0; i < this.m_parameterDefs.size(); ++i) {
            result = result + ((Attribute)this.m_parameterDefs.get(i)).name();
            result = i != this.m_parameterDefs.size() - 1 ? result + ", " : result + ")";
        }
        return result;
    }

    static enum MathFunc {
        MIN("min"){

            @Override
            double eval(double[] args) {
                return args[Utils.minIndex(args)];
            }

            @Override
            boolean legalNumParams(int num) {
                return num > 0;
            }

            @Override
            String[] getParameterNames() {
                return null;
            }
        }
        ,
        MAX("max"){

            @Override
            double eval(double[] args) {
                return args[Utils.maxIndex(args)];
            }

            @Override
            boolean legalNumParams(int num) {
                return num > 0;
            }

            @Override
            String[] getParameterNames() {
                return null;
            }
        }
        ,
        SUM("sum"){

            @Override
            double eval(double[] args) {
                return Utils.sum(args);
            }

            @Override
            boolean legalNumParams(int num) {
                return num > 0;
            }

            @Override
            String[] getParameterNames() {
                return null;
            }
        }
        ,
        AVG("avg"){

            @Override
            double eval(double[] args) {
                return Utils.mean(args);
            }

            @Override
            boolean legalNumParams(int num) {
                return num > 0;
            }

            @Override
            String[] getParameterNames() {
                return null;
            }
        }
        ,
        LOG10("log10"){

            @Override
            double eval(double[] args) {
                return Math.log10(args[0]);
            }

            @Override
            boolean legalNumParams(int num) {
                return num == 1;
            }

            @Override
            String[] getParameterNames() {
                return new String[]{"A"};
            }
        }
        ,
        LN("ln"){

            @Override
            double eval(double[] args) {
                return Math.log(args[0]);
            }

            @Override
            boolean legalNumParams(int num) {
                return num == 1;
            }

            @Override
            String[] getParameterNames() {
                return new String[]{"A"};
            }
        }
        ,
        SQRT("sqrt"){

            @Override
            double eval(double[] args) {
                return Math.sqrt(args[0]);
            }

            @Override
            boolean legalNumParams(int num) {
                return num == 1;
            }

            @Override
            String[] getParameterNames() {
                return new String[]{"A"};
            }
        }
        ,
        ABS("abs"){

            @Override
            double eval(double[] args) {
                return Math.abs(args[0]);
            }

            @Override
            boolean legalNumParams(int num) {
                return num == 1;
            }

            @Override
            String[] getParameterNames() {
                return new String[]{"A"};
            }
        }
        ,
        EXP("exp"){

            @Override
            double eval(double[] args) {
                return Math.exp(args[0]);
            }

            @Override
            boolean legalNumParams(int num) {
                return num == 1;
            }

            @Override
            String[] getParameterNames() {
                return new String[]{"A"};
            }
        }
        ,
        POW("pow"){

            @Override
            double eval(double[] args) {
                return Math.pow(args[0], args[1]);
            }

            @Override
            boolean legalNumParams(int num) {
                return num == 2;
            }

            @Override
            String[] getParameterNames() {
                return new String[]{"A", "B"};
            }
        }
        ,
        THRESHOLD("threshold"){

            @Override
            double eval(double[] args) {
                if (args[0] > args[1]) {
                    return 1.0;
                }
                return 0.0;
            }

            @Override
            boolean legalNumParams(int num) {
                return num == 2;
            }

            @Override
            String[] getParameterNames() {
                return new String[]{"A", "B"};
            }
        }
        ,
        FLOOR("floor"){

            @Override
            double eval(double[] args) {
                return Math.floor(args[0]);
            }

            @Override
            boolean legalNumParams(int num) {
                return num == 1;
            }

            @Override
            String[] getParameterNames() {
                return new String[]{"A"};
            }
        }
        ,
        CEIL("ceil"){

            @Override
            double eval(double[] args) {
                return Math.ceil(args[0]);
            }

            @Override
            boolean legalNumParams(int num) {
                return num == 1;
            }

            @Override
            String[] getParameterNames() {
                return new String[]{"A"};
            }
        }
        ,
        ROUND("round"){

            @Override
            double eval(double[] args) {
                return Math.round(args[0]);
            }

            @Override
            boolean legalNumParams(int num) {
                return num == 1;
            }

            @Override
            String[] getParameterNames() {
                return new String[]{"A"};
            }
        };

        private final String m_stringVal;

        abstract double eval(double[] var1);

        abstract boolean legalNumParams(int var1);

        abstract String[] getParameterNames();

        private MathFunc(String funcName) {
            this.m_stringVal = funcName;
        }

        public String toString() {
            return this.m_stringVal;
        }
    }
}

