/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.beans;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.BeanInfo;
import java.beans.EventSetDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JWindow;
import javax.swing.Timer;
import weka.gui.Logger;
import weka.gui.beans.BeanCommon;
import weka.gui.beans.BeanInstance;
import weka.gui.beans.BeanVisual;
import weka.gui.beans.EventConstraints;
import weka.gui.beans.Startable;
import weka.gui.beans.UserRequestAcceptor;
import weka.gui.beans.Visible;

public class MetaBean
extends JPanel
implements BeanCommon,
Visible,
EventConstraints,
Serializable,
UserRequestAcceptor {
    private static final long serialVersionUID = -6582768902038027077L;
    protected BeanVisual m_visual = new BeanVisual("Group", "weka/gui/beans/icons/DiamondPlain.gif", "weka/gui/beans/icons/DiamondPlain.gif");
    private transient Logger m_log = null;
    private transient JWindow m_previewWindow = null;
    private transient Timer m_previewTimer = null;
    protected Vector m_subFlow = new Vector();
    protected Vector m_inputs = new Vector();
    protected Vector m_outputs = new Vector();
    protected Vector m_associatedConnections = new Vector();
    protected ImageIcon m_subFlowPreview = null;
    private Vector m_originalCoords;

    public MetaBean() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.m_visual, "Center");
    }

    public void setCustomName(String name) {
        this.m_visual.setText(name);
    }

    public String getCustomName() {
        return this.m_visual.getText();
    }

    public void setAssociatedConnections(Vector ac) {
        this.m_associatedConnections = ac;
    }

    public Vector getAssociatedConnections() {
        return this.m_associatedConnections;
    }

    public void setSubFlow(Vector sub) {
        this.m_subFlow = sub;
    }

    public Vector getSubFlow() {
        return this.m_subFlow;
    }

    public void setInputs(Vector inputs) {
        this.m_inputs = inputs;
    }

    public Vector getInputs() {
        return this.m_inputs;
    }

    public void setOutputs(Vector outputs) {
        this.m_outputs = outputs;
    }

    public Vector getOutputs() {
        return this.m_outputs;
    }

    private Vector getBeans(Vector beans, int type) {
        Vector<BeanInstance> comps = new Vector<BeanInstance>();
        for (int i = 0; i < beans.size(); ++i) {
            BeanInstance temp = (BeanInstance)beans.elementAt(i);
            if (temp.getBean() instanceof MetaBean) {
                switch (type) {
                    case 0: {
                        comps.addAll(((MetaBean)temp.getBean()).getBeansInSubFlow());
                        break;
                    }
                    case 1: {
                        comps.addAll(((MetaBean)temp.getBean()).getBeansInInputs());
                        break;
                    }
                    case 2: {
                        comps.addAll(((MetaBean)temp.getBean()).getBeansInOutputs());
                    }
                }
                continue;
            }
            comps.add(temp);
        }
        return comps;
    }

    private boolean beanSetContains(Vector set, BeanInstance toCheck) {
        boolean ok = false;
        for (int i = 0; i < set.size(); ++i) {
            BeanInstance temp = (BeanInstance)set.elementAt(i);
            if (toCheck != temp) continue;
            ok = true;
            break;
        }
        return ok;
    }

    public boolean subFlowContains(BeanInstance toCheck) {
        return this.beanSetContains(this.m_subFlow, toCheck);
    }

    public boolean inputsContains(BeanInstance toCheck) {
        return this.beanSetContains(this.m_inputs, toCheck);
    }

    public boolean outputsContains(BeanInstance toCheck) {
        return this.beanSetContains(this.m_outputs, toCheck);
    }

    public Vector getBeansInSubFlow() {
        return this.getBeans(this.m_subFlow, 0);
    }

    public Vector getBeansInInputs() {
        return this.getBeans(this.m_inputs, 1);
    }

    public Vector getBeansInOutputs() {
        return this.getBeans(this.m_outputs, 2);
    }

    private Vector getBeanInfos(Vector beans, int type) {
        Vector<BeanInfo> infos = new Vector<BeanInfo>();
        for (int i = 0; i < beans.size(); ++i) {
            BeanInstance temp = (BeanInstance)beans.elementAt(i);
            if (temp.getBean() instanceof MetaBean) {
                switch (type) {
                    case 0: {
                        infos.addAll(((MetaBean)temp.getBean()).getBeanInfoSubFlow());
                        break;
                    }
                    case 1: {
                        infos.addAll(((MetaBean)temp.getBean()).getBeanInfoInputs());
                        break;
                    }
                    case 2: {
                        infos.addAll(((MetaBean)temp.getBean()).getBeanInfoOutputs());
                    }
                }
                continue;
            }
            try {
                infos.add(Introspector.getBeanInfo(temp.getBean().getClass()));
                continue;
            }
            catch (IntrospectionException ex) {
                ex.printStackTrace();
            }
        }
        return infos;
    }

    public Vector getBeanInfoSubFlow() {
        return this.getBeanInfos(this.m_subFlow, 0);
    }

    public Vector getBeanInfoInputs() {
        return this.getBeanInfos(this.m_inputs, 1);
    }

    public Vector getBeanInfoOutputs() {
        return this.getBeanInfos(this.m_outputs, 2);
    }

    public Vector getOriginalCoords() {
        return this.m_originalCoords;
    }

    public void setOriginalCoords(Vector value) {
        this.m_originalCoords = value;
    }

    public void shiftBeans(BeanInstance toShiftTo, boolean save) {
        if (save) {
            this.m_originalCoords = new Vector();
        }
        int targetX = toShiftTo.getX();
        int targetY = toShiftTo.getY();
        for (int i = 0; i < this.m_subFlow.size(); ++i) {
            BeanInstance temp = (BeanInstance)this.m_subFlow.elementAt(i);
            if (save) {
                Point p = new Point(temp.getX(), temp.getY());
                this.m_originalCoords.add(p);
            }
            temp.setX(targetX);
            temp.setY(targetY);
        }
    }

    public void restoreBeans() {
        for (int i = 0; i < this.m_subFlow.size(); ++i) {
            BeanInstance temp = (BeanInstance)this.m_subFlow.elementAt(i);
            Point p = (Point)this.m_originalCoords.elementAt(i);
            JComponent c = (JComponent)temp.getBean();
            Dimension d = c.getPreferredSize();
            int dx = (int)(d.getWidth() / 2.0);
            int dy = (int)(d.getHeight() / 2.0);
            temp.setX((int)p.getX() + dx);
            temp.setY((int)p.getY() + dy);
        }
    }

    public boolean eventGeneratable(EventSetDescriptor esd) {
        String eventName = esd.getName();
        return this.eventGeneratable(eventName);
    }

    public boolean eventGeneratable(String eventName) {
        for (int i = 0; i < this.m_subFlow.size(); ++i) {
            BeanInstance output = (BeanInstance)this.m_subFlow.elementAt(i);
            if (!(output.getBean() instanceof EventConstraints) || !((EventConstraints)output.getBean()).eventGeneratable(eventName)) continue;
            return true;
        }
        return false;
    }

    public boolean connectionAllowed(EventSetDescriptor esd) {
        Vector targets = this.getSuitableTargets(esd);
        for (int i = 0; i < targets.size(); ++i) {
            BeanInstance input = (BeanInstance)targets.elementAt(i);
            if (input.getBean() instanceof BeanCommon) {
                if (!((BeanCommon)input.getBean()).connectionAllowed(esd)) continue;
                return true;
            }
            return true;
        }
        return false;
    }

    public boolean connectionAllowed(String eventName) {
        return false;
    }

    public synchronized void connectionNotification(String eventName, Object source) {
    }

    public synchronized void disconnectionNotification(String eventName, Object source) {
    }

    public void stop() {
        for (int i = 0; i < this.m_inputs.size(); ++i) {
            Object temp = this.m_inputs.elementAt(i);
            if (!(temp instanceof BeanCommon)) continue;
            ((BeanCommon)temp).stop();
        }
    }

    public boolean isBusy() {
        boolean result = false;
        for (int i = 0; i < this.m_subFlow.size(); ++i) {
            Object temp = this.m_subFlow.elementAt(i);
            if (!(temp instanceof BeanCommon) || !((BeanCommon)temp).isBusy()) continue;
            result = true;
            break;
        }
        return result;
    }

    public void setVisual(BeanVisual newVisual) {
        this.m_visual = newVisual;
    }

    public BeanVisual getVisual() {
        return this.m_visual;
    }

    public void useDefaultVisual() {
        this.m_visual.loadIcons("weka/gui/beans/icons/DiamondPlain.gif", "weka/gui/beans/icons/DiamondPlain.gif");
    }

    public Enumeration enumerateRequests() {
        Vector<String> newVector = new Vector<String>();
        if (this.m_subFlowPreview != null) {
            String text = "Show preview";
            if (this.m_previewWindow != null) {
                text = "$" + text;
            }
            newVector.addElement(text);
        }
        for (int i = 0; i < this.m_subFlow.size(); ++i) {
            String prefix;
            BeanInstance temp = (BeanInstance)this.m_subFlow.elementAt(i);
            if (temp.getBean() instanceof UserRequestAcceptor) {
                prefix = "";
                if (temp.getBean() instanceof BeanCommon) {
                    prefix = ((BeanCommon)temp.getBean()).getCustomName();
                } else {
                    prefix = temp.getBean().getClass().getName();
                    prefix = prefix.substring(prefix.lastIndexOf(46) + 1, prefix.length());
                }
                prefix = "" + (i + 1) + ": (" + prefix + ")";
                Enumeration en = ((UserRequestAcceptor)temp.getBean()).enumerateRequests();
                while (en.hasMoreElements()) {
                    String req = (String)en.nextElement();
                    if (req.charAt(0) == '$') {
                        prefix = '$' + prefix;
                        req = req.substring(1, req.length());
                    }
                    if (req.charAt(0) == '?') {
                        prefix = '?' + prefix;
                        req = req.substring(1, req.length());
                    }
                    newVector.add(prefix + " " + req);
                }
                continue;
            }
            if (!(temp.getBean() instanceof Startable)) continue;
            prefix = "";
            if (temp.getBean() instanceof BeanCommon) {
                prefix = ((BeanCommon)temp.getBean()).getCustomName();
            } else {
                prefix = temp.getBean().getClass().getName();
                prefix = prefix.substring(prefix.lastIndexOf(46) + 1, prefix.length());
            }
            prefix = "" + (i + 1) + ": (" + prefix + ")";
            String startMessage = ((Startable)temp.getBean()).getStartMessage();
            if (startMessage.charAt(0) == '$') {
                prefix = '$' + prefix;
                startMessage = startMessage.substring(1, startMessage.length());
            }
            newVector.add(prefix + " " + startMessage);
        }
        return newVector.elements();
    }

    public void setSubFlowPreview(ImageIcon sfp) {
        this.m_subFlowPreview = sfp;
    }

    private void showPreview() {
        if (this.m_previewWindow == null) {
            JLabel jl = new JLabel(this.m_subFlowPreview);
            jl.setLocation(0, 0);
            this.m_previewWindow = new JWindow();
            this.m_previewWindow.getContentPane().add(jl);
            this.m_previewWindow.validate();
            this.m_previewWindow.setSize(this.m_subFlowPreview.getIconWidth(), this.m_subFlowPreview.getIconHeight());
            this.m_previewWindow.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent e) {
                    MetaBean.this.m_previewWindow.dispose();
                    MetaBean.this.m_previewWindow = null;
                }
            });
            this.m_previewWindow.setLocation(this.getParent().getLocationOnScreen().x + this.getX() + this.getWidth() / 2 - this.m_subFlowPreview.getIconWidth() / 2, this.getParent().getLocationOnScreen().y + this.getY() + this.getHeight() / 2 - this.m_subFlowPreview.getIconHeight() / 2);
            this.m_previewWindow.setVisible(true);
            this.m_previewTimer = new Timer(8000, new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (MetaBean.this.m_previewWindow != null) {
                        MetaBean.this.m_previewWindow.dispose();
                        MetaBean.this.m_previewWindow = null;
                        MetaBean.this.m_previewTimer = null;
                    }
                }
            });
            this.m_previewTimer.setRepeats(false);
            this.m_previewTimer.start();
        }
    }

    public void performRequest(String request) {
        Object target;
        if (request.compareTo("Show preview") == 0) {
            this.showPreview();
            return;
        }
        if (request.indexOf(":") < 0) {
            return;
        }
        String tempI = request.substring(0, request.indexOf(58));
        int index = Integer.parseInt(tempI);
        String req = request.substring(request.indexOf(41) + 1, request.length()).trim();
        if ((target = ((BeanInstance)this.m_subFlow.elementAt(--index)).getBean()) instanceof Startable && req.equals(((Startable)target).getStartMessage())) {
            try {
                ((Startable)target).start();
            }
            catch (Exception ex) {
                if (this.m_log != null) {
                    String compName = target instanceof BeanCommon ? ((BeanCommon)target).getCustomName() : "";
                    this.m_log.logMessage("Problem starting subcomponent " + compName);
                }
            }
        } else {
            ((UserRequestAcceptor)target).performRequest(req);
        }
    }

    public void setLog(Logger logger) {
        this.m_log = logger;
    }

    public void removePropertyChangeListenersSubFlow(PropertyChangeListener pcl) {
        for (int i = 0; i < this.m_subFlow.size(); ++i) {
            BeanInstance temp = (BeanInstance)this.m_subFlow.elementAt(i);
            if (temp.getBean() instanceof Visible) {
                ((Visible)temp.getBean()).getVisual().removePropertyChangeListener(pcl);
            }
            if (!(temp.getBean() instanceof MetaBean)) continue;
            ((MetaBean)temp.getBean()).removePropertyChangeListenersSubFlow(pcl);
        }
    }

    public void addPropertyChangeListenersSubFlow(PropertyChangeListener pcl) {
        for (int i = 0; i < this.m_subFlow.size(); ++i) {
            BeanInstance temp = (BeanInstance)this.m_subFlow.elementAt(i);
            if (temp.getBean() instanceof Visible) {
                ((Visible)temp.getBean()).getVisual().addPropertyChangeListener(pcl);
            }
            if (!(temp.getBean() instanceof MetaBean)) continue;
            ((MetaBean)temp.getBean()).addPropertyChangeListenersSubFlow(pcl);
        }
    }

    public boolean canAcceptConnection(Class listenerClass) {
        for (int i = 0; i < this.m_inputs.size(); ++i) {
            BeanInstance input = (BeanInstance)this.m_inputs.elementAt(i);
            if (!listenerClass.isInstance(input.getBean())) continue;
            return true;
        }
        return false;
    }

    public Vector getSuitableTargets(EventSetDescriptor esd) {
        Class<?> listenerClass = esd.getListenerType();
        Vector<BeanInstance> targets = new Vector<BeanInstance>();
        for (int i = 0; i < this.m_inputs.size(); ++i) {
            BeanInstance input = (BeanInstance)this.m_inputs.elementAt(i);
            if (!listenerClass.isInstance(input.getBean())) continue;
            targets.add(input);
        }
        return targets;
    }
}

