/*
 * Decompiled with CFR 0.152.
 */
package weka.core.pmml;

import java.io.Serializable;
import java.util.ArrayList;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import weka.core.Attribute;
import weka.core.pmml.Apply;
import weka.core.pmml.Constant;
import weka.core.pmml.Discretize;
import weka.core.pmml.FieldMetaInfo;
import weka.core.pmml.FieldRef;
import weka.core.pmml.NormContinuous;
import weka.core.pmml.NormDiscrete;
import weka.core.pmml.TransformationDictionary;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Expression
implements Serializable {
    private static final long serialVersionUID = 4448840549804800321L;
    protected FieldMetaInfo.Optype m_opType;
    protected ArrayList<Attribute> m_fieldDefs = null;

    public Expression(FieldMetaInfo.Optype opType, ArrayList<Attribute> fieldDefs) {
        this.m_opType = opType;
        this.m_fieldDefs = fieldDefs;
    }

    public void setFieldDefs(ArrayList<Attribute> fieldDefs) throws Exception {
        this.m_fieldDefs = fieldDefs;
    }

    public abstract double getResult(double[] var1) throws Exception;

    public double getResultContinuous(double[] incoming) throws Exception {
        if (this.m_opType != FieldMetaInfo.Optype.CONTINUOUS) {
            throw new Exception("[Expression] Can't return continuous result as optype is not continuous");
        }
        return this.getResult(incoming);
    }

    public abstract String getResultCategorical(double[] var1) throws Exception;

    protected abstract Attribute getOutputDef();

    public static Expression getExpression(Node container, FieldMetaInfo.Optype opType, ArrayList<Attribute> fieldDefs, TransformationDictionary transDict) throws Exception {
        Node child;
        Expression result = null;
        String tagName = "";
        NodeList children = container.getChildNodes();
        if (children.getLength() == 0) {
            throw new Exception("[Expression] container has no children!");
        }
        for (int i = 0; i < children.getLength() && ((child = children.item(i)).getNodeType() != 1 || (result = Expression.getExpression(tagName = ((Element)child).getTagName(), child, opType, fieldDefs, transDict)) == null); ++i) {
        }
        return result;
    }

    public static Expression getExpression(String name, Node expression, FieldMetaInfo.Optype opType, ArrayList<Attribute> fieldDefs, TransformationDictionary transDict) throws Exception {
        Expression result = null;
        if (name.equals("Constant")) {
            result = new Constant((Element)expression, opType, fieldDefs);
        } else if (name.equals("FieldRef")) {
            result = new FieldRef((Element)expression, opType, fieldDefs);
        } else if (name.equals("Apply")) {
            result = new Apply((Element)expression, opType, fieldDefs, transDict);
        } else if (name.equals("NormDiscrete")) {
            result = new NormDiscrete((Element)expression, opType, fieldDefs);
        } else if (name.equals("NormContinuous")) {
            result = new NormContinuous((Element)expression, opType, fieldDefs);
        } else if (name.equals("Discretize")) {
            result = new Discretize((Element)expression, opType, fieldDefs);
        } else if (name.equals("MapValues") || name.equals("Aggregate")) {
            throw new Exception("[Expression] Unhandled Expression type " + name);
        }
        return result;
    }

    public Attribute getFieldDef(String attName) {
        Attribute returnV = null;
        for (int i = 0; i < this.m_fieldDefs.size(); ++i) {
            if (!this.m_fieldDefs.get(i).name().equals(attName)) continue;
            returnV = this.m_fieldDefs.get(i);
            break;
        }
        return returnV;
    }

    public int getFieldDefIndex(String attName) {
        int returnV = -1;
        for (int i = 0; i < this.m_fieldDefs.size(); ++i) {
            if (!this.m_fieldDefs.get(i).name().equals(attName)) continue;
            returnV = i;
            break;
        }
        return returnV;
    }

    public FieldMetaInfo.Optype getOptype() {
        return this.m_opType;
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String pad) {
        return pad + this.getClass().getName();
    }
}

