/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.mi.supportVector;

import weka.classifiers.functions.supportVector.RBFKernel;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.MultiInstanceCapabilitiesHandler;
import weka.core.RevisionUtils;

public class MIRBFKernel
extends RBFKernel
implements MultiInstanceCapabilitiesHandler {
    private static final long serialVersionUID = -8711882393708956962L;
    protected double[][] m_kernelPrecalc;

    public MIRBFKernel() {
    }

    public MIRBFKernel(Instances instances, int n, double d) throws Exception {
        super(instances, n, d);
    }

    protected double evaluate(int n, int n2, Instance instance) throws Exception {
        double d = 0.0;
        Instances instances = n == -1 ? new Instances(instance.relationalValue(1)) : new Instances(this.m_data.instance(n).relationalValue(1));
        Instances instances2 = new Instances(this.m_data.instance(n2).relationalValue(1));
        double d2 = 0.0;
        for (int i = 0; i < instances.numInstances(); ++i) {
            for (int j = 0; j < instances2.numInstances(); ++j) {
                d2 = n == -1 ? this.dotProd(instances.instance(i), instances.instance(i)) : this.m_kernelPrecalc[n][i];
                double d3 = Math.exp(this.m_gamma * (2.0 * this.dotProd(instances.instance(i), instances2.instance(j)) - d2 - this.m_kernelPrecalc[n2][j]));
                d += d3;
            }
        }
        return d;
    }

    protected void initVars(Instances instances) {
        super.initVars(instances);
        this.m_kernelPrecalc = new double[instances.numInstances()][];
    }

    public Capabilities getCapabilities() {
        Capabilities capabilities = super.getCapabilities();
        capabilities.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.RELATIONAL_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.MISSING_VALUES);
        capabilities.enableAllClasses();
        capabilities.enable(Capabilities.Capability.ONLY_MULTIINSTANCE);
        return capabilities;
    }

    public Capabilities getMultiInstanceCapabilities() {
        Capabilities capabilities = super.getCapabilities();
        capabilities.disableAllClasses();
        capabilities.enable(Capabilities.Capability.NO_CLASS);
        return capabilities;
    }

    public void buildKernel(Instances instances) throws Exception {
        if (!this.getChecksTurnedOff()) {
            this.getCapabilities().testWithFail(instances);
        }
        this.initVars(instances);
        for (int i = 0; i < instances.numInstances(); ++i) {
            Instances instances2 = new Instances(instances.instance(i).relationalValue(1));
            this.m_kernelPrecalc[i] = new double[instances2.numInstances()];
            for (int j = 0; j < instances2.numInstances(); ++j) {
                this.m_kernelPrecalc[i][j] = this.dotProd(instances2.instance(j), instances2.instance(j));
            }
        }
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.4 $");
    }
}

