/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.beans;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import weka.core.Instances;
import weka.gui.beans.AbstractTrainAndTestSetProducer;
import weka.gui.beans.BeanCommon;
import weka.gui.beans.DataSetEvent;
import weka.gui.beans.DataSourceListener;
import weka.gui.beans.EventConstraints;
import weka.gui.beans.TestSetEvent;
import weka.gui.beans.TestSetListener;
import weka.gui.beans.TrainingSetEvent;
import weka.gui.beans.TrainingSetListener;
import weka.gui.beans.UserRequestAcceptor;

public class CrossValidationFoldMaker
extends AbstractTrainAndTestSetProducer
implements DataSourceListener,
TrainingSetListener,
TestSetListener,
UserRequestAcceptor,
EventConstraints,
Serializable {
    private static final long serialVersionUID = -6350179298851891512L;
    private int m_numFolds = 10;
    private int m_randomSeed = 1;
    private Thread m_foldThread = null;

    public CrossValidationFoldMaker() {
        this.m_visual.loadIcons("weka/gui/beans/icons/CrossValidationFoldMaker.gif", "weka/gui/beans/icons/CrossValidationFoldMaker_animated.gif");
        this.m_visual.setText("CrossValidationFoldMaker");
    }

    public void setCustomName(String string) {
        this.m_visual.setText(string);
    }

    public String getCustomName() {
        return this.m_visual.getText();
    }

    public String globalInfo() {
        return "Split an incoming data set into cross validation folds. Separate train and test sets are produced for each of the k folds.";
    }

    public void acceptTrainingSet(TrainingSetEvent trainingSetEvent) {
        Instances instances = trainingSetEvent.getTrainingSet();
        DataSetEvent dataSetEvent = new DataSetEvent(this, instances);
        this.acceptDataSet(dataSetEvent);
    }

    public void acceptTestSet(TestSetEvent testSetEvent) {
        Instances instances = testSetEvent.getTestSet();
        DataSetEvent dataSetEvent = new DataSetEvent(this, instances);
        this.acceptDataSet(dataSetEvent);
    }

    public void acceptDataSet(DataSetEvent dataSetEvent) {
        if (dataSetEvent.isStructureOnly()) {
            TrainingSetEvent trainingSetEvent = new TrainingSetEvent(this, dataSetEvent.getDataSet());
            TestSetEvent testSetEvent = new TestSetEvent(this, dataSetEvent.getDataSet());
            this.notifyTrainingSetProduced(trainingSetEvent);
            this.notifyTestSetProduced(testSetEvent);
            return;
        }
        if (this.m_foldThread == null) {
            final Instances instances = new Instances(dataSetEvent.getDataSet());
            this.m_foldThread = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public void run() {
                    try {
                        try {
                            Random random = new Random(CrossValidationFoldMaker.this.getSeed());
                            instances.randomize(random);
                            if (instances.classIndex() >= 0 && instances.attribute(instances.classIndex()).isNominal()) {
                                instances.stratify(CrossValidationFoldMaker.this.getFolds());
                                if (CrossValidationFoldMaker.this.m_logger != null) {
                                    CrossValidationFoldMaker.this.m_logger.logMessage("[" + CrossValidationFoldMaker.this.getCustomName() + "] " + "stratifying data");
                                }
                            }
                            for (int i = 0; i < CrossValidationFoldMaker.this.getFolds(); ++i) {
                                if (CrossValidationFoldMaker.this.m_foldThread == null) {
                                    if (CrossValidationFoldMaker.this.m_logger == null) break;
                                    CrossValidationFoldMaker.this.m_logger.logMessage("[" + CrossValidationFoldMaker.this.getCustomName() + "] Cross validation has been canceled!");
                                    break;
                                }
                                Instances instances3 = instances.trainCV(CrossValidationFoldMaker.this.getFolds(), i, random);
                                Instances instances2 = instances.testCV(CrossValidationFoldMaker.this.getFolds(), i);
                                TrainingSetEvent trainingSetEvent = new TrainingSetEvent(this, instances3);
                                trainingSetEvent.m_setNumber = i + 1;
                                trainingSetEvent.m_maxSetNumber = CrossValidationFoldMaker.this.getFolds();
                                String string = CrossValidationFoldMaker.this.getCustomName() + "$" + CrossValidationFoldMaker.this.hashCode() + "|";
                                if (CrossValidationFoldMaker.this.m_logger != null) {
                                    CrossValidationFoldMaker.this.m_logger.statusMessage(string + "seed: " + CrossValidationFoldMaker.this.getSeed() + " folds: " + CrossValidationFoldMaker.this.getFolds() + "|Training fold " + (i + 1));
                                }
                                if (CrossValidationFoldMaker.this.m_foldThread != null) {
                                    CrossValidationFoldMaker.this.notifyTrainingSetProduced(trainingSetEvent);
                                }
                                TestSetEvent testSetEvent = new TestSetEvent(this, instances2);
                                testSetEvent.m_setNumber = i + 1;
                                testSetEvent.m_maxSetNumber = CrossValidationFoldMaker.this.getFolds();
                                if (CrossValidationFoldMaker.this.m_logger != null) {
                                    CrossValidationFoldMaker.this.m_logger.statusMessage(string + "seed: " + CrossValidationFoldMaker.this.getSeed() + " folds: " + CrossValidationFoldMaker.this.getFolds() + "|Test fold " + (i + 1));
                                }
                                if (CrossValidationFoldMaker.this.m_foldThread == null) continue;
                                CrossValidationFoldMaker.this.notifyTestSetProduced(testSetEvent);
                            }
                            Object var9_9 = null;
                        }
                        catch (Exception exception) {
                            CrossValidationFoldMaker.this.stop();
                            if (CrossValidationFoldMaker.this.m_logger != null) {
                                CrossValidationFoldMaker.this.m_logger.logMessage("[" + CrossValidationFoldMaker.this.getCustomName() + "] problem during fold creation. " + exception.getMessage());
                                CrossValidationFoldMaker.this.m_logger.statusMessage(CrossValidationFoldMaker.this.getCustomName() + "$" + CrossValidationFoldMaker.this.hashCode() + "|" + "ERROR (See log for details).");
                            }
                            exception.printStackTrace();
                            Object var9_10 = null;
                            if (this.isInterrupted()) {
                                String string = "[" + CrossValidationFoldMaker.this.getCustomName() + "] Cross validation interrupted";
                                if (CrossValidationFoldMaker.this.m_logger != null) {
                                    CrossValidationFoldMaker.this.m_logger.logMessage("[" + CrossValidationFoldMaker.this.getCustomName() + "] Cross validation interrupted");
                                    CrossValidationFoldMaker.this.m_logger.statusMessage(CrossValidationFoldMaker.this.getCustomName() + "$" + CrossValidationFoldMaker.this.hashCode() + "|" + "INTERRUPTED");
                                } else {
                                    System.err.println(string);
                                }
                            } else {
                                String string = CrossValidationFoldMaker.this.getCustomName() + "$" + CrossValidationFoldMaker.this.hashCode() + "|";
                                if (CrossValidationFoldMaker.this.m_logger != null) {
                                    CrossValidationFoldMaker.this.m_logger.statusMessage(string + "Finished.");
                                }
                            }
                            CrossValidationFoldMaker.this.block(false);
                            return;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var9_11 = null;
                        if (this.isInterrupted()) {
                            String string = "[" + CrossValidationFoldMaker.this.getCustomName() + "] Cross validation interrupted";
                            if (CrossValidationFoldMaker.this.m_logger != null) {
                                CrossValidationFoldMaker.this.m_logger.logMessage("[" + CrossValidationFoldMaker.this.getCustomName() + "] Cross validation interrupted");
                                CrossValidationFoldMaker.this.m_logger.statusMessage(CrossValidationFoldMaker.this.getCustomName() + "$" + CrossValidationFoldMaker.this.hashCode() + "|" + "INTERRUPTED");
                            } else {
                                System.err.println(string);
                            }
                        } else {
                            String string = CrossValidationFoldMaker.this.getCustomName() + "$" + CrossValidationFoldMaker.this.hashCode() + "|";
                            if (CrossValidationFoldMaker.this.m_logger != null) {
                                CrossValidationFoldMaker.this.m_logger.statusMessage(string + "Finished.");
                            }
                        }
                        CrossValidationFoldMaker.this.block(false);
                        throw throwable;
                    }
                    if (this.isInterrupted()) {
                        String string = "[" + CrossValidationFoldMaker.this.getCustomName() + "] Cross validation interrupted";
                        if (CrossValidationFoldMaker.this.m_logger != null) {
                            CrossValidationFoldMaker.this.m_logger.logMessage("[" + CrossValidationFoldMaker.this.getCustomName() + "] Cross validation interrupted");
                            CrossValidationFoldMaker.this.m_logger.statusMessage(CrossValidationFoldMaker.this.getCustomName() + "$" + CrossValidationFoldMaker.this.hashCode() + "|" + "INTERRUPTED");
                        } else {
                            System.err.println(string);
                        }
                    } else {
                        String string = CrossValidationFoldMaker.this.getCustomName() + "$" + CrossValidationFoldMaker.this.hashCode() + "|";
                        if (CrossValidationFoldMaker.this.m_logger != null) {
                            CrossValidationFoldMaker.this.m_logger.statusMessage(string + "Finished.");
                        }
                    }
                    CrossValidationFoldMaker.this.block(false);
                }
            };
            this.m_foldThread.setPriority(1);
            this.m_foldThread.start();
            this.block(true);
            this.m_foldThread = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyTestSetProduced(TestSetEvent testSetEvent) {
        Vector vector;
        CrossValidationFoldMaker crossValidationFoldMaker = this;
        synchronized (crossValidationFoldMaker) {
            vector = (Vector)this.m_testListeners.clone();
        }
        if (vector.size() > 0) {
            for (int i = 0; i < vector.size() && this.m_foldThread != null; ++i) {
                ((TestSetListener)vector.elementAt(i)).acceptTestSet(testSetEvent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyTrainingSetProduced(TrainingSetEvent trainingSetEvent) {
        Vector vector;
        CrossValidationFoldMaker crossValidationFoldMaker = this;
        synchronized (crossValidationFoldMaker) {
            vector = (Vector)this.m_trainingListeners.clone();
        }
        if (vector.size() > 0) {
            for (int i = 0; i < vector.size() && this.m_foldThread != null; ++i) {
                ((TrainingSetListener)vector.elementAt(i)).acceptTrainingSet(trainingSetEvent);
            }
        }
    }

    public void setFolds(int n) {
        this.m_numFolds = n;
    }

    public int getFolds() {
        return this.m_numFolds;
    }

    public String foldsTipText() {
        return "The number of train and test splits to produce";
    }

    public void setSeed(int n) {
        this.m_randomSeed = n;
    }

    public int getSeed() {
        return this.m_randomSeed;
    }

    public String seedTipText() {
        return "The randomization seed";
    }

    public boolean isBusy() {
        return this.m_foldThread != null;
    }

    public void stop() {
        if (this.m_listenee instanceof BeanCommon) {
            ((BeanCommon)this.m_listenee).stop();
        }
        if (this.m_foldThread != null) {
            Thread thread = this.m_foldThread;
            this.m_foldThread = null;
            thread.interrupt();
            thread.stop();
        }
    }

    private synchronized void block(boolean bl) {
        if (bl) {
            try {
                if (this.m_foldThread.isAlive()) {
                    this.wait();
                }
            }
            catch (InterruptedException interruptedException) {}
        } else {
            this.notifyAll();
        }
    }

    public Enumeration enumerateRequests() {
        Vector<String> vector = new Vector<String>(0);
        if (this.m_foldThread != null) {
            vector.addElement("Stop");
        }
        return vector.elements();
    }

    public void performRequest(String string) {
        if (string.compareTo("Stop") != 0) {
            throw new IllegalArgumentException(string + " not supported (CrossValidation)");
        }
        this.stop();
    }

    public boolean eventGeneratable(String string) {
        if (this.m_listenee == null) {
            return false;
        }
        if (this.m_listenee instanceof EventConstraints) {
            return ((EventConstraints)this.m_listenee).eventGeneratable("dataSet") || ((EventConstraints)this.m_listenee).eventGeneratable("trainingSet") || ((EventConstraints)this.m_listenee).eventGeneratable("testSet");
        }
        return true;
    }
}

