/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.beans;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.Customizer;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import weka.core.Instances;
import weka.gui.beans.ClassValuePicker;
import weka.gui.beans.CustomizerClosingListener;
import weka.gui.beans.DataFormatListener;
import weka.gui.beans.DataSetEvent;

public class ClassValuePickerCustomizer
extends JPanel
implements Customizer,
CustomizerClosingListener,
DataFormatListener {
    private static final long serialVersionUID = 8213423053861600469L;
    private boolean m_displayValNames = false;
    private ClassValuePicker m_classValuePicker;
    private PropertyChangeSupport m_pcSupport = new PropertyChangeSupport(this);
    private JComboBox m_ClassValueCombo = new JComboBox();
    private JPanel m_holderP = new JPanel();
    private JLabel m_messageLabel = new JLabel("No customization possible at present.");

    public ClassValuePickerCustomizer() {
        this.setBorder(BorderFactory.createEmptyBorder(0, 5, 5, 5));
        this.setLayout(new BorderLayout());
        this.add((Component)new JLabel("ClassValuePickerCustomizer"), "North");
        this.m_holderP.setLayout(new BorderLayout());
        this.m_holderP.setBorder(BorderFactory.createTitledBorder("Choose class value"));
        this.m_holderP.add((Component)this.m_ClassValueCombo, "Center");
        this.m_ClassValueCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (ClassValuePickerCustomizer.this.m_classValuePicker != null) {
                    ClassValuePickerCustomizer.this.m_classValuePicker.setClassValueIndex(ClassValuePickerCustomizer.this.m_ClassValueCombo.getSelectedIndex());
                }
            }
        });
        this.add((Component)this.m_messageLabel, "Center");
    }

    private void setUpNoCustPossible() {
        if (this.m_displayValNames) {
            this.remove(this.m_holderP);
            this.add((Component)this.m_messageLabel, "Center");
            this.m_displayValNames = false;
        }
        this.validate();
        this.repaint();
    }

    private void setUpValueSelection(Instances instances) {
        if (instances.classIndex() < 0 || instances.classAttribute().isNumeric()) {
            return;
        }
        if (!this.m_displayValNames) {
            this.remove(this.m_messageLabel);
        }
        int n = this.m_classValuePicker.getClassValueIndex();
        String[] stringArray = new String[instances.classAttribute().numValues()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = instances.classAttribute().value(i);
        }
        this.m_ClassValueCombo.setModel(new DefaultComboBoxModel<String>(stringArray));
        if (stringArray.length > 0 && n < stringArray.length) {
            this.m_ClassValueCombo.setSelectedIndex(n);
        }
        if (!this.m_displayValNames) {
            this.add((Component)this.m_holderP, "Center");
            this.m_displayValNames = true;
        }
        this.validate();
        this.repaint();
    }

    public void setObject(Object object) {
        if (this.m_classValuePicker != (ClassValuePicker)object) {
            if (this.m_classValuePicker != null) {
                this.m_classValuePicker.removeDataFormatListener(this);
            }
            this.m_classValuePicker = (ClassValuePicker)object;
            this.m_classValuePicker.addDataFormatListener(this);
            if (this.m_classValuePicker.getConnectedFormat() != null) {
                this.setUpValueSelection(this.m_classValuePicker.getConnectedFormat());
            }
        }
    }

    public void customizerClosing() {
        if (this.m_classValuePicker != null) {
            System.err.println("Customizer deregistering with class value picker");
            this.m_classValuePicker.removeDataFormatListener(this);
        }
    }

    public void newDataFormat(DataSetEvent dataSetEvent) {
        if (dataSetEvent.getDataSet() != null) {
            this.setUpValueSelection(this.m_classValuePicker.getConnectedFormat());
        } else {
            this.setUpNoCustPossible();
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.m_pcSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.m_pcSupport.removePropertyChangeListener(propertyChangeListener);
    }
}

