/*
 * Decompiled with CFR 0.152.
 */
package weka.experiment;

import java.io.ObjectStreamClass;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import weka.clusterers.AbstractClusterer;
import weka.clusterers.ClusterEvaluation;
import weka.clusterers.DensityBasedClusterer;
import weka.clusterers.EM;
import weka.core.AdditionalMeasureProducer;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.experiment.SplitEvaluator;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.Remove;

public class DensityBasedClustererSplitEvaluator
implements SplitEvaluator,
OptionHandler,
AdditionalMeasureProducer,
RevisionHandler {
    protected boolean m_removeClassColumn = true;
    protected DensityBasedClusterer m_clusterer = new EM();
    protected String[] m_additionalMeasures = null;
    protected boolean[] m_doesProduce = null;
    protected int m_numberAdditionalMeasures = 0;
    protected String m_result = null;
    protected String m_clustererOptions = "";
    protected String m_clustererVersion = "";
    private static final int KEY_SIZE = 3;
    private static final int RESULT_SIZE = 6;

    public DensityBasedClustererSplitEvaluator() {
        this.updateOptions();
    }

    public String globalInfo() {
        return " A SplitEvaluator that produces results for a density based clusterer. ";
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>(1);
        vector.addElement(new Option("\tThe full class name of the density based clusterer.\n\teg: weka.clusterers.EM", "W", 1, "-W <class name>"));
        if (this.m_clusterer != null && this.m_clusterer instanceof OptionHandler) {
            vector.addElement(new Option("", "", 0, "\nOptions specific to clusterer " + this.m_clusterer.getClass().getName() + ":"));
            Enumeration enumeration = ((OptionHandler)((Object)this.m_clusterer)).listOptions();
            while (enumeration.hasMoreElements()) {
                vector.addElement((Option)enumeration.nextElement());
            }
        }
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        String string = Utils.getOption('W', stringArray);
        if (string.length() == 0) {
            throw new Exception("A clusterer must be specified with the -W option.");
        }
        this.setClusterer((DensityBasedClusterer)AbstractClusterer.forName(string, null));
        if (this.getClusterer() instanceof OptionHandler) {
            ((OptionHandler)((Object)this.getClusterer())).setOptions(Utils.partitionOptions(stringArray));
            this.updateOptions();
        }
    }

    public String[] getOptions() {
        String[] stringArray = new String[]{};
        if (this.m_clusterer != null && this.m_clusterer instanceof OptionHandler) {
            stringArray = ((OptionHandler)((Object)this.m_clusterer)).getOptions();
        }
        String[] stringArray2 = new String[stringArray.length + 3];
        int n = 0;
        if (this.getClusterer() != null) {
            stringArray2[n++] = "-W";
            stringArray2[n++] = this.getClusterer().getClass().getName();
        }
        stringArray2[n++] = "--";
        System.arraycopy(stringArray, 0, stringArray2, n, stringArray.length);
        n += stringArray.length;
        while (n < stringArray2.length) {
            stringArray2[n++] = "";
        }
        return stringArray2;
    }

    public void setAdditionalMeasures(String[] stringArray) {
        this.m_additionalMeasures = stringArray;
        if (this.m_additionalMeasures != null && this.m_additionalMeasures.length > 0) {
            this.m_doesProduce = new boolean[this.m_additionalMeasures.length];
            if (this.m_clusterer instanceof AdditionalMeasureProducer) {
                Enumeration enumeration = ((AdditionalMeasureProducer)((Object)this.m_clusterer)).enumerateMeasures();
                while (enumeration.hasMoreElements()) {
                    String string = (String)enumeration.nextElement();
                    for (int i = 0; i < this.m_additionalMeasures.length; ++i) {
                        if (string.compareToIgnoreCase(this.m_additionalMeasures[i]) != 0) continue;
                        this.m_doesProduce[i] = true;
                    }
                }
            }
        } else {
            this.m_doesProduce = null;
        }
    }

    public Enumeration enumerateMeasures() {
        Vector<String> vector = new Vector<String>();
        if (this.m_clusterer instanceof AdditionalMeasureProducer) {
            Enumeration enumeration = ((AdditionalMeasureProducer)((Object)this.m_clusterer)).enumerateMeasures();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                vector.addElement(string);
            }
        }
        return vector.elements();
    }

    public double getMeasure(String string) {
        if (this.m_clusterer instanceof AdditionalMeasureProducer) {
            return ((AdditionalMeasureProducer)((Object)this.m_clusterer)).getMeasure(string);
        }
        throw new IllegalArgumentException("DensityBasedClustererSplitEvaluator: Can't return value for : " + string + ". " + this.m_clusterer.getClass().getName() + " " + "is not an AdditionalMeasureProducer");
    }

    public Object[] getKeyTypes() {
        Object[] objectArray = new Object[]{"", "", ""};
        return objectArray;
    }

    public String[] getKeyNames() {
        String[] stringArray = new String[]{"Scheme", "Scheme_options", "Scheme_version_ID"};
        return stringArray;
    }

    public Object[] getKey() {
        Object[] objectArray = new Object[]{this.m_clusterer.getClass().getName(), this.m_clustererOptions, this.m_clustererVersion};
        return objectArray;
    }

    public Object[] getResultTypes() {
        int n = this.m_additionalMeasures != null ? this.m_additionalMeasures.length : 0;
        int n2 = 6 + n;
        Object[] objectArray = new Object[n2];
        Double d = new Double(0.0);
        int n3 = 0;
        objectArray[n3++] = d;
        objectArray[n3++] = d;
        objectArray[n3++] = d;
        objectArray[n3++] = d;
        objectArray[n3++] = d;
        objectArray[n3++] = d;
        for (int i = 0; i < n; ++i) {
            objectArray[n3++] = d;
        }
        if (n3 != n2) {
            throw new Error("ResultTypes didn't fit RESULT_SIZE");
        }
        return objectArray;
    }

    public String[] getResultNames() {
        int n = this.m_additionalMeasures != null ? this.m_additionalMeasures.length : 0;
        int n2 = 6 + n;
        String[] stringArray = new String[n2];
        int n3 = 0;
        stringArray[n3++] = "Number_of_training_instances";
        stringArray[n3++] = "Number_of_testing_instances";
        stringArray[n3++] = "Log_likelihood";
        stringArray[n3++] = "Number_of_clusters";
        stringArray[n3++] = "Time_training";
        stringArray[n3++] = "Time_testing";
        for (int i = 0; i < n; ++i) {
            stringArray[n3++] = this.m_additionalMeasures[i];
        }
        if (n3 != n2) {
            throw new Error("ResultNames didn't fit RESULT_SIZE");
        }
        return stringArray;
    }

    public Object[] getResult(Instances instances, Instances instances2) throws Exception {
        RevisionHandler revisionHandler;
        if (this.m_clusterer == null) {
            throw new Exception("No clusterer has been specified");
        }
        int n = this.m_additionalMeasures != null ? this.m_additionalMeasures.length : 0;
        int n2 = 6 + n;
        if (this.m_removeClassColumn && instances.classIndex() != -1) {
            revisionHandler = new Remove();
            ((Remove)revisionHandler).setAttributeIndicesArray(new int[]{instances.classIndex()});
            ((Remove)revisionHandler).setInvertSelection(false);
            ((Remove)revisionHandler).setInputFormat(instances);
            instances = Filter.useFilter(instances, (Filter)revisionHandler);
            instances2 = Filter.useFilter(instances2, (Filter)revisionHandler);
        }
        instances.setClassIndex(-1);
        instances2.setClassIndex(-1);
        revisionHandler = new ClusterEvaluation();
        Object[] objectArray = new Object[n2];
        long l = System.currentTimeMillis();
        this.m_clusterer.buildClusterer(instances);
        double d = this.m_clusterer.numberOfClusters();
        ((ClusterEvaluation)revisionHandler).setClusterer(this.m_clusterer);
        long l2 = System.currentTimeMillis() - l;
        long l3 = System.currentTimeMillis();
        ((ClusterEvaluation)revisionHandler).evaluateClusterer(instances2);
        long l4 = System.currentTimeMillis() - l3;
        int n3 = 0;
        objectArray[n3++] = new Double(instances.numInstances());
        objectArray[n3++] = new Double(instances2.numInstances());
        objectArray[n3++] = new Double(((ClusterEvaluation)revisionHandler).getLogLikelihood());
        objectArray[n3++] = new Double(d);
        objectArray[n3++] = new Double((double)l2 / 1000.0);
        objectArray[n3++] = new Double((double)l4 / 1000.0);
        for (int i = 0; i < n; ++i) {
            if (this.m_doesProduce[i]) {
                try {
                    double d2 = ((AdditionalMeasureProducer)((Object)this.m_clusterer)).getMeasure(this.m_additionalMeasures[i]);
                    Double d3 = new Double(d2);
                    objectArray[n3++] = d3;
                }
                catch (Exception exception) {
                    System.err.println(exception);
                }
                continue;
            }
            objectArray[n3++] = null;
        }
        if (n3 != n2) {
            throw new Error("Results didn't fit RESULT_SIZE");
        }
        return objectArray;
    }

    public String removeClassColumnTipText() {
        return "Remove the class column (if set) from the data.";
    }

    public void setRemoveClassColumn(boolean bl) {
        this.m_removeClassColumn = bl;
    }

    public boolean getRemoveClassColumn() {
        return this.m_removeClassColumn;
    }

    public String clustererTipText() {
        return "The density based clusterer to use.";
    }

    public DensityBasedClusterer getClusterer() {
        return this.m_clusterer;
    }

    public void setClusterer(DensityBasedClusterer densityBasedClusterer) {
        this.m_clusterer = densityBasedClusterer;
        this.updateOptions();
    }

    protected void updateOptions() {
        this.m_clustererOptions = this.m_clusterer instanceof OptionHandler ? Utils.joinOptions(((OptionHandler)((Object)this.m_clusterer)).getOptions()) : "";
        if (this.m_clusterer instanceof Serializable) {
            ObjectStreamClass objectStreamClass = ObjectStreamClass.lookup(this.m_clusterer.getClass());
            this.m_clustererVersion = "" + objectStreamClass.getSerialVersionUID();
        } else {
            this.m_clustererVersion = "";
        }
    }

    public void setClustererName(String string) throws Exception {
        try {
            this.setClusterer((DensityBasedClusterer)Class.forName(string).newInstance());
        }
        catch (Exception exception) {
            throw new Exception("Can't find Clusterer with class name: " + string);
        }
    }

    public String getRawResultOutput() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.m_clusterer == null) {
            return "<null> clusterer";
        }
        stringBuffer.append(this.toString());
        stringBuffer.append("Clustering model: \n" + this.m_clusterer.toString() + '\n');
        if (this.m_result != null && this.m_doesProduce != null) {
            for (int i = 0; i < this.m_doesProduce.length; ++i) {
                if (!this.m_doesProduce[i]) continue;
                try {
                    double d = ((AdditionalMeasureProducer)((Object)this.m_clusterer)).getMeasure(this.m_additionalMeasures[i]);
                    Double d2 = new Double(d);
                    stringBuffer.append(this.m_additionalMeasures[i] + " : " + d2 + '\n');
                    continue;
                }
                catch (Exception exception) {
                    System.err.println(exception);
                }
            }
        }
        return stringBuffer.toString();
    }

    public String toString() {
        String string = "DensityBasedClustererSplitEvaluator: ";
        if (this.m_clusterer == null) {
            return string + "<null> clusterer";
        }
        return string + this.m_clusterer.getClass().getName() + " " + this.m_clustererOptions + "(version " + this.m_clustererVersion + ")";
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.3 $");
    }
}

