/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.lazy;

import java.util.Enumeration;
import java.util.Vector;
import weka.classifiers.Classifier;
import weka.classifiers.SingleClassifierEnhancer;
import weka.classifiers.UpdateableClassifier;
import weka.classifiers.rules.ZeroR;
import weka.classifiers.trees.DecisionStump;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.RevisionUtils;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;
import weka.core.WeightedInstancesHandler;
import weka.core.neighboursearch.LinearNNSearch;
import weka.core.neighboursearch.NearestNeighbourSearch;

public class LWL
extends SingleClassifierEnhancer
implements UpdateableClassifier,
WeightedInstancesHandler,
TechnicalInformationHandler {
    static final long serialVersionUID = 1979797405383665815L;
    protected Instances m_Train;
    protected int m_kNN = -1;
    protected int m_WeightKernel = 0;
    protected boolean m_UseAllK = true;
    protected NearestNeighbourSearch m_NNSearch = new LinearNNSearch();
    protected static final int LINEAR = 0;
    protected static final int EPANECHNIKOV = 1;
    protected static final int TRICUBE = 2;
    protected static final int INVERSE = 3;
    protected static final int GAUSS = 4;
    protected static final int CONSTANT = 5;
    protected Classifier m_ZeroR;

    public String globalInfo() {
        return "Locally weighted learning. Uses an instance-based algorithm to assign instance weights which are then used by a specified WeightedInstancesHandler.\nCan do classification (e.g. using naive Bayes) or regression (e.g. using linear regression).\n\nFor more info, see\n\n" + this.getTechnicalInformation().toString();
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation technicalInformation = new TechnicalInformation(TechnicalInformation.Type.INPROCEEDINGS);
        technicalInformation.setValue(TechnicalInformation.Field.AUTHOR, "Eibe Frank and Mark Hall and Bernhard Pfahringer");
        technicalInformation.setValue(TechnicalInformation.Field.YEAR, "2003");
        technicalInformation.setValue(TechnicalInformation.Field.TITLE, "Locally Weighted Naive Bayes");
        technicalInformation.setValue(TechnicalInformation.Field.BOOKTITLE, "19th Conference in Uncertainty in Artificial Intelligence");
        technicalInformation.setValue(TechnicalInformation.Field.PAGES, "249-256");
        technicalInformation.setValue(TechnicalInformation.Field.PUBLISHER, "Morgan Kaufmann");
        TechnicalInformation technicalInformation2 = technicalInformation.add(TechnicalInformation.Type.ARTICLE);
        technicalInformation2.setValue(TechnicalInformation.Field.AUTHOR, "C. Atkeson and A. Moore and S. Schaal");
        technicalInformation2.setValue(TechnicalInformation.Field.YEAR, "1996");
        technicalInformation2.setValue(TechnicalInformation.Field.TITLE, "Locally weighted learning");
        technicalInformation2.setValue(TechnicalInformation.Field.JOURNAL, "AI Review");
        return technicalInformation;
    }

    public LWL() {
        this.m_Classifier = new DecisionStump();
    }

    protected String defaultClassifierString() {
        return "weka.classifiers.trees.DecisionStump";
    }

    public Enumeration enumerateMeasures() {
        return this.m_NNSearch.enumerateMeasures();
    }

    public double getMeasure(String string) {
        return this.m_NNSearch.getMeasure(string);
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>(3);
        vector.addElement(new Option("\tThe nearest neighbour search algorithm to use (default: weka.core.neighboursearch.LinearNNSearch).\n", "A", 0, "-A"));
        vector.addElement(new Option("\tSet the number of neighbours used to set the kernel bandwidth.\n\t(default all)", "K", 1, "-K <number of neighbours>"));
        vector.addElement(new Option("\tSet the weighting kernel shape to use. 0=Linear, 1=Epanechnikov,\n\t2=Tricube, 3=Inverse, 4=Gaussian.\n\t(default 0 = Linear)", "U", 1, "-U <number of weighting method>"));
        Enumeration enumeration = super.listOptions();
        while (enumeration.hasMoreElements()) {
            vector.addElement((Option)enumeration.nextElement());
        }
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        String string = Utils.getOption('K', stringArray);
        if (string.length() != 0) {
            this.setKNN(Integer.parseInt(string));
        } else {
            this.setKNN(-1);
        }
        String string2 = Utils.getOption('U', stringArray);
        if (string2.length() != 0) {
            this.setWeightingKernel(Integer.parseInt(string2));
        } else {
            this.setWeightingKernel(0);
        }
        String string3 = Utils.getOption('A', stringArray);
        if (string3.length() != 0) {
            String[] stringArray2 = Utils.splitOptions(string3);
            if (stringArray2.length == 0) {
                throw new Exception("Invalid NearestNeighbourSearch algorithm specification string.");
            }
            String string4 = stringArray2[0];
            stringArray2[0] = "";
            this.setNearestNeighbourSearchAlgorithm((NearestNeighbourSearch)Utils.forName(NearestNeighbourSearch.class, string4, stringArray2));
        } else {
            this.setNearestNeighbourSearchAlgorithm(new LinearNNSearch());
        }
        super.setOptions(stringArray);
    }

    public String[] getOptions() {
        String[] stringArray = super.getOptions();
        String[] stringArray2 = new String[stringArray.length + 6];
        int n = 0;
        stringArray2[n++] = "-U";
        stringArray2[n++] = "" + this.getWeightingKernel();
        if (this.getKNN() == 0 && this.m_UseAllK) {
            stringArray2[n++] = "-K";
            stringArray2[n++] = "-1";
        } else {
            stringArray2[n++] = "-K";
            stringArray2[n++] = "" + this.getKNN();
        }
        stringArray2[n++] = "-A";
        stringArray2[n++] = this.m_NNSearch.getClass().getName() + " " + Utils.joinOptions(this.m_NNSearch.getOptions());
        System.arraycopy(stringArray, 0, stringArray2, n, stringArray.length);
        return stringArray2;
    }

    public String KNNTipText() {
        return "How many neighbours are used to determine the width of the weighting function (<= 0 means all neighbours).";
    }

    public void setKNN(int n) {
        this.m_kNN = n;
        if (n <= 0) {
            this.m_kNN = 0;
            this.m_UseAllK = true;
        } else {
            this.m_UseAllK = false;
        }
    }

    public int getKNN() {
        return this.m_kNN;
    }

    public String weightingKernelTipText() {
        return "Determines weighting function. [0 = Linear, 1 = Epnechnikov,2 = Tricube, 3 = Inverse, 4 = Gaussian and 5 = Constant. (default 0 = Linear)].";
    }

    public void setWeightingKernel(int n) {
        if (n != 0 && n != 1 && n != 2 && n != 3 && n != 4 && n != 5) {
            return;
        }
        this.m_WeightKernel = n;
    }

    public int getWeightingKernel() {
        return this.m_WeightKernel;
    }

    public String nearestNeighbourSearchAlgorithmTipText() {
        return "The nearest neighbour search algorithm to use (Default: LinearNN).";
    }

    public NearestNeighbourSearch getNearestNeighbourSearchAlgorithm() {
        return this.m_NNSearch;
    }

    public void setNearestNeighbourSearchAlgorithm(NearestNeighbourSearch nearestNeighbourSearch) {
        this.m_NNSearch = nearestNeighbourSearch;
    }

    public Capabilities getCapabilities() {
        Capabilities capabilities = this.m_Classifier != null ? this.m_Classifier.getCapabilities() : super.getCapabilities();
        capabilities.setMinimumNumberInstances(0);
        for (Capabilities.Capability capability : Capabilities.Capability.values()) {
            capabilities.enableDependency(capability);
        }
        return capabilities;
    }

    public void buildClassifier(Instances instances) throws Exception {
        if (!(this.m_Classifier instanceof WeightedInstancesHandler)) {
            throw new IllegalArgumentException("Classifier must be a WeightedInstancesHandler!");
        }
        this.getCapabilities().testWithFail(instances);
        instances = new Instances(instances);
        instances.deleteWithMissingClass();
        if (instances.numAttributes() == 1) {
            System.err.println("Cannot build model (only class attribute present in data!), using ZeroR model instead!");
            this.m_ZeroR = new ZeroR();
            this.m_ZeroR.buildClassifier(instances);
            return;
        }
        this.m_ZeroR = null;
        this.m_Train = new Instances(instances, 0, instances.numInstances());
        this.m_NNSearch.setInstances(this.m_Train);
    }

    public void updateClassifier(Instance instance) throws Exception {
        if (this.m_Train.numInstances() == 0) {
            throw new Exception("No training instances!");
        }
        if (!this.m_Train.equalHeaders(instance.dataset())) {
            throw new Exception("Incompatible instance types");
        }
        if (!instance.classIsMissing()) {
            this.m_NNSearch.update(instance);
            this.m_Train.add(instance);
        }
    }

    public double[] distributionForInstance(Instance instance) throws Exception {
        int n;
        int n2;
        double d;
        if (this.m_ZeroR != null) {
            return this.m_ZeroR.distributionForInstance(instance);
        }
        if (this.m_Train.numInstances() == 0) {
            throw new Exception("No training instances!");
        }
        this.m_NNSearch.addInstanceInfo(instance);
        int n3 = this.m_Train.numInstances();
        if (!this.m_UseAllK && this.m_kNN < n3 && this.m_WeightKernel != 3 && this.m_WeightKernel != 4) {
            n3 = this.m_kNN;
        }
        Instances instances = this.m_NNSearch.kNearestNeighbours(instance, n3);
        double[] dArray = this.m_NNSearch.getDistances();
        if (this.m_Debug) {
            System.out.println("Test Instance: " + instance);
            System.out.println("For " + n3 + " kept " + instances.numInstances() + " out of " + this.m_Train.numInstances() + " instances.");
        }
        if (n3 > dArray.length) {
            n3 = dArray.length;
        }
        if (this.m_Debug) {
            System.out.println("Instance Distances");
            for (int i = 0; i < dArray.length; ++i) {
                System.out.println("" + dArray[i]);
            }
        }
        if ((d = dArray[n3 - 1]) <= 0.0) {
            for (n2 = 0; n2 < dArray.length; ++n2) {
                dArray[n2] = 1.0;
            }
        } else {
            for (n2 = 0; n2 < dArray.length; ++n2) {
                dArray[n2] = dArray[n2] / d;
            }
        }
        block11: for (n2 = 0; n2 < dArray.length; ++n2) {
            switch (this.m_WeightKernel) {
                case 0: {
                    dArray[n2] = 1.0001 - dArray[n2];
                    continue block11;
                }
                case 1: {
                    dArray[n2] = 0.75 * (1.0001 - dArray[n2] * dArray[n2]);
                    continue block11;
                }
                case 2: {
                    dArray[n2] = Math.pow(1.0001 - Math.pow(dArray[n2], 3.0), 3.0);
                    continue block11;
                }
                case 5: {
                    dArray[n2] = 1.0;
                    continue block11;
                }
                case 3: {
                    dArray[n2] = 1.0 / (1.0 + dArray[n2]);
                    continue block11;
                }
                case 4: {
                    dArray[n2] = Math.exp(-dArray[n2] * dArray[n2]);
                }
            }
        }
        if (this.m_Debug) {
            System.out.println("Instance Weights");
            for (n2 = 0; n2 < dArray.length; ++n2) {
                System.out.println("" + dArray[n2]);
            }
        }
        double d2 = 0.0;
        double d3 = 0.0;
        for (n = 0; n < dArray.length; ++n) {
            double d4 = dArray[n];
            Instance instance2 = instances.instance(n);
            d2 += instance2.weight();
            d3 += instance2.weight() * d4;
            instance2.setWeight(instance2.weight() * d4);
        }
        for (n = 0; n < instances.numInstances(); ++n) {
            Instance instance3 = instances.instance(n);
            instance3.setWeight(instance3.weight() * d2 / d3);
        }
        this.m_Classifier.buildClassifier(instances);
        if (this.m_Debug) {
            System.out.println("Classifying test instance: " + instance);
            System.out.println("Built base classifier:\n" + this.m_Classifier.toString());
        }
        return this.m_Classifier.distributionForInstance(instance);
    }

    public String toString() {
        if (this.m_ZeroR != null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.getClass().getName().replaceAll(".*\\.", "") + "\n");
            stringBuffer.append(this.getClass().getName().replaceAll(".*\\.", "").replaceAll(".", "=") + "\n\n");
            stringBuffer.append("Warning: No model could be built, hence ZeroR model is used:\n\n");
            stringBuffer.append(this.m_ZeroR.toString());
            return stringBuffer.toString();
        }
        if (this.m_Train == null) {
            return "Locally weighted learning: No model built yet.";
        }
        String string = "Locally weighted learning\n===========================\n";
        string = string + "Using classifier: " + this.m_Classifier.getClass().getName() + "\n";
        switch (this.m_WeightKernel) {
            case 0: {
                string = string + "Using linear weighting kernels\n";
                break;
            }
            case 1: {
                string = string + "Using epanechnikov weighting kernels\n";
                break;
            }
            case 2: {
                string = string + "Using tricube weighting kernels\n";
                break;
            }
            case 3: {
                string = string + "Using inverse-distance weighting kernels\n";
                break;
            }
            case 4: {
                string = string + "Using gaussian weighting kernels\n";
                break;
            }
            case 5: {
                string = string + "Using constant weighting kernels\n";
            }
        }
        string = string + "Using " + (this.m_UseAllK ? "all" : "" + this.m_kNN) + " neighbours";
        return string;
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.22 $");
    }

    public static void main(String[] stringArray) {
        LWL.runClassifier(new LWL(), stringArray);
    }
}

