/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.bayes.net.estimate;

import java.util.Enumeration;
import weka.classifiers.bayes.BayesNet;
import weka.classifiers.bayes.net.estimate.BayesNetEstimator;
import weka.classifiers.bayes.net.estimate.DiscreteEstimatorBayes;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.estimators.Estimator;

public class SimpleEstimator
extends BayesNetEstimator {
    static final long serialVersionUID = 5874941612331806172L;

    public String globalInfo() {
        return "SimpleEstimator is used for estimating the conditional probability tables of a Bayes network once the structure has been learned. Estimates probabilities directly from data.";
    }

    public void estimateCPTs(BayesNet bayesNet) throws Exception {
        this.initCPTs(bayesNet);
        Enumeration enumeration = bayesNet.m_Instances.enumerateInstances();
        while (enumeration.hasMoreElements()) {
            Instance instance = (Instance)enumeration.nextElement();
            this.updateClassifier(bayesNet, instance);
        }
    }

    public void updateClassifier(BayesNet bayesNet, Instance instance) throws Exception {
        for (int i = 0; i < bayesNet.m_Instances.numAttributes(); ++i) {
            double d = 0.0;
            for (int j = 0; j < bayesNet.getParentSet(i).getNrOfParents(); ++j) {
                int n = bayesNet.getParentSet(i).getParent(j);
                d = d * (double)bayesNet.m_Instances.attribute(n).numValues() + instance.value(n);
            }
            bayesNet.m_Distributions[i][(int)d].addValue(instance.value(i), instance.weight());
        }
    }

    public void initCPTs(BayesNet bayesNet) throws Exception {
        int n;
        Instances instances = bayesNet.m_Instances;
        int n2 = 1;
        for (n = 0; n < instances.numAttributes(); ++n) {
            if (bayesNet.getParentSet(n).getCardinalityOfParents() <= n2) continue;
            n2 = bayesNet.getParentSet(n).getCardinalityOfParents();
        }
        bayesNet.m_Distributions = new Estimator[instances.numAttributes()][n2];
        for (n = 0; n < instances.numAttributes(); ++n) {
            for (int i = 0; i < bayesNet.getParentSet(n).getCardinalityOfParents(); ++i) {
                bayesNet.m_Distributions[n][i] = new DiscreteEstimatorBayes(instances.attribute(n).numValues(), this.m_fAlpha);
            }
        }
    }

    public double[] distributionForInstance(BayesNet bayesNet, Instance instance) throws Exception {
        int n;
        int n2;
        Instances instances = bayesNet.m_Instances;
        int n3 = instances.numClasses();
        double[] dArray = new double[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            dArray[n2] = 1.0;
        }
        n2 = 0;
        while (n2 < n3) {
            double d = 0.0;
            for (int i = 0; i < instances.numAttributes(); ++i) {
                double d2 = 0.0;
                for (int j = 0; j < bayesNet.getParentSet(i).getNrOfParents(); ++j) {
                    int n4 = bayesNet.getParentSet(i).getParent(j);
                    d2 = n4 == instances.classIndex() ? d2 * (double)n3 + (double)n2 : d2 * (double)instances.attribute(n4).numValues() + instance.value(n4);
                }
                if (i == instances.classIndex()) {
                    d += Math.log(bayesNet.m_Distributions[i][(int)d2].getProbability(n2));
                    continue;
                }
                d += Math.log(bayesNet.m_Distributions[i][(int)d2].getProbability(instance.value(i)));
            }
            int n5 = n2++;
            dArray[n5] = dArray[n5] + d;
        }
        double d = dArray[0];
        for (n = 0; n < n3; ++n) {
            if (!(dArray[n] > d)) continue;
            d = dArray[n];
        }
        for (n = 0; n < n3; ++n) {
            dArray[n] = Math.exp(dArray[n] - d);
        }
        Utils.normalize(dArray);
        return dArray;
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.6 $");
    }
}

