/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers;

import java.io.File;
import java.util.Enumeration;
import java.util.Vector;
import weka.classifiers.Classifier;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.core.converters.ConverterUtils;

public class CheckSource
implements OptionHandler,
RevisionHandler {
    protected Classifier m_Classifier = null;
    protected Classifier m_SourceCode = null;
    protected File m_Dataset = null;
    protected int m_ClassIndex = -1;

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>();
        vector.addElement(new Option("\tThe classifier (incl. options) that was used to generate\n\tthe source code.", "W", 1, "-W <classname and options>"));
        vector.addElement(new Option("\tThe classname of the generated source code.", "S", 1, "-S <classname>"));
        vector.addElement(new Option("\tThe training set with which the source code was generated.", "t", 1, "-t <file>"));
        vector.addElement(new Option("\tThe class index of the training set. 'first' and 'last' are\n\tvalid indices.\n\t(default: last)", "c", 1, "-c <index>"));
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        String[] stringArray2;
        String string = Utils.getOption('W', stringArray);
        if (string.length() > 0) {
            stringArray2 = Utils.splitOptions(string);
            if (stringArray2.length == 0) {
                throw new IllegalArgumentException("Invalid classifier specification string");
            }
        } else {
            throw new Exception("No classifier (classname + options) provided!");
        }
        String string2 = stringArray2[0];
        stringArray2[0] = "";
        this.setClassifier((Classifier)Utils.forName(Classifier.class, string2, stringArray2));
        string = Utils.getOption('S', stringArray);
        if (string.length() > 0) {
            stringArray2 = Utils.splitOptions(string);
            if (stringArray2.length != 1) {
                throw new IllegalArgumentException("Invalid source code specification string");
            }
        } else {
            throw new Exception("No source code (classname) provided!");
        }
        string2 = stringArray2[0];
        stringArray2[0] = "";
        this.setSourceCode((Classifier)Utils.forName(Classifier.class, string2, stringArray2));
        string = Utils.getOption('t', stringArray);
        if (string.length() == 0) {
            throw new Exception("No dataset provided!");
        }
        this.setDataset(new File(string));
        string = Utils.getOption('c', stringArray);
        if (string.length() != 0) {
            if (string.equals("first")) {
                this.setClassIndex(0);
            } else if (string.equals("last")) {
                this.setClassIndex(-1);
            } else {
                this.setClassIndex(Integer.parseInt(string) - 1);
            }
        } else {
            this.setClassIndex(-1);
        }
    }

    public String[] getOptions() {
        Vector<String> vector = new Vector<String>();
        if (this.getClassifier() != null) {
            vector.add("-W");
            vector.add(this.getClassifier().getClass().getName() + " " + Utils.joinOptions(this.getClassifier().getOptions()));
        }
        if (this.getSourceCode() != null) {
            vector.add("-S");
            vector.add(this.getSourceCode().getClass().getName());
        }
        if (this.getDataset() != null) {
            vector.add("-t");
            vector.add(this.m_Dataset.getAbsolutePath());
        }
        vector.add("-c");
        if (this.getClassIndex() == -1) {
            vector.add("last");
        } else if (this.getClassIndex() == 0) {
            vector.add("first");
        } else {
            vector.add("" + (this.getClassIndex() + 1));
        }
        return vector.toArray(new String[vector.size()]);
    }

    public void setClassifier(Classifier classifier) {
        this.m_Classifier = classifier;
    }

    public Classifier getClassifier() {
        return this.m_Classifier;
    }

    public void setSourceCode(Classifier classifier) {
        this.m_SourceCode = classifier;
    }

    public Classifier getSourceCode() {
        return this.m_SourceCode;
    }

    public void setDataset(File file) {
        if (!file.exists()) {
            throw new IllegalArgumentException("Dataset '" + file.getAbsolutePath() + "' does not exist!");
        }
        this.m_Dataset = file;
    }

    public File getDataset() {
        return this.m_Dataset;
    }

    public void setClassIndex(int n) {
        this.m_ClassIndex = n;
    }

    public int getClassIndex() {
        return this.m_ClassIndex;
    }

    public boolean execute() throws Exception {
        boolean bl = true;
        if (this.getClassifier() == null) {
            throw new Exception("No classifier set!");
        }
        if (this.getSourceCode() == null) {
            throw new Exception("No source code set!");
        }
        if (this.getDataset() == null) {
            throw new Exception("No dataset set!");
        }
        if (!this.getDataset().exists()) {
            throw new Exception("Dataset '" + this.getDataset().getAbsolutePath() + "' does not exist!");
        }
        ConverterUtils.DataSource dataSource = new ConverterUtils.DataSource(this.getDataset().getAbsolutePath());
        Instances instances = dataSource.getDataSet();
        if (this.getClassIndex() == -1) {
            instances.setClassIndex(instances.numAttributes() - 1);
        } else {
            instances.setClassIndex(this.getClassIndex());
        }
        boolean bl2 = instances.classAttribute().isNumeric();
        Classifier classifier = Classifier.makeCopy(this.getClassifier());
        classifier.buildClassifier(instances);
        Classifier classifier2 = this.getSourceCode();
        for (int i = 0; i < instances.numInstances(); ++i) {
            boolean bl3;
            double d = classifier.classifyInstance(instances.instance(i));
            double d2 = classifier2.classifyInstance(instances.instance(i));
            if (Double.isNaN(d) && Double.isNaN(d2)) {
                bl3 = false;
            } else if (bl2) {
                bl3 = !Utils.eq(d, d2);
            } else {
                boolean bl4 = bl3 = (int)d != (int)d2;
            }
            if (!bl3) continue;
            bl = false;
            if (bl2) {
                System.out.println(i + 1 + ". instance (Classifier/Source code): " + d + " != " + d2);
                continue;
            }
            System.out.println(i + 1 + ". instance (Classifier/Source code): " + instances.classAttribute().value((int)d) + " != " + instances.classAttribute().value((int)d2));
        }
        return bl;
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.4 $");
    }

    public static void main(String[] stringArray) throws Exception {
        CheckSource checkSource = new CheckSource();
        if (Utils.getFlag('h', stringArray)) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("\nHelp requested:\n\n");
            Enumeration enumeration = checkSource.listOptions();
            while (enumeration.hasMoreElements()) {
                Option option = (Option)enumeration.nextElement();
                stringBuffer.append(option.synopsis() + "\n");
                stringBuffer.append(option.description() + "\n");
            }
            System.out.println("\n" + stringBuffer + "\n");
        } else {
            checkSource.setOptions(stringArray);
            if (checkSource.execute()) {
                System.out.println("Tests OK!");
            } else {
                System.out.println("Tests failed!");
            }
        }
    }
}

