/*
 * Decompiled with CFR 0.152.
 */
package weka.attributeSelection;

import java.util.BitSet;
import java.util.Enumeration;
import java.util.Vector;
import weka.attributeSelection.ASEvaluation;
import weka.attributeSelection.ASSearch;
import weka.attributeSelection.LFSMethods;
import weka.attributeSelection.StartSetHandler;
import weka.attributeSelection.SubsetEvaluator;
import weka.attributeSelection.UnsupervisedSubsetEvaluator;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.Range;
import weka.core.RevisionUtils;
import weka.core.SelectedTag;
import weka.core.Tag;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;

public class LinearForwardSelection
extends ASSearch
implements OptionHandler,
StartSetHandler,
TechnicalInformationHandler {
    protected static final int SEARCH_METHOD_FORWARD = 0;
    protected static final int SEARCH_METHOD_FLOATING = 1;
    public static final Tag[] TAGS_SEARCH_METHOD = new Tag[]{new Tag(0, "Forward selection"), new Tag(1, "Floating forward selection")};
    protected static final int TYPE_FIXED_SET = 0;
    protected static final int TYPE_FIXED_WIDTH = 1;
    public static final Tag[] TAGS_TYPE = new Tag[]{new Tag(0, "Fixed-set"), new Tag(1, "Fixed-width")};
    protected int m_maxStale;
    protected int m_forwardSearchMethod;
    protected boolean m_performRanking;
    protected int m_numUsedAttributes;
    protected int m_linearSelectionType;
    protected int[] m_starting;
    protected Range m_startRange;
    protected boolean m_hasClass;
    protected int m_classIndex;
    protected int m_numAttribs;
    protected int m_totalEvals;
    protected boolean m_verbose;
    protected double m_bestMerit;
    protected int m_cacheSize;

    public LinearForwardSelection() {
        this.resetOptions();
    }

    public String globalInfo() {
        return "LinearForwardSelection:\n\nExtension of BestFirst. Takes a restricted number of k attributes into account. Fixed-set selects a fixed number k of attributes, whereas k is increased in each step when fixed-width is selected. The search uses either the initial ordering to select the top k attributes, or performs a ranking (with the same evalutator the search uses later on). The search direction can be forward, or floating forward selection (with opitional backward search steps).\n\nFor more information see:\n\n" + this.getTechnicalInformation().toString();
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation technicalInformation = new TechnicalInformation(TechnicalInformation.Type.MASTERSTHESIS);
        technicalInformation.setValue(TechnicalInformation.Field.AUTHOR, "Martin Guetlein");
        technicalInformation.setValue(TechnicalInformation.Field.YEAR, "2006");
        technicalInformation.setValue(TechnicalInformation.Field.TITLE, "Large Scale Attribute Selection Using Wrappers");
        technicalInformation.setValue(TechnicalInformation.Field.SCHOOL, "Albert-Ludwigs-Universitaet");
        technicalInformation.setValue(TechnicalInformation.Field.ADDRESS, "Freiburg, Germany");
        return technicalInformation;
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>(8);
        vector.addElement(new Option("\tSpecify a starting set of attributes.\n\tEg. 1,3,5-7.", "P", 1, "-P <start set>"));
        vector.addElement(new Option("\tForward selection method. (default = 0).", "D", 1, "-D <0 = forward selection | 1 = floating forward selection>"));
        vector.addElement(new Option("\tNumber of non-improving nodes to\n\tconsider before terminating search.", "N", 1, "-N <num>"));
        vector.addElement(new Option("\tPerform initial ranking to select the\n\ttop-ranked attributes.", "I", 0, "-I"));
        vector.addElement(new Option("\tNumber of top-ranked attributes that are \n\ttaken into account by the search.", "K", 1, "-K <num>"));
        vector.addElement(new Option("\tType of Linear Forward Selection (default = 0).", "T", 1, "-T <0 = fixed-set | 1 = fixed-width>"));
        vector.addElement(new Option("\tSize of lookup cache for evaluated subsets.\n\tExpressed as a multiple of the number of\n\tattributes in the data set. (default = 1)", "S", 1, "-S <num>"));
        vector.addElement(new Option("\tverbose on/off", "Z", 0, "-Z"));
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        this.resetOptions();
        String string = Utils.getOption('P', stringArray);
        if (string.length() != 0) {
            this.setStartSet(string);
        }
        if ((string = Utils.getOption('D', stringArray)).length() != 0) {
            this.setForwardSelectionMethod(new SelectedTag(Integer.parseInt(string), TAGS_SEARCH_METHOD));
        } else {
            this.setForwardSelectionMethod(new SelectedTag(0, TAGS_SEARCH_METHOD));
        }
        string = Utils.getOption('N', stringArray);
        if (string.length() != 0) {
            this.setSearchTermination(Integer.parseInt(string));
        }
        this.setPerformRanking(Utils.getFlag('I', stringArray));
        string = Utils.getOption('K', stringArray);
        if (string.length() != 0) {
            this.setNumUsedAttributes(Integer.parseInt(string));
        }
        if ((string = Utils.getOption('T', stringArray)).length() != 0) {
            this.setType(new SelectedTag(Integer.parseInt(string), TAGS_TYPE));
        } else {
            this.setType(new SelectedTag(0, TAGS_TYPE));
        }
        string = Utils.getOption('S', stringArray);
        if (string.length() != 0) {
            this.setLookupCacheSize(Integer.parseInt(string));
        }
        this.m_verbose = Utils.getFlag('Z', stringArray);
    }

    public void setLookupCacheSize(int n) {
        if (n >= 0) {
            this.m_cacheSize = n;
        }
    }

    public int getLookupCacheSize() {
        return this.m_cacheSize;
    }

    public String lookupCacheSizeTipText() {
        return "Set the maximum size of the lookup cache of evaluated subsets. This is expressed as a multiplier of the number of attributes in the data set. (default = 1).";
    }

    public String startSetTipText() {
        return "Set the start point for the search. This is specified as a comma seperated list off attribute indexes starting at 1. It can include ranges. Eg. 1,2,5-9,17.";
    }

    public void setStartSet(String string) throws Exception {
        this.m_startRange.setRanges(string);
    }

    public String getStartSet() {
        return this.m_startRange.getRanges();
    }

    public String searchTerminationTipText() {
        return "Set the amount of backtracking. Specify the number of ";
    }

    public void setSearchTermination(int n) throws Exception {
        if (n < 1) {
            throw new Exception("Value of -N must be > 0.");
        }
        this.m_maxStale = n;
    }

    public int getSearchTermination() {
        return this.m_maxStale;
    }

    public String performRankingTipText() {
        return "Perform initial ranking to select top-ranked attributes.";
    }

    public void setPerformRanking(boolean bl) {
        this.m_performRanking = bl;
    }

    public boolean getPerformRanking() {
        return this.m_performRanking;
    }

    public String numUsedAttributesTipText() {
        return "Set the amount of top-ranked attributes that are taken into account by the search process.";
    }

    public void setNumUsedAttributes(int n) throws Exception {
        if (n < 2) {
            throw new Exception("Value of -K must be >= 2.");
        }
        this.m_numUsedAttributes = n;
    }

    public int getNumUsedAttributes() {
        return this.m_numUsedAttributes;
    }

    public String forwardSelectionMethodTipText() {
        return "Set the direction of the search.";
    }

    public void setForwardSelectionMethod(SelectedTag selectedTag) {
        if (selectedTag.getTags() == TAGS_SEARCH_METHOD) {
            this.m_forwardSearchMethod = selectedTag.getSelectedTag().getID();
        }
    }

    public SelectedTag getForwardSelectionMethod() {
        return new SelectedTag(this.m_forwardSearchMethod, TAGS_SEARCH_METHOD);
    }

    public String typeTipText() {
        return "Set the type of the search.";
    }

    public void setType(SelectedTag selectedTag) {
        if (selectedTag.getTags() == TAGS_TYPE) {
            this.m_linearSelectionType = selectedTag.getSelectedTag().getID();
        }
    }

    public SelectedTag getType() {
        return new SelectedTag(this.m_linearSelectionType, TAGS_TYPE);
    }

    public String verboseTipText() {
        return "Turn on verbose output for monitoring the search's progress.";
    }

    public void setVerbose(boolean bl) {
        this.m_verbose = bl;
    }

    public boolean getVerbose() {
        return this.m_verbose;
    }

    public String[] getOptions() {
        String[] stringArray = new String[13];
        int n = 0;
        if (!this.getStartSet().equals("")) {
            stringArray[n++] = "-P";
            stringArray[n++] = "" + this.startSetToString();
        }
        stringArray[n++] = "-D";
        stringArray[n++] = "" + this.m_forwardSearchMethod;
        stringArray[n++] = "-N";
        stringArray[n++] = "" + this.m_maxStale;
        if (this.m_performRanking) {
            stringArray[n++] = "-I";
        }
        stringArray[n++] = "-K";
        stringArray[n++] = "" + this.m_numUsedAttributes;
        stringArray[n++] = "-T";
        stringArray[n++] = "" + this.m_linearSelectionType;
        stringArray[n++] = "-Z";
        stringArray[n++] = "" + this.m_verbose;
        while (n < stringArray.length) {
            stringArray[n++] = "";
        }
        return stringArray;
    }

    private String startSetToString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.m_starting == null) {
            return this.getStartSet();
        }
        for (int i = 0; i < this.m_starting.length; ++i) {
            boolean bl = false;
            if (!this.m_hasClass || this.m_hasClass && i != this.m_classIndex) {
                stringBuffer.append(this.m_starting[i] + 1);
                bl = true;
            }
            if (i == this.m_starting.length - 1) {
                stringBuffer.append("");
                continue;
            }
            if (!bl) continue;
            stringBuffer.append(",");
        }
        return stringBuffer.toString();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\tLinear Forward Selection.\n\tStart set: ");
        if (this.m_starting == null) {
            stringBuffer.append("no attributes\n");
        } else {
            stringBuffer.append(this.startSetToString() + "\n");
        }
        stringBuffer.append("\tForward selection method: ");
        if (this.m_forwardSearchMethod == 0) {
            stringBuffer.append("forward selection\n");
        } else {
            stringBuffer.append("floating forward selection\n");
        }
        stringBuffer.append("\tStale search after " + this.m_maxStale + " node expansions\n");
        stringBuffer.append("\tLinear Forward Selection Type: ");
        if (this.m_linearSelectionType == 0) {
            stringBuffer.append("fixed-set\n");
        } else {
            stringBuffer.append("fixed-width\n");
        }
        stringBuffer.append("\tNumber of top-ranked attributes that are used: " + this.m_numUsedAttributes + "\n");
        stringBuffer.append("\tTotal number of subsets evaluated: " + this.m_totalEvals + "\n");
        stringBuffer.append("\tMerit of best subset found: " + Utils.doubleToString(Math.abs(this.m_bestMerit), 8, 3) + "\n");
        return stringBuffer.toString();
    }

    public int[] search(ASEvaluation aSEvaluation, Instances instances) throws Exception {
        int[] nArray;
        this.m_totalEvals = 0;
        if (!(aSEvaluation instanceof SubsetEvaluator)) {
            throw new Exception(aSEvaluation.getClass().getName() + " is not a " + "Subset evaluator!");
        }
        if (aSEvaluation instanceof UnsupervisedSubsetEvaluator) {
            this.m_hasClass = false;
        } else {
            this.m_hasClass = true;
            this.m_classIndex = instances.classIndex();
        }
        aSEvaluation.buildEvaluator(instances);
        this.m_numAttribs = instances.numAttributes();
        if (this.m_numUsedAttributes > this.m_numAttribs) {
            System.out.println("Decreasing number of top-ranked attributes to total number of attributes: " + instances.numAttributes());
            this.m_numUsedAttributes = this.m_numAttribs;
        }
        BitSet bitSet = new BitSet(this.m_numAttribs);
        this.m_startRange.setUpper(this.m_numAttribs - 1);
        if (!this.getStartSet().equals("")) {
            this.m_starting = this.m_startRange.getSelection();
        }
        if (this.m_starting != null) {
            for (int i = 0; i < this.m_starting.length; ++i) {
                if (this.m_starting[i] == this.m_classIndex) continue;
                bitSet.set(this.m_starting[i]);
            }
        }
        LFSMethods lFSMethods = new LFSMethods();
        if (this.m_performRanking) {
            nArray = lFSMethods.rankAttributes(instances, (SubsetEvaluator)((Object)aSEvaluation), this.m_verbose);
        } else {
            nArray = new int[this.m_numAttribs];
            for (int i = 0; i < nArray.length; ++i) {
                nArray[i] = i;
            }
        }
        if (this.m_forwardSearchMethod == 0) {
            lFSMethods.forwardSearch(this.m_cacheSize, bitSet, nArray, this.m_numUsedAttributes, this.m_linearSelectionType == 1, this.m_maxStale, -1, instances, (SubsetEvaluator)((Object)aSEvaluation), this.m_verbose);
        } else if (this.m_forwardSearchMethod == 1) {
            lFSMethods.floatingForwardSearch(this.m_cacheSize, bitSet, nArray, this.m_numUsedAttributes, this.m_linearSelectionType == 1, this.m_maxStale, instances, (SubsetEvaluator)((Object)aSEvaluation), this.m_verbose);
        }
        this.m_totalEvals = lFSMethods.getNumEvalsTotal();
        this.m_bestMerit = lFSMethods.getBestMerit();
        return this.attributeList(lFSMethods.getBestGroup());
    }

    protected void resetOptions() {
        this.m_maxStale = 5;
        this.m_forwardSearchMethod = 0;
        this.m_performRanking = true;
        this.m_numUsedAttributes = 50;
        this.m_linearSelectionType = 0;
        this.m_starting = null;
        this.m_startRange = new Range();
        this.m_classIndex = -1;
        this.m_totalEvals = 0;
        this.m_cacheSize = 1;
        this.m_verbose = false;
    }

    protected int[] attributeList(BitSet bitSet) {
        int n = 0;
        for (int i = 0; i < this.m_numAttribs; ++i) {
            if (!bitSet.get(i)) continue;
            ++n;
        }
        int[] nArray = new int[n];
        n = 0;
        for (int i = 0; i < this.m_numAttribs; ++i) {
            if (!bitSet.get(i)) continue;
            nArray[n++] = i;
        }
        return nArray;
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.4 $");
    }
}

