/*
 * Decompiled with CFR 0.152.
 */
package weka.associations;

import java.util.Enumeration;
import java.util.Hashtable;
import weka.associations.AbstractAssociator;
import weka.associations.AprioriItemSet;
import weka.associations.CARuleMiner;
import weka.associations.ItemSet;
import weka.associations.LabeledItemSet;
import weka.core.Capabilities;
import weka.core.FastVector;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.SelectedTag;
import weka.core.Tag;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.Remove;

public class Apriori
extends AbstractAssociator
implements OptionHandler,
CARuleMiner,
TechnicalInformationHandler {
    static final long serialVersionUID = 3277498842319212687L;
    protected double m_minSupport;
    protected double m_upperBoundMinSupport;
    protected double m_lowerBoundMinSupport;
    protected static final int CONFIDENCE = 0;
    protected static final int LIFT = 1;
    protected static final int LEVERAGE = 2;
    protected static final int CONVICTION = 3;
    public static final Tag[] TAGS_SELECTION = new Tag[]{new Tag(0, "Confidence"), new Tag(1, "Lift"), new Tag(2, "Leverage"), new Tag(3, "Conviction")};
    protected int m_metricType = 0;
    protected double m_minMetric;
    protected int m_numRules;
    protected double m_delta;
    protected double m_significanceLevel;
    protected int m_cycles;
    protected FastVector m_Ls;
    protected FastVector m_hashtables;
    protected FastVector[] m_allTheRules;
    protected Instances m_instances;
    protected boolean m_outputItemSets;
    protected boolean m_removeMissingCols;
    protected boolean m_verbose;
    protected Instances m_onlyClass;
    protected int m_classIndex;
    protected boolean m_car;

    public String globalInfo() {
        return "Class implementing an Apriori-type algorithm. Iteratively reduces the minimum support until it finds the required number of rules with the given minimum confidence.\nThe algorithm has an option to mine class association rules. It is adapted as explained in the second reference.\n\nFor more information see:\n\n" + this.getTechnicalInformation().toString();
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation technicalInformation = new TechnicalInformation(TechnicalInformation.Type.INPROCEEDINGS);
        technicalInformation.setValue(TechnicalInformation.Field.AUTHOR, "R. Agrawal and R. Srikant");
        technicalInformation.setValue(TechnicalInformation.Field.TITLE, "Fast Algorithms for Mining Association Rules in Large Databases");
        technicalInformation.setValue(TechnicalInformation.Field.BOOKTITLE, "20th International Conference on Very Large Data Bases");
        technicalInformation.setValue(TechnicalInformation.Field.YEAR, "1994");
        technicalInformation.setValue(TechnicalInformation.Field.PAGES, "478-499");
        technicalInformation.setValue(TechnicalInformation.Field.PUBLISHER, "Morgan Kaufmann, Los Altos, CA");
        TechnicalInformation technicalInformation2 = technicalInformation.add(TechnicalInformation.Type.INPROCEEDINGS);
        technicalInformation2.setValue(TechnicalInformation.Field.AUTHOR, "Bing Liu and Wynne Hsu and Yiming Ma");
        technicalInformation2.setValue(TechnicalInformation.Field.TITLE, "Integrating Classification and Association Rule Mining");
        technicalInformation2.setValue(TechnicalInformation.Field.BOOKTITLE, "Fourth International Conference on Knowledge Discovery and Data Mining");
        technicalInformation2.setValue(TechnicalInformation.Field.YEAR, "1998");
        technicalInformation2.setValue(TechnicalInformation.Field.PAGES, "80-86");
        technicalInformation2.setValue(TechnicalInformation.Field.PUBLISHER, "AAAI Press");
        return technicalInformation;
    }

    public Apriori() {
        this.resetOptions();
    }

    public void resetOptions() {
        this.m_removeMissingCols = false;
        this.m_verbose = false;
        this.m_delta = 0.05;
        this.m_minMetric = 0.9;
        this.m_numRules = 10;
        this.m_lowerBoundMinSupport = 0.1;
        this.m_upperBoundMinSupport = 1.0;
        this.m_significanceLevel = -1.0;
        this.m_outputItemSets = false;
        this.m_car = false;
        this.m_classIndex = -1;
    }

    protected Instances removeMissingColumns(Instances instances) throws Exception {
        RevisionHandler revisionHandler;
        int n = instances.numInstances();
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        boolean bl = true;
        int n3 = 0;
        for (int i = 0; i < instances.numAttributes(); ++i) {
            int[] nArray;
            revisionHandler = instances.attributeStats(i);
            if (this.m_upperBoundMinSupport == 1.0 && n3 != n && (nArray = revisionHandler.nominalCounts)[Utils.maxIndex(nArray)] > n3) {
                n3 = nArray[Utils.maxIndex(nArray)];
            }
            if (revisionHandler.missingCount != n) continue;
            if (bl) {
                stringBuffer.append(i + 1);
                bl = false;
            } else {
                stringBuffer.append("," + (i + 1));
            }
            ++n2;
        }
        if (this.m_verbose) {
            System.err.println("Removed : " + n2 + " columns with all missing " + "values.");
        }
        if (this.m_upperBoundMinSupport == 1.0 && n3 != n) {
            this.m_upperBoundMinSupport = (double)n3 / (double)n;
            if (this.m_verbose) {
                System.err.println("Setting upper bound min support to : " + this.m_upperBoundMinSupport);
            }
        }
        if (stringBuffer.toString().length() > 0) {
            Remove remove = new Remove();
            remove.setAttributeIndices(stringBuffer.toString());
            remove.setInvertSelection(false);
            remove.setInputFormat(instances);
            revisionHandler = Filter.useFilter(instances, remove);
            return revisionHandler;
        }
        return instances;
    }

    public Capabilities getCapabilities() {
        Capabilities capabilities = super.getCapabilities();
        capabilities.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.MISSING_VALUES);
        capabilities.enable(Capabilities.Capability.NO_CLASS);
        capabilities.enable(Capabilities.Capability.NOMINAL_CLASS);
        capabilities.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        return capabilities;
    }

    public void buildAssociations(Instances instances) throws Exception {
        int n = 0;
        instances = new Instances(instances);
        if (this.m_removeMissingCols) {
            instances = this.removeMissingColumns(instances);
        }
        if (this.m_car && this.m_metricType != 0) {
            throw new Exception("For CAR-Mining metric type has to be confidence!");
        }
        if (this.m_car) {
            if (this.m_classIndex == -1) {
                instances.setClassIndex(instances.numAttributes() - 1);
            } else if (this.m_classIndex <= instances.numAttributes() && this.m_classIndex > 0) {
                instances.setClassIndex(this.m_classIndex - 1);
            } else {
                throw new Exception("Invalid class index.");
            }
        }
        this.getCapabilities().testWithFail(instances);
        this.m_cycles = 0;
        if (this.m_car) {
            this.m_instances = LabeledItemSet.divide(instances, false);
            this.m_onlyClass = LabeledItemSet.divide(instances, true);
        } else {
            this.m_instances = instances;
        }
        if (this.m_car && this.m_numRules == Integer.MAX_VALUE) {
            this.m_minSupport = this.m_lowerBoundMinSupport;
        } else {
            this.m_minSupport = this.m_upperBoundMinSupport - this.m_delta;
            this.m_minSupport = this.m_minSupport < this.m_lowerBoundMinSupport ? this.m_lowerBoundMinSupport : this.m_minSupport;
        }
        do {
            int n2;
            int n3;
            this.m_Ls = new FastVector();
            this.m_hashtables = new FastVector();
            this.m_allTheRules = new FastVector[6];
            this.m_allTheRules[0] = new FastVector();
            this.m_allTheRules[1] = new FastVector();
            this.m_allTheRules[2] = new FastVector();
            if (this.m_metricType != 0 || this.m_significanceLevel != -1.0) {
                this.m_allTheRules[3] = new FastVector();
                this.m_allTheRules[4] = new FastVector();
                this.m_allTheRules[5] = new FastVector();
            }
            FastVector[] fastVectorArray = new FastVector[6];
            fastVectorArray[0] = new FastVector();
            fastVectorArray[1] = new FastVector();
            fastVectorArray[2] = new FastVector();
            if (this.m_metricType != 0 || this.m_significanceLevel != -1.0) {
                fastVectorArray[3] = new FastVector();
                fastVectorArray[4] = new FastVector();
                fastVectorArray[5] = new FastVector();
            }
            if (!this.m_car) {
                this.findLargeItemSets();
                if (this.m_significanceLevel != -1.0 || this.m_metricType != 0) {
                    this.findRulesBruteForce();
                } else {
                    this.findRulesQuickly();
                }
            } else {
                this.findLargeCarItemSets();
                this.findCarRulesQuickly();
            }
            int n4 = this.m_allTheRules[2].size() - 1;
            double[] dArray = new double[this.m_allTheRules[2].size()];
            for (n3 = 0; n3 < n4 + 1; ++n3) {
                dArray[n4 - n3] = (double)((ItemSet)this.m_allTheRules[1].elementAt(n4 - n3)).support() * -1.0;
            }
            int[] nArray = Utils.stableSort(dArray);
            for (n3 = 0; n3 < n4 + 1; ++n3) {
                fastVectorArray[0].addElement(this.m_allTheRules[0].elementAt(nArray[n4 - n3]));
                fastVectorArray[1].addElement(this.m_allTheRules[1].elementAt(nArray[n4 - n3]));
                fastVectorArray[2].addElement(this.m_allTheRules[2].elementAt(nArray[n4 - n3]));
                if (this.m_metricType == 0 && this.m_significanceLevel == -1.0) continue;
                fastVectorArray[3].addElement(this.m_allTheRules[3].elementAt(nArray[n4 - n3]));
                fastVectorArray[4].addElement(this.m_allTheRules[4].elementAt(nArray[n4 - n3]));
                fastVectorArray[5].addElement(this.m_allTheRules[5].elementAt(nArray[n4 - n3]));
            }
            this.m_allTheRules[0].removeAllElements();
            this.m_allTheRules[1].removeAllElements();
            this.m_allTheRules[2].removeAllElements();
            if (this.m_metricType != 0 || this.m_significanceLevel != -1.0) {
                this.m_allTheRules[3].removeAllElements();
                this.m_allTheRules[4].removeAllElements();
                this.m_allTheRules[5].removeAllElements();
            }
            double[] dArray2 = new double[fastVectorArray[2].size()];
            n3 = 2 + this.m_metricType;
            for (n2 = 0; n2 < fastVectorArray[2].size(); ++n2) {
                dArray2[n2] = (Double)fastVectorArray[n3].elementAt(n2);
            }
            nArray = Utils.stableSort(dArray2);
            for (n2 = fastVectorArray[0].size() - 1; n2 >= fastVectorArray[0].size() - this.m_numRules && n2 >= 0; --n2) {
                this.m_allTheRules[0].addElement(fastVectorArray[0].elementAt(nArray[n2]));
                this.m_allTheRules[1].addElement(fastVectorArray[1].elementAt(nArray[n2]));
                this.m_allTheRules[2].addElement(fastVectorArray[2].elementAt(nArray[n2]));
                if (this.m_metricType == 0 && this.m_significanceLevel == -1.0) continue;
                this.m_allTheRules[3].addElement(fastVectorArray[3].elementAt(nArray[n2]));
                this.m_allTheRules[4].addElement(fastVectorArray[4].elementAt(nArray[n2]));
                this.m_allTheRules[5].addElement(fastVectorArray[5].elementAt(nArray[n2]));
            }
            if (this.m_verbose && this.m_Ls.size() > 1) {
                System.out.println(this.toString());
            }
            this.m_minSupport = this.m_minSupport == this.m_lowerBoundMinSupport || this.m_minSupport - this.m_delta > this.m_lowerBoundMinSupport ? (this.m_minSupport -= this.m_delta) : this.m_lowerBoundMinSupport;
            n = Math.round((float)(this.m_minSupport * (double)this.m_instances.numInstances() + 0.5));
            ++this.m_cycles;
        } while (this.m_allTheRules[0].size() < this.m_numRules && Utils.grOrEq(this.m_minSupport, this.m_lowerBoundMinSupport) && n >= 1);
        this.m_minSupport += this.m_delta;
    }

    public FastVector[] mineCARs(Instances instances) throws Exception {
        this.m_car = true;
        this.buildAssociations(instances);
        return this.m_allTheRules;
    }

    public Instances getInstancesNoClass() {
        return this.m_instances;
    }

    public Instances getInstancesOnlyClass() {
        return this.m_onlyClass;
    }

    public Enumeration listOptions() {
        String string = "\tThe required number of rules. (default = " + this.m_numRules + ")";
        String string2 = "\tThe minimum confidence of a rule. (default = " + this.m_minMetric + ")";
        String string3 = "\tThe delta by which the minimum support is decreased in\n";
        String string4 = "\teach iteration. (default = " + this.m_delta + ")";
        String string5 = "\tThe lower bound for the minimum support. (default = " + this.m_lowerBoundMinSupport + ")";
        String string6 = "\tIf used, rules are tested for significance at\n";
        String string7 = "\tthe given level. Slower. (default = no significance testing)";
        String string8 = "\tIf set the itemsets found are also output. (default = no)";
        String string9 = "\tIf set class association rules are mined. (default = no)";
        String string10 = "\tThe class index. (default = last)";
        String string11 = "\tThe metric type by which to rank rules. (default = confidence)";
        FastVector fastVector = new FastVector(11);
        fastVector.addElement(new Option(string, "N", 1, "-N <required number of rules output>"));
        fastVector.addElement(new Option(string11, "T", 1, "-T <0=confidence | 1=lift | 2=leverage | 3=Conviction>"));
        fastVector.addElement(new Option(string2, "C", 1, "-C <minimum metric score of a rule>"));
        fastVector.addElement(new Option(string3 + string4, "D", 1, "-D <delta for minimum support>"));
        fastVector.addElement(new Option("\tUpper bound for minimum support. (default = 1.0)", "U", 1, "-U <upper bound for minimum support>"));
        fastVector.addElement(new Option(string5, "M", 1, "-M <lower bound for minimum support>"));
        fastVector.addElement(new Option(string6 + string7, "S", 1, "-S <significance level>"));
        fastVector.addElement(new Option(string8, "I", 0, "-I"));
        fastVector.addElement(new Option("\tRemove columns that contain all missing values (default = no)", "R", 0, "-R"));
        fastVector.addElement(new Option("\tReport progress iteratively. (default = no)", "V", 0, "-V"));
        fastVector.addElement(new Option(string9, "A", 0, "-A"));
        fastVector.addElement(new Option(string10, "c", 1, "-c <the class index>"));
        return fastVector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        this.resetOptions();
        String string = Utils.getOption('N', stringArray);
        String string2 = Utils.getOption('C', stringArray);
        String string3 = Utils.getOption('D', stringArray);
        String string4 = Utils.getOption('U', stringArray);
        String string5 = Utils.getOption('M', stringArray);
        String string6 = Utils.getOption('S', stringArray);
        String string7 = Utils.getOption('c', stringArray);
        String string8 = Utils.getOption('T', stringArray);
        if (string8.length() != 0) {
            this.setMetricType(new SelectedTag(Integer.parseInt(string8), TAGS_SELECTION));
        }
        if (string.length() != 0) {
            this.m_numRules = Integer.parseInt(string);
        }
        if (string7.length() != 0) {
            this.m_classIndex = string7.equalsIgnoreCase("last") ? -1 : (string7.equalsIgnoreCase("first") ? 0 : Integer.parseInt(string7));
        }
        if (string2.length() != 0) {
            this.m_minMetric = new Double(string2);
        }
        if (string3.length() != 0) {
            this.m_delta = new Double(string3);
        }
        if (string4.length() != 0) {
            this.setUpperBoundMinSupport(new Double(string4));
        }
        if (string5.length() != 0) {
            this.m_lowerBoundMinSupport = new Double(string5);
        }
        if (string6.length() != 0) {
            this.m_significanceLevel = new Double(string6);
        }
        this.m_outputItemSets = Utils.getFlag('I', stringArray);
        this.m_car = Utils.getFlag('A', stringArray);
        this.m_verbose = Utils.getFlag('V', stringArray);
        this.setRemoveAllMissingCols(Utils.getFlag('R', stringArray));
    }

    public String[] getOptions() {
        String[] stringArray = new String[20];
        int n = 0;
        if (this.m_outputItemSets) {
            stringArray[n++] = "-I";
        }
        if (this.getRemoveAllMissingCols()) {
            stringArray[n++] = "-R";
        }
        stringArray[n++] = "-N";
        stringArray[n++] = "" + this.m_numRules;
        stringArray[n++] = "-T";
        stringArray[n++] = "" + this.m_metricType;
        stringArray[n++] = "-C";
        stringArray[n++] = "" + this.m_minMetric;
        stringArray[n++] = "-D";
        stringArray[n++] = "" + this.m_delta;
        stringArray[n++] = "-U";
        stringArray[n++] = "" + this.m_upperBoundMinSupport;
        stringArray[n++] = "-M";
        stringArray[n++] = "" + this.m_lowerBoundMinSupport;
        stringArray[n++] = "-S";
        stringArray[n++] = "" + this.m_significanceLevel;
        if (this.m_car) {
            stringArray[n++] = "-A";
        }
        if (this.m_verbose) {
            stringArray[n++] = "-V";
        }
        stringArray[n++] = "-c";
        stringArray[n++] = "" + this.m_classIndex;
        while (n < stringArray.length) {
            stringArray[n++] = "";
        }
        return stringArray;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.m_Ls.size() <= 1) {
            return "\nNo large itemsets and rules found!\n";
        }
        stringBuffer.append("\nApriori\n=======\n\n");
        stringBuffer.append("Minimum support: " + Utils.doubleToString(this.m_minSupport, 2) + " (" + (int)(this.m_minSupport * (double)this.m_instances.numInstances() + 0.5) + " instances)" + '\n');
        stringBuffer.append("Minimum metric <");
        switch (this.m_metricType) {
            case 0: {
                stringBuffer.append("confidence>: ");
                break;
            }
            case 1: {
                stringBuffer.append("lift>: ");
                break;
            }
            case 2: {
                stringBuffer.append("leverage>: ");
                break;
            }
            case 3: {
                stringBuffer.append("conviction>: ");
            }
        }
        stringBuffer.append(Utils.doubleToString(this.m_minMetric, 2) + '\n');
        if (this.m_significanceLevel != -1.0) {
            stringBuffer.append("Significance level: " + Utils.doubleToString(this.m_significanceLevel, 2) + '\n');
        }
        stringBuffer.append("Number of cycles performed: " + this.m_cycles + '\n');
        stringBuffer.append("\nGenerated sets of large itemsets:\n");
        if (!this.m_car) {
            int n;
            for (n = 0; n < this.m_Ls.size(); ++n) {
                stringBuffer.append("\nSize of set of large itemsets L(" + (n + 1) + "): " + ((FastVector)this.m_Ls.elementAt(n)).size() + '\n');
                if (!this.m_outputItemSets) continue;
                stringBuffer.append("\nLarge Itemsets L(" + (n + 1) + "):\n");
                for (int i = 0; i < ((FastVector)this.m_Ls.elementAt(n)).size(); ++i) {
                    stringBuffer.append(((AprioriItemSet)((FastVector)this.m_Ls.elementAt(n)).elementAt(i)).toString(this.m_instances) + "\n");
                }
            }
            stringBuffer.append("\nBest rules found:\n\n");
            for (n = 0; n < this.m_allTheRules[0].size(); ++n) {
                stringBuffer.append(Utils.doubleToString((double)n + 1.0, (int)(Math.log(this.m_numRules) / Math.log(10.0) + 1.0), 0) + ". " + ((AprioriItemSet)this.m_allTheRules[0].elementAt(n)).toString(this.m_instances) + " ==> " + ((AprioriItemSet)this.m_allTheRules[1].elementAt(n)).toString(this.m_instances) + "    conf:(" + Utils.doubleToString((Double)this.m_allTheRules[2].elementAt(n), 2) + ")");
                if (this.m_metricType != 0 || this.m_significanceLevel != -1.0) {
                    stringBuffer.append((this.m_metricType == 1 ? " <" : "") + " lift:(" + Utils.doubleToString((Double)this.m_allTheRules[3].elementAt(n), 2) + ")" + (this.m_metricType == 1 ? ">" : ""));
                    stringBuffer.append((this.m_metricType == 2 ? " <" : "") + " lev:(" + Utils.doubleToString((Double)this.m_allTheRules[4].elementAt(n), 2) + ")");
                    stringBuffer.append(" [" + (int)((Double)this.m_allTheRules[4].elementAt(n) * (double)this.m_instances.numInstances()) + "]" + (this.m_metricType == 2 ? ">" : ""));
                    stringBuffer.append((this.m_metricType == 3 ? " <" : "") + " conv:(" + Utils.doubleToString((Double)this.m_allTheRules[5].elementAt(n), 2) + ")" + (this.m_metricType == 3 ? ">" : ""));
                }
                stringBuffer.append('\n');
            }
        } else {
            int n;
            for (n = 0; n < this.m_Ls.size(); ++n) {
                stringBuffer.append("\nSize of set of large itemsets L(" + (n + 1) + "): " + ((FastVector)this.m_Ls.elementAt(n)).size() + '\n');
                if (!this.m_outputItemSets) continue;
                stringBuffer.append("\nLarge Itemsets L(" + (n + 1) + "):\n");
                for (int i = 0; i < ((FastVector)this.m_Ls.elementAt(n)).size(); ++i) {
                    stringBuffer.append(((ItemSet)((FastVector)this.m_Ls.elementAt(n)).elementAt(i)).toString(this.m_instances) + "\n");
                    stringBuffer.append(((LabeledItemSet)((FastVector)this.m_Ls.elementAt((int)n)).elementAt((int)i)).m_classLabel + "  ");
                    stringBuffer.append(((LabeledItemSet)((FastVector)this.m_Ls.elementAt(n)).elementAt(i)).support() + "\n");
                }
            }
            stringBuffer.append("\nBest rules found:\n\n");
            for (n = 0; n < this.m_allTheRules[0].size(); ++n) {
                stringBuffer.append(Utils.doubleToString((double)n + 1.0, (int)(Math.log(this.m_numRules) / Math.log(10.0) + 1.0), 0) + ". " + ((ItemSet)this.m_allTheRules[0].elementAt(n)).toString(this.m_instances) + " ==> " + ((ItemSet)this.m_allTheRules[1].elementAt(n)).toString(this.m_onlyClass) + "    conf:(" + Utils.doubleToString((Double)this.m_allTheRules[2].elementAt(n), 2) + ")");
                stringBuffer.append('\n');
            }
        }
        return stringBuffer.toString();
    }

    public String metricString() {
        switch (this.m_metricType) {
            case 1: {
                return "lif";
            }
            case 2: {
                return "leverage";
            }
            case 3: {
                return "conviction";
            }
        }
        return "conf";
    }

    public String removeAllMissingColsTipText() {
        return "Remove columns with all missing values.";
    }

    public void setRemoveAllMissingCols(boolean bl) {
        this.m_removeMissingCols = bl;
    }

    public boolean getRemoveAllMissingCols() {
        return this.m_removeMissingCols;
    }

    public String upperBoundMinSupportTipText() {
        return "Upper bound for minimum support. Start iteratively decreasing minimum support from this value.";
    }

    public double getUpperBoundMinSupport() {
        return this.m_upperBoundMinSupport;
    }

    public void setUpperBoundMinSupport(double d) {
        this.m_upperBoundMinSupport = d;
    }

    public void setClassIndex(int n) {
        this.m_classIndex = n;
    }

    public int getClassIndex() {
        return this.m_classIndex;
    }

    public String classIndexTipText() {
        return "Index of the class attribute. If set to -1, the last attribute is taken as class attribute.";
    }

    public void setCar(boolean bl) {
        this.m_car = bl;
    }

    public boolean getCar() {
        return this.m_car;
    }

    public String carTipText() {
        return "If enabled class association rules are mined instead of (general) association rules.";
    }

    public String lowerBoundMinSupportTipText() {
        return "Lower bound for minimum support.";
    }

    public double getLowerBoundMinSupport() {
        return this.m_lowerBoundMinSupport;
    }

    public void setLowerBoundMinSupport(double d) {
        this.m_lowerBoundMinSupport = d;
    }

    public SelectedTag getMetricType() {
        return new SelectedTag(this.m_metricType, TAGS_SELECTION);
    }

    public String metricTypeTipText() {
        return "Set the type of metric by which to rank rules. Confidence is the proportion of the examples covered by the premise that are also covered by the consequence(Class association rules can only be mined using confidence). Lift is confidence divided by the proportion of all examples that are covered by the consequence. This is a measure of the importance of the association that is independent of support. Leverage is the proportion of additional examples covered by both the premise and consequence above those expected if the premise and consequence were independent of each other. The total number of examples that this represents is presented in brackets following the leverage. Conviction is another measure of departure from independence. Conviction is given by ";
    }

    public void setMetricType(SelectedTag selectedTag) {
        if (selectedTag.getTags() == TAGS_SELECTION) {
            this.m_metricType = selectedTag.getSelectedTag().getID();
        }
        if (this.m_significanceLevel != -1.0 && this.m_metricType != 0) {
            this.m_metricType = 0;
        }
        if (this.m_metricType == 0) {
            this.setMinMetric(0.9);
        }
        if (this.m_metricType == 1 || this.m_metricType == 3) {
            this.setMinMetric(1.1);
        }
        if (this.m_metricType == 2) {
            this.setMinMetric(0.1);
        }
    }

    public String minMetricTipText() {
        return "Minimum metric score. Consider only rules with scores higher than this value.";
    }

    public double getMinMetric() {
        return this.m_minMetric;
    }

    public void setMinMetric(double d) {
        this.m_minMetric = d;
    }

    public String numRulesTipText() {
        return "Number of rules to find.";
    }

    public int getNumRules() {
        return this.m_numRules;
    }

    public void setNumRules(int n) {
        this.m_numRules = n;
    }

    public String deltaTipText() {
        return "Iteratively decrease support by this factor. Reduces support until min support is reached or required number of rules has been generated.";
    }

    public double getDelta() {
        return this.m_delta;
    }

    public void setDelta(double d) {
        this.m_delta = d;
    }

    public String significanceLevelTipText() {
        return "Significance level. Significance test (confidence metric only).";
    }

    public double getSignificanceLevel() {
        return this.m_significanceLevel;
    }

    public void setSignificanceLevel(double d) {
        this.m_significanceLevel = d;
    }

    public void setOutputItemSets(boolean bl) {
        this.m_outputItemSets = bl;
    }

    public boolean getOutputItemSets() {
        return this.m_outputItemSets;
    }

    public String outputItemSetsTipText() {
        return "If enabled the itemsets are output as well.";
    }

    public void setVerbose(boolean bl) {
        this.m_verbose = bl;
    }

    public boolean getVerbose() {
        return this.m_verbose;
    }

    public String verboseTipText() {
        return "If enabled the algorithm will be run in verbose mode.";
    }

    private void findLargeItemSets() throws Exception {
        int n = 0;
        int n2 = (int)(this.m_minSupport * (double)this.m_instances.numInstances() + 0.5);
        int n3 = (int)(this.m_upperBoundMinSupport * (double)this.m_instances.numInstances() + 0.5);
        FastVector fastVector = AprioriItemSet.singletons(this.m_instances);
        AprioriItemSet.upDateCounters(fastVector, this.m_instances);
        fastVector = AprioriItemSet.deleteItemSets(fastVector, n2, n3);
        if (fastVector.size() == 0) {
            return;
        }
        do {
            this.m_Ls.addElement(fastVector);
            FastVector fastVector2 = fastVector;
            fastVector = AprioriItemSet.mergeAllItemSets(fastVector2, n, this.m_instances.numInstances());
            Hashtable hashtable = AprioriItemSet.getHashtable(fastVector2, fastVector2.size());
            this.m_hashtables.addElement(hashtable);
            fastVector = AprioriItemSet.pruneItemSets(fastVector, hashtable);
            AprioriItemSet.upDateCounters(fastVector, this.m_instances);
            fastVector = AprioriItemSet.deleteItemSets(fastVector, n2, n3);
            ++n;
        } while (fastVector.size() > 0);
    }

    private void findRulesBruteForce() throws Exception {
        for (int i = 1; i < this.m_Ls.size(); ++i) {
            FastVector fastVector = (FastVector)this.m_Ls.elementAt(i);
            Enumeration enumeration = fastVector.elements();
            while (enumeration.hasMoreElements()) {
                AprioriItemSet aprioriItemSet = (AprioriItemSet)enumeration.nextElement();
                FastVector[] fastVectorArray = aprioriItemSet.generateRulesBruteForce(this.m_minMetric, this.m_metricType, this.m_hashtables, i + 1, this.m_instances.numInstances(), this.m_significanceLevel);
                for (int j = 0; j < fastVectorArray[0].size(); ++j) {
                    this.m_allTheRules[0].addElement(fastVectorArray[0].elementAt(j));
                    this.m_allTheRules[1].addElement(fastVectorArray[1].elementAt(j));
                    this.m_allTheRules[2].addElement(fastVectorArray[2].elementAt(j));
                    this.m_allTheRules[3].addElement(fastVectorArray[3].elementAt(j));
                    this.m_allTheRules[4].addElement(fastVectorArray[4].elementAt(j));
                    this.m_allTheRules[5].addElement(fastVectorArray[5].elementAt(j));
                }
            }
        }
    }

    private void findRulesQuickly() throws Exception {
        for (int i = 1; i < this.m_Ls.size(); ++i) {
            FastVector fastVector = (FastVector)this.m_Ls.elementAt(i);
            Enumeration enumeration = fastVector.elements();
            while (enumeration.hasMoreElements()) {
                AprioriItemSet aprioriItemSet = (AprioriItemSet)enumeration.nextElement();
                FastVector[] fastVectorArray = aprioriItemSet.generateRules(this.m_minMetric, this.m_hashtables, i + 1);
                for (int j = 0; j < fastVectorArray[0].size(); ++j) {
                    this.m_allTheRules[0].addElement(fastVectorArray[0].elementAt(j));
                    this.m_allTheRules[1].addElement(fastVectorArray[1].elementAt(j));
                    this.m_allTheRules[2].addElement(fastVectorArray[2].elementAt(j));
                }
            }
        }
    }

    private void findLargeCarItemSets() throws Exception {
        int n = 0;
        double d = this.m_minSupport * (double)this.m_instances.numInstances();
        double d2 = this.m_upperBoundMinSupport * (double)this.m_instances.numInstances();
        int n2 = Math.rint(d) == d ? (int)d : Math.round((float)(d + 0.5));
        int n3 = Math.rint(d2) == d2 ? (int)d2 : Math.round((float)(d2 + 0.5));
        FastVector fastVector = LabeledItemSet.singletons(this.m_instances, this.m_onlyClass);
        LabeledItemSet.upDateCounters(fastVector, this.m_instances, this.m_onlyClass);
        fastVector = LabeledItemSet.deleteItemSets(fastVector, n2, n3);
        if (fastVector.size() == 0) {
            return;
        }
        do {
            this.m_Ls.addElement(fastVector);
            FastVector fastVector2 = fastVector;
            fastVector = LabeledItemSet.mergeAllItemSets(fastVector2, n, this.m_instances.numInstances());
            Hashtable hashtable = LabeledItemSet.getHashtable(fastVector2, fastVector2.size());
            fastVector = LabeledItemSet.pruneItemSets(fastVector, hashtable);
            LabeledItemSet.upDateCounters(fastVector, this.m_instances, this.m_onlyClass);
            fastVector = LabeledItemSet.deleteItemSets(fastVector, n2, n3);
            ++n;
        } while (fastVector.size() > 0);
    }

    private void findCarRulesQuickly() throws Exception {
        for (int i = 0; i < this.m_Ls.size(); ++i) {
            FastVector fastVector = (FastVector)this.m_Ls.elementAt(i);
            Enumeration enumeration = fastVector.elements();
            while (enumeration.hasMoreElements()) {
                LabeledItemSet labeledItemSet = (LabeledItemSet)enumeration.nextElement();
                FastVector[] fastVectorArray = labeledItemSet.generateRules(this.m_minMetric, false);
                for (int j = 0; j < fastVectorArray[0].size(); ++j) {
                    this.m_allTheRules[0].addElement(fastVectorArray[0].elementAt(j));
                    this.m_allTheRules[1].addElement(fastVectorArray[1].elementAt(j));
                    this.m_allTheRules[2].addElement(fastVectorArray[2].elementAt(j));
                }
            }
        }
    }

    public FastVector[] getAllTheRules() {
        return this.m_allTheRules;
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.31 $");
    }

    public static void main(String[] stringArray) {
        Apriori.runAssociator(new Apriori(), stringArray);
    }
}

