/*
 * Decompiled with CFR 0.152.
 */
package weka.core.tokenizers;

import java.util.Enumeration;
import java.util.Vector;
import weka.core.Option;
import weka.core.Utils;
import weka.core.tokenizers.Tokenizer;

public abstract class CharacterDelimitedTokenizer
extends Tokenizer {
    protected String m_Delimiters = " \r\n\t.,;:'\"()?!";

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>();
        vector.addElement(new Option("\tThe delimiters to use\n\t(default ' \\r\\n\\t.,;:'\"()?!').", "delimiters", 1, "-delimiters <value>"));
        return vector.elements();
    }

    public String[] getOptions() {
        Vector<String> vector = new Vector<String>();
        vector.add("-delimiters");
        vector.add(this.getDelimiters());
        return vector.toArray(new String[vector.size()]);
    }

    public void setOptions(String[] stringArray) throws Exception {
        String string = Utils.getOption("delimiters", stringArray);
        if (string.length() != 0) {
            this.setDelimiters(string);
        } else {
            this.setDelimiters(" \r\n\t.,;:'\"()?!");
        }
    }

    public String getDelimiters() {
        return this.m_Delimiters;
    }

    public void setDelimiters(String string) {
        this.m_Delimiters = Utils.unbackQuoteChars(string);
    }

    public String delimitersTipText() {
        return "Set of delimiter characters to use in tokenizing (\\r, \\n and \\t can be used for carriage-return, line-feed and tab)";
    }
}

