/*
 * Decompiled with CFR 0.152.
 */
package weka.core.neighboursearch;

import java.util.Enumeration;
import java.util.Vector;
import weka.core.DistanceFunction;
import weka.core.EuclideanDistance;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;
import weka.core.neighboursearch.NearestNeighbourSearch;
import weka.core.neighboursearch.TreePerformanceStats;
import weka.core.neighboursearch.kdtrees.KDTreeNode;
import weka.core.neighboursearch.kdtrees.KDTreeNodeSplitter;
import weka.core.neighboursearch.kdtrees.SlidingMidPointOfWidestSide;

public class KDTree
extends NearestNeighbourSearch
implements TechnicalInformationHandler {
    private static final long serialVersionUID = 1505717283763272533L;
    protected double[] m_DistanceList;
    protected int[] m_InstList;
    protected KDTreeNode m_Root;
    protected KDTreeNodeSplitter m_Splitter = new SlidingMidPointOfWidestSide();
    protected int m_NumNodes;
    protected int m_NumLeaves;
    protected int m_MaxDepth;
    protected TreePerformanceStats m_TreeStats = null;
    public static final int MIN = 0;
    public static final int MAX = 1;
    public static final int WIDTH = 2;
    boolean m_NormalizeNodeWidth = true;
    protected EuclideanDistance m_EuclideanDistance;
    protected double m_MinBoxRelWidth;
    protected int m_MaxInstInLeaf;

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation technicalInformation = new TechnicalInformation(TechnicalInformation.Type.ARTICLE);
        technicalInformation.setValue(TechnicalInformation.Field.AUTHOR, "Jerome H. Friedman and Jon Luis Bentley and Raphael Ari Finkel");
        technicalInformation.setValue(TechnicalInformation.Field.YEAR, "1977");
        technicalInformation.setValue(TechnicalInformation.Field.TITLE, "An Algorithm for Finding Best Matches in Logarithmic Expected Time");
        technicalInformation.setValue(TechnicalInformation.Field.JOURNAL, "ACM Transactions on Mathematics Software");
        technicalInformation.setValue(TechnicalInformation.Field.PAGES, "209-226");
        technicalInformation.setValue(TechnicalInformation.Field.MONTH, "September");
        technicalInformation.setValue(TechnicalInformation.Field.VOLUME, "3");
        technicalInformation.setValue(TechnicalInformation.Field.NUMBER, "3");
        TechnicalInformation technicalInformation2 = technicalInformation.add(TechnicalInformation.Type.TECHREPORT);
        technicalInformation2.setValue(TechnicalInformation.Field.AUTHOR, "Andrew Moore");
        technicalInformation2.setValue(TechnicalInformation.Field.YEAR, "1991");
        technicalInformation2.setValue(TechnicalInformation.Field.TITLE, "A tutorial on kd-trees");
        technicalInformation2.setValue(TechnicalInformation.Field.HOWPUBLISHED, "Extract from PhD Thesis");
        technicalInformation2.setValue(TechnicalInformation.Field.BOOKTITLE, "University of Cambridge Computer Laboratory Technical Report No. 209");
        technicalInformation2.setValue(TechnicalInformation.Field.HTTP, "Available from http://www.autonlab.org/autonweb/14665.html");
        return technicalInformation;
    }

    public KDTree() {
        if (this.m_DistanceFunction instanceof EuclideanDistance) {
            this.m_EuclideanDistance = (EuclideanDistance)this.m_DistanceFunction;
        } else {
            this.m_EuclideanDistance = new EuclideanDistance();
            this.m_DistanceFunction = this.m_EuclideanDistance;
        }
        this.m_MinBoxRelWidth = 0.01;
        this.m_MaxInstInLeaf = 40;
        if (this.getMeasurePerformance()) {
            this.m_TreeStats = new TreePerformanceStats();
            this.m_Stats = this.m_TreeStats;
        }
    }

    public KDTree(Instances instances) {
        super(instances);
        if (this.m_DistanceFunction instanceof EuclideanDistance) {
            this.m_EuclideanDistance = (EuclideanDistance)this.m_DistanceFunction;
        } else {
            this.m_EuclideanDistance = new EuclideanDistance();
            this.m_DistanceFunction = this.m_EuclideanDistance;
        }
        this.m_MinBoxRelWidth = 0.01;
        this.m_MaxInstInLeaf = 40;
        if (this.getMeasurePerformance()) {
            this.m_TreeStats = new TreePerformanceStats();
            this.m_Stats = this.m_TreeStats;
        }
    }

    protected void buildKDTree(Instances instances) throws Exception {
        this.checkMissing(instances);
        if (this.m_EuclideanDistance == null) {
            this.m_EuclideanDistance = new EuclideanDistance(instances);
            this.m_DistanceFunction = this.m_EuclideanDistance;
        } else {
            this.m_EuclideanDistance.setInstances(instances);
        }
        this.m_Instances = instances;
        int n = this.m_Instances.numInstances();
        this.m_InstList = new int[n];
        for (int i = 0; i < n; ++i) {
            this.m_InstList[i] = i;
        }
        double[][] dArray = this.m_EuclideanDistance.getRanges();
        this.m_Splitter.setInstances(this.m_Instances);
        this.m_Splitter.setInstanceList(this.m_InstList);
        this.m_Splitter.setEuclideanDistanceFunction(this.m_EuclideanDistance);
        this.m_Splitter.setNodeWidthNormalization(this.m_NormalizeNodeWidth);
        this.m_NumLeaves = 1;
        this.m_NumNodes = 1;
        this.m_MaxDepth = 0;
        this.m_Root = new KDTreeNode(this.m_NumNodes, 0, this.m_Instances.numInstances() - 1, dArray);
        this.splitNodes(this.m_Root, dArray, this.m_MaxDepth + 1);
    }

    protected void splitNodes(KDTreeNode kDTreeNode, double[][] dArray, int n) throws Exception {
        double[][] dArray2 = this.m_EuclideanDistance.initializeRanges(this.m_InstList, kDTreeNode.m_Start, kDTreeNode.m_End);
        if (kDTreeNode.numInstances() <= this.m_MaxInstInLeaf || this.getMaxRelativeNodeWidth(dArray2, dArray) <= this.m_MinBoxRelWidth) {
            return;
        }
        --this.m_NumLeaves;
        if (n > this.m_MaxDepth) {
            this.m_MaxDepth = n;
        }
        this.m_Splitter.splitNode(kDTreeNode, this.m_NumNodes, dArray2, dArray);
        this.m_NumNodes += 2;
        this.m_NumLeaves += 2;
        this.splitNodes(kDTreeNode.m_Left, dArray, n + 1);
        this.splitNodes(kDTreeNode.m_Right, dArray, n + 1);
    }

    protected void findNearestNeighbours(Instance instance, KDTreeNode kDTreeNode, int n, NearestNeighbourSearch.MyHeap myHeap, double d) throws Exception {
        if (kDTreeNode.isALeaf()) {
            if (this.m_TreeStats != null) {
                this.m_TreeStats.updatePointCount(kDTreeNode.numInstances());
                this.m_TreeStats.incrLeafCount();
            }
            for (int i = kDTreeNode.m_Start; i <= kDTreeNode.m_End; ++i) {
                double d2;
                if (instance == this.m_Instances.instance(this.m_InstList[i])) continue;
                if (myHeap.size() < n) {
                    d2 = this.m_EuclideanDistance.distance(instance, this.m_Instances.instance(this.m_InstList[i]), Double.POSITIVE_INFINITY, this.m_Stats);
                    myHeap.put(this.m_InstList[i], d2);
                    continue;
                }
                NearestNeighbourSearch.MyHeapElement myHeapElement = myHeap.peek();
                d2 = this.m_EuclideanDistance.distance(instance, this.m_Instances.instance(this.m_InstList[i]), myHeapElement.distance, this.m_Stats);
                if (d2 < myHeapElement.distance) {
                    myHeap.putBySubstitute(this.m_InstList[i], d2);
                    continue;
                }
                if (d2 != myHeapElement.distance) continue;
                myHeap.putKthNearest(this.m_InstList[i], d2);
            }
        } else {
            KDTreeNode kDTreeNode2;
            KDTreeNode kDTreeNode3;
            boolean bl;
            if (this.m_TreeStats != null) {
                this.m_TreeStats.incrIntNodeCount();
            }
            if (bl = this.m_EuclideanDistance.valueIsSmallerEqual(instance, kDTreeNode.m_SplitDim, kDTreeNode.m_SplitValue)) {
                kDTreeNode3 = kDTreeNode.m_Left;
                kDTreeNode2 = kDTreeNode.m_Right;
            } else {
                kDTreeNode3 = kDTreeNode.m_Right;
                kDTreeNode2 = kDTreeNode.m_Left;
            }
            this.findNearestNeighbours(instance, kDTreeNode3, n, myHeap, d);
            if (myHeap.size() < n) {
                double d3 = d + this.m_EuclideanDistance.sqDifference(kDTreeNode.m_SplitDim, instance.value(kDTreeNode.m_SplitDim), kDTreeNode.m_SplitValue);
                this.findNearestNeighbours(instance, kDTreeNode2, n, myHeap, d3);
                return;
            }
            double d4 = d + this.m_EuclideanDistance.sqDifference(kDTreeNode.m_SplitDim, instance.value(kDTreeNode.m_SplitDim), kDTreeNode.m_SplitValue);
            if (myHeap.peek().distance >= d4) {
                this.findNearestNeighbours(instance, kDTreeNode2, n, myHeap, d4);
            }
        }
    }

    public Instances kNearestNeighbours(Instance instance, int n) throws Exception {
        NearestNeighbourSearch.MyHeapElement myHeapElement;
        this.checkMissing(instance);
        if (this.m_Stats != null) {
            this.m_Stats.searchStart();
        }
        NearestNeighbourSearch.MyHeap myHeap = new NearestNeighbourSearch.MyHeap(this, n);
        this.findNearestNeighbours(instance, this.m_Root, n, myHeap, 0.0);
        if (this.m_Stats != null) {
            this.m_Stats.searchFinish();
        }
        Instances instances = new Instances(this.m_Instances, myHeap.size() + myHeap.noOfKthNearest());
        this.m_DistanceList = new double[myHeap.size() + myHeap.noOfKthNearest()];
        int[] nArray = new int[myHeap.size() + myHeap.noOfKthNearest()];
        int n2 = nArray.length - 1;
        while (myHeap.noOfKthNearest() > 0) {
            myHeapElement = myHeap.getKthNearest();
            nArray[n2] = myHeapElement.index;
            this.m_DistanceList[n2] = myHeapElement.distance;
            --n2;
        }
        while (myHeap.size() > 0) {
            myHeapElement = myHeap.get();
            nArray[n2] = myHeapElement.index;
            this.m_DistanceList[n2] = myHeapElement.distance;
            --n2;
        }
        this.m_DistanceFunction.postProcessDistances(this.m_DistanceList);
        for (int i = 0; i < nArray.length; ++i) {
            instances.add(this.m_Instances.instance(nArray[i]));
        }
        return instances;
    }

    public Instance nearestNeighbour(Instance instance) throws Exception {
        return this.kNearestNeighbours(instance, 1).instance(0);
    }

    public double[] getDistances() throws Exception {
        if (this.m_Instances == null || this.m_DistanceList == null) {
            throw new Exception("The tree has not been supplied with a set of instances or getDistances() has been called before calling kNearestNeighbours().");
        }
        return this.m_DistanceList;
    }

    public void setInstances(Instances instances) throws Exception {
        super.setInstances(instances);
        this.buildKDTree(instances);
    }

    public void update(Instance instance) throws Exception {
        if (this.m_Instances == null) {
            throw new Exception("No instances supplied yet. Have to call setInstances(instances) with a set of Instances first.");
        }
        this.addInstanceInfo(instance);
        this.addInstanceToTree(instance, this.m_Root);
    }

    protected void addInstanceToTree(Instance instance, KDTreeNode kDTreeNode) throws Exception {
        if (kDTreeNode.isALeaf()) {
            int[] nArray = new int[this.m_Instances.numInstances()];
            try {
                System.arraycopy(this.m_InstList, 0, nArray, 0, kDTreeNode.m_End + 1);
                if (kDTreeNode.m_End < this.m_InstList.length - 1) {
                    System.arraycopy(this.m_InstList, kDTreeNode.m_End + 1, nArray, kDTreeNode.m_End + 2, this.m_InstList.length - kDTreeNode.m_End - 1);
                }
                nArray[kDTreeNode.m_End + 1] = this.m_Instances.numInstances() - 1;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                System.err.println("m_InstList.length: " + this.m_InstList.length + " instList.length: " + nArray.length + "node.m_End+1: " + (kDTreeNode.m_End + 1) + "m_InstList.length-node.m_End+1: " + (this.m_InstList.length - kDTreeNode.m_End - 1));
                throw arrayIndexOutOfBoundsException;
            }
            this.m_InstList = nArray;
            ++kDTreeNode.m_End;
            kDTreeNode.m_NodeRanges = this.m_EuclideanDistance.updateRanges(instance, kDTreeNode.m_NodeRanges);
            this.m_Splitter.setInstanceList(this.m_InstList);
            double[][] dArray = this.m_EuclideanDistance.getRanges();
            if (kDTreeNode.numInstances() > this.m_MaxInstInLeaf && this.getMaxRelativeNodeWidth(kDTreeNode.m_NodeRanges, dArray) > this.m_MinBoxRelWidth) {
                this.m_Splitter.splitNode(kDTreeNode, this.m_NumNodes, kDTreeNode.m_NodeRanges, dArray);
                this.m_NumNodes += 2;
            }
        } else {
            if (this.m_EuclideanDistance.valueIsSmallerEqual(instance, kDTreeNode.m_SplitDim, kDTreeNode.m_SplitValue)) {
                this.addInstanceToTree(instance, kDTreeNode.m_Left);
                this.afterAddInstance(kDTreeNode.m_Right);
            } else {
                this.addInstanceToTree(instance, kDTreeNode.m_Right);
            }
            ++kDTreeNode.m_End;
            kDTreeNode.m_NodeRanges = this.m_EuclideanDistance.updateRanges(instance, kDTreeNode.m_NodeRanges);
        }
    }

    protected void afterAddInstance(KDTreeNode kDTreeNode) {
        ++kDTreeNode.m_Start;
        ++kDTreeNode.m_End;
        if (!kDTreeNode.isALeaf()) {
            this.afterAddInstance(kDTreeNode.m_Left);
            this.afterAddInstance(kDTreeNode.m_Right);
        }
    }

    public void addInstanceInfo(Instance instance) {
        this.m_EuclideanDistance.updateRanges(instance);
    }

    protected void checkMissing(Instances instances) throws Exception {
        for (int i = 0; i < instances.numInstances(); ++i) {
            Instance instance = instances.instance(i);
            for (int j = 0; j < instance.numValues(); ++j) {
                if (instance.index(j) == instance.classIndex() || !instance.isMissingSparse(j)) continue;
                throw new Exception("ERROR: KDTree can not deal with missing values. Please run ReplaceMissingValues filter on the dataset before passing it on to the KDTree.");
            }
        }
    }

    protected void checkMissing(Instance instance) throws Exception {
        for (int i = 0; i < instance.numValues(); ++i) {
            if (instance.index(i) == instance.classIndex() || !instance.isMissingSparse(i)) continue;
            throw new Exception("ERROR: KDTree can not deal with missing values. Please run ReplaceMissingValues filter on the dataset before passing it on to the KDTree.");
        }
    }

    protected double getMaxRelativeNodeWidth(double[][] dArray, double[][] dArray2) {
        int n = this.widestDim(dArray, dArray2);
        return dArray[n][2] / dArray2[n][2];
    }

    protected int widestDim(double[][] dArray, double[][] dArray2) {
        int n = this.m_Instances.classIndex();
        double d = 0.0;
        int n2 = -1;
        if (this.m_NormalizeNodeWidth) {
            for (int i = 0; i < dArray.length; ++i) {
                double d2 = dArray[i][2] / dArray2[i][2];
                if (!(d2 > d) || i == n) continue;
                d = d2;
                n2 = i;
            }
        } else {
            for (int i = 0; i < dArray.length; ++i) {
                if (!(dArray[i][2] > d) || i == n) continue;
                d = dArray[i][2];
                n2 = i;
            }
        }
        return n2;
    }

    public double measureTreeSize() {
        return this.m_NumNodes;
    }

    public double measureNumLeaves() {
        return this.m_NumLeaves;
    }

    public double measureMaxDepth() {
        return this.m_MaxDepth;
    }

    public Enumeration enumerateMeasures() {
        Vector<String> vector = new Vector<String>();
        vector.addElement("measureTreeSize");
        vector.addElement("measureNumLeaves");
        vector.addElement("measureMaxDepth");
        if (this.m_Stats != null) {
            Enumeration enumeration = this.m_Stats.enumerateMeasures();
            while (enumeration.hasMoreElements()) {
                vector.addElement((String)enumeration.nextElement());
            }
        }
        return vector.elements();
    }

    public double getMeasure(String string) {
        if (string.compareToIgnoreCase("measureMaxDepth") == 0) {
            return this.measureMaxDepth();
        }
        if (string.compareToIgnoreCase("measureTreeSize") == 0) {
            return this.measureTreeSize();
        }
        if (string.compareToIgnoreCase("measureNumLeaves") == 0) {
            return this.measureNumLeaves();
        }
        if (this.m_Stats != null) {
            return this.m_Stats.getMeasure(string);
        }
        throw new IllegalArgumentException(string + " not supported (KDTree)");
    }

    public void setMeasurePerformance(boolean bl) {
        this.m_MeasurePerformance = bl;
        if (this.m_MeasurePerformance) {
            if (this.m_Stats == null) {
                this.m_TreeStats = new TreePerformanceStats();
                this.m_Stats = this.m_TreeStats;
            }
        } else {
            this.m_TreeStats = null;
            this.m_Stats = null;
        }
    }

    public void centerInstances(Instances instances, int[] nArray, double d) throws Exception {
        int[] nArray2 = new int[instances.numInstances()];
        for (int i = 0; i < instances.numInstances(); ++i) {
            nArray2[i] = i;
        }
        this.determineAssignments(this.m_Root, instances, nArray2, nArray, d);
    }

    protected void determineAssignments(KDTreeNode kDTreeNode, Instances instances, int[] nArray, int[] nArray2, double d) throws Exception {
        int[] nArray3 = this.refineOwners(kDTreeNode, instances, nArray);
        if (nArray3.length == 1) {
            for (int i = kDTreeNode.m_Start; i <= kDTreeNode.m_End; ++i) {
                nArray2[this.m_InstList[i]] = nArray3[0];
            }
        } else if (!kDTreeNode.isALeaf()) {
            this.determineAssignments(kDTreeNode.m_Left, instances, nArray3, nArray2, d);
            this.determineAssignments(kDTreeNode.m_Right, instances, nArray3, nArray2, d);
        } else {
            this.assignSubToCenters(kDTreeNode, instances, nArray3, nArray2);
        }
    }

    protected int[] refineOwners(KDTreeNode kDTreeNode, Instances instances, int[] nArray) throws Exception {
        int n;
        int[] nArray2 = new int[nArray.length];
        double d = Double.POSITIVE_INFINITY;
        int n2 = -1;
        int n3 = nArray.length;
        double[] dArray = new double[n3];
        boolean[] blArray = new boolean[n3];
        for (n = 0; n < n3; ++n) {
            dArray[n] = this.distanceToHrect(kDTreeNode, instances.instance(nArray[n]));
            boolean bl = blArray[n] = dArray[n] == 0.0;
            if (!(dArray[n] < d)) continue;
            d = dArray[n];
            n2 = n;
        }
        Instance instance = new Instance(instances.instance(nArray[n2]));
        n = 0;
        for (int i = 0; i < n3; ++i) {
            if (blArray[i] || dArray[i] == dArray[n2]) {
                nArray2[n++] = nArray[i];
                continue;
            }
            Instance instance2 = new Instance(instances.instance(nArray[i]));
            if (this.candidateIsFullOwner(kDTreeNode, instance, instance2)) continue;
            nArray2[n++] = nArray[i];
        }
        int[] nArray3 = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray3[i] = nArray2[i];
        }
        return nArray3;
    }

    protected double distanceToHrect(KDTreeNode kDTreeNode, Instance instance) throws Exception {
        double d = 0.0;
        Instance instance2 = new Instance(instance);
        boolean bl = this.clipToInsideHrect(kDTreeNode, instance2);
        if (!bl) {
            d = this.m_EuclideanDistance.distance(instance2, instance);
        }
        return d;
    }

    protected boolean clipToInsideHrect(KDTreeNode kDTreeNode, Instance instance) {
        boolean bl = true;
        for (int i = 0; i < this.m_Instances.numAttributes(); ++i) {
            if (instance.value(i) < kDTreeNode.m_NodeRanges[i][0]) {
                instance.setValue(i, kDTreeNode.m_NodeRanges[i][0]);
                bl = false;
                continue;
            }
            if (!(instance.value(i) > kDTreeNode.m_NodeRanges[i][1])) continue;
            instance.setValue(i, kDTreeNode.m_NodeRanges[i][1]);
            bl = false;
        }
        return bl;
    }

    protected boolean candidateIsFullOwner(KDTreeNode kDTreeNode, Instance instance, Instance instance2) throws Exception {
        int n;
        Instance instance3 = new Instance(instance);
        for (n = 0; n < this.m_Instances.numAttributes(); ++n) {
            if (instance2.value(n) - instance.value(n) > 0.0) {
                instance3.setValue(n, kDTreeNode.m_NodeRanges[n][1]);
                continue;
            }
            instance3.setValue(n, kDTreeNode.m_NodeRanges[n][0]);
        }
        n = this.m_EuclideanDistance.distance(instance3, instance) < this.m_EuclideanDistance.distance(instance3, instance2) ? 1 : 0;
        return n != 0;
    }

    public void assignSubToCenters(KDTreeNode kDTreeNode, Instances instances, int[] nArray, int[] nArray2) throws Exception {
        int n;
        int n2 = nArray.length;
        if (nArray2 == null) {
            nArray2 = new int[this.m_Instances.numInstances()];
            for (n = 0; n < nArray2.length; ++n) {
                nArray2[n] = -1;
            }
        }
        for (n = kDTreeNode.m_Start; n <= kDTreeNode.m_End; ++n) {
            int n3;
            int n4 = this.m_InstList[n];
            Instance instance = this.m_Instances.instance(n4);
            nArray2[n4] = n3 = this.m_EuclideanDistance.closestPoint(instance, instances, nArray);
        }
    }

    public String minBoxRelWidthTipText() {
        return "The minimum relative width of the box. A node is only made a leaf if the width of the split dimension of the instances in a node normalized over the width of the split dimension of all the instances is less than or equal to this minimum relative width.";
    }

    public void setMinBoxRelWidth(double d) {
        this.m_MinBoxRelWidth = d;
    }

    public double getMinBoxRelWidth() {
        return this.m_MinBoxRelWidth;
    }

    public String maxInstInLeafTipText() {
        return "The max number of instances in a leaf.";
    }

    public void setMaxInstInLeaf(int n) {
        this.m_MaxInstInLeaf = n;
    }

    public int getMaxInstInLeaf() {
        return this.m_MaxInstInLeaf;
    }

    public String normalizeNodeWidthTipText() {
        return "Whether if the widths of the KDTree node should be normalized by the width of the universe or not. Where, width of the node is the range of the split attribute based on the instances in that node, and width of the universe is the range of the split attribute based on all the instances (default: false).";
    }

    public void setNormalizeNodeWidth(boolean bl) {
        this.m_NormalizeNodeWidth = bl;
    }

    public boolean getNormalizeNodeWidth() {
        return this.m_NormalizeNodeWidth;
    }

    public DistanceFunction getDistanceFunction() {
        return this.m_EuclideanDistance;
    }

    public void setDistanceFunction(DistanceFunction distanceFunction) throws Exception {
        if (!(distanceFunction instanceof EuclideanDistance)) {
            throw new Exception("KDTree currently only works with EuclideanDistanceFunction.");
        }
        this.m_EuclideanDistance = (EuclideanDistance)distanceFunction;
        this.m_DistanceFunction = this.m_EuclideanDistance;
    }

    public String nodeSplitterTipText() {
        return "The the splitting method to split the nodes of the KDTree.";
    }

    public KDTreeNodeSplitter getNodeSplitter() {
        return this.m_Splitter;
    }

    public void setNodeSplitter(KDTreeNodeSplitter kDTreeNodeSplitter) {
        this.m_Splitter = kDTreeNodeSplitter;
    }

    public String globalInfo() {
        return "Class implementing the KDTree search algorithm for nearest neighbour search.\nThe connection to dataset is only a reference. For the tree structure the indexes are stored in an array. \nBuilding the tree:\nIf a node has <maximal-inst-number> (option -L) instances no further splitting is done. Also if the split would leave one side empty, the branch is not split any further even if the instances in the resulting node are more than <maximal-inst-number> instances.\n**PLEASE NOTE:** The algorithm can not handle missing values, so it is advisable to run ReplaceMissingValues filter if there are any missing values in the dataset.\n\nFor more information see:\n\n" + this.getTechnicalInformation().toString();
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>();
        vector.add(new Option("\tNode splitting method to use.\n\t(default: weka.core.neighboursearch.kdtrees.SlidingMidPointOfWidestSide)", "S", 1, "-S <classname and options>"));
        vector.addElement(new Option("\tSet minimal width of a box\n\t(default: 1.0E-2).", "W", 0, "-W <value>"));
        vector.addElement(new Option("\tMaximal number of instances in a leaf\n\t(default: 40).", "L", 0, "-L"));
        vector.addElement(new Option("\tNormalizing will be done\n\t(Select dimension for split, with normalising to universe).", "N", 0, "-N"));
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        super.setOptions(stringArray);
        String string = Utils.getOption('S', stringArray);
        if (string.length() != 0) {
            String[] stringArray2 = Utils.splitOptions(string);
            if (stringArray2.length == 0) {
                throw new Exception("Invalid DistanceFunction specification string.");
            }
            String string2 = stringArray2[0];
            stringArray2[0] = "";
            this.setNodeSplitter((KDTreeNodeSplitter)Utils.forName(KDTreeNodeSplitter.class, string2, stringArray2));
        } else {
            this.setNodeSplitter(new SlidingMidPointOfWidestSide());
        }
        string = Utils.getOption('W', stringArray);
        if (string.length() != 0) {
            this.setMinBoxRelWidth(Double.parseDouble(string));
        } else {
            this.setMinBoxRelWidth(0.01);
        }
        string = Utils.getOption('L', stringArray);
        if (string.length() != 0) {
            this.setMaxInstInLeaf(Integer.parseInt(string));
        } else {
            this.setMaxInstInLeaf(40);
        }
        this.setNormalizeNodeWidth(Utils.getFlag('N', stringArray));
    }

    public String[] getOptions() {
        Vector<String> vector = new Vector<String>();
        String[] stringArray = super.getOptions();
        for (int i = 0; i < stringArray.length; ++i) {
            vector.add(stringArray[i]);
        }
        vector.add("-S");
        vector.add((this.m_Splitter.getClass().getName() + " " + Utils.joinOptions(this.m_Splitter.getOptions())).trim());
        vector.add("-W");
        vector.add("" + this.getMinBoxRelWidth());
        vector.add("-L");
        vector.add("" + this.getMaxInstInLeaf());
        if (this.getNormalizeNodeWidth()) {
            vector.add("-N");
        }
        return vector.toArray(new String[vector.size()]);
    }
}

