/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.explorer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import weka.core.Capabilities;
import weka.core.Copyright;
import weka.core.Instances;
import weka.core.Memory;
import weka.core.converters.AbstractFileLoader;
import weka.core.converters.ConverterUtils;
import weka.gui.LogPanel;
import weka.gui.Logger;
import weka.gui.LookAndFeel;
import weka.gui.WekaTaskMonitor;
import weka.gui.explorer.ExplorerDefaults;
import weka.gui.explorer.PreprocessPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Explorer
extends JPanel {
    private static final long serialVersionUID = -7674003708867909578L;
    protected PreprocessPanel m_PreprocessPanel = new PreprocessPanel();
    protected Vector<ExplorerPanel> m_Panels = new Vector();
    protected JTabbedPane m_TabbedPane = new JTabbedPane();
    protected LogPanel m_LogPanel = new LogPanel(new WekaTaskMonitor());
    protected HashSet<CapabilitiesFilterChangeListener> m_CapabilitiesFilterChangeListeners = new HashSet();
    private static Explorer m_explorer;
    private static Memory m_Memory;

    public Explorer() {
        Object object;
        int n;
        String string = new SimpleDateFormat("EEEE, d MMMM yyyy").format(new Date());
        this.m_LogPanel.logMessage("Weka Explorer");
        this.m_LogPanel.logMessage("(c) " + Copyright.getFromYear() + "-" + Copyright.getToYear() + " " + Copyright.getOwner() + ", " + Copyright.getAddress());
        this.m_LogPanel.logMessage("web: " + Copyright.getURL());
        this.m_LogPanel.logMessage("Started on " + string);
        this.m_LogPanel.statusMessage("Welcome to the Weka Explorer");
        this.m_PreprocessPanel.setLog(this.m_LogPanel);
        this.m_TabbedPane.addTab(this.m_PreprocessPanel.getTabTitle(), null, this.m_PreprocessPanel, this.m_PreprocessPanel.getTabTitleToolTip());
        String[] stringArray = ExplorerDefaults.getTabs();
        Hashtable hashtable = new Hashtable();
        for (n = 0; n < stringArray.length; ++n) {
            try {
                object = stringArray[n].split(":");
                String string2 = object[0];
                HashSet<String> hashSet = new HashSet<String>();
                hashtable.put(string2, hashSet);
                for (int i = 1; i < ((String[])object).length; ++i) {
                    hashSet.add(object[i]);
                }
                ExplorerPanel explorerPanel = (ExplorerPanel)Class.forName(string2).newInstance();
                explorerPanel.setExplorer(this);
                this.m_Panels.add(explorerPanel);
                if (explorerPanel instanceof LogHandler) {
                    ((LogHandler)((Object)explorerPanel)).setLog(this.m_LogPanel);
                }
                this.m_TabbedPane.addTab(explorerPanel.getTabTitle(), null, (JPanel)((Object)explorerPanel), explorerPanel.getTabTitleToolTip());
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this.m_TabbedPane.setSelectedIndex(0);
        for (n = 0; n < this.m_Panels.size(); ++n) {
            object = (HashSet)hashtable.get(this.m_Panels.get(n).getClass().getName());
            this.m_TabbedPane.setEnabledAt(n + 1, ((HashSet)object).contains("standalone"));
        }
        this.m_PreprocessPanel.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                for (int i = 0; i < Explorer.this.m_Panels.size(); ++i) {
                    Explorer.this.m_Panels.get(i).setInstances(Explorer.this.m_PreprocessPanel.getInstances());
                    Explorer.this.m_TabbedPane.setEnabledAt(i + 1, true);
                }
            }
        });
        this.m_PreprocessPanel.setExplorer(this);
        this.addCapabilitiesFilterListener(this.m_PreprocessPanel);
        for (n = 0; n < this.m_Panels.size(); ++n) {
            if (!(this.m_Panels.get(n) instanceof CapabilitiesFilterChangeListener)) continue;
            this.addCapabilitiesFilterListener((CapabilitiesFilterChangeListener)((Object)this.m_Panels.get(n)));
        }
        this.setLayout(new BorderLayout());
        this.add((Component)this.m_TabbedPane, "Center");
        this.add((Component)this.m_LogPanel, "South");
    }

    public Vector<ExplorerPanel> getPanels() {
        return this.m_Panels;
    }

    public PreprocessPanel getPreprocessPanel() {
        return this.m_PreprocessPanel;
    }

    public JTabbedPane getTabbedPane() {
        return this.m_TabbedPane;
    }

    public void addCapabilitiesFilterListener(CapabilitiesFilterChangeListener capabilitiesFilterChangeListener) {
        this.m_CapabilitiesFilterChangeListeners.add(capabilitiesFilterChangeListener);
    }

    public boolean removeCapabilitiesFilterListener(CapabilitiesFilterChangeListener capabilitiesFilterChangeListener) {
        return this.m_CapabilitiesFilterChangeListeners.remove(capabilitiesFilterChangeListener);
    }

    public void notifyCapabilitiesFilterListener(Capabilities capabilities) {
        for (CapabilitiesFilterChangeListener capabilitiesFilterChangeListener : this.m_CapabilitiesFilterChangeListeners) {
            if (capabilitiesFilterChangeListener == this) continue;
            capabilitiesFilterChangeListener.capabilitiesFilterChanged(new CapabilitiesFilterChangeEvent(this, capabilities));
        }
    }

    public static void main(String[] stringArray) {
        LookAndFeel.setLookAndFeel();
        try {
            Object object;
            m_explorer = new Explorer();
            final JFrame jFrame = new JFrame("Weka Explorer");
            jFrame.getContentPane().setLayout(new BorderLayout());
            jFrame.getContentPane().add((Component)m_explorer, "Center");
            jFrame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    jFrame.dispose();
                    System.exit(0);
                }
            });
            jFrame.pack();
            jFrame.setSize(800, 600);
            jFrame.setVisible(true);
            Image image = Toolkit.getDefaultToolkit().getImage(ClassLoader.getSystemResource("weka/gui/weka_icon.gif"));
            jFrame.setIconImage(image);
            if (stringArray.length == 1) {
                System.err.println("Loading instances from " + stringArray[0]);
                object = ConverterUtils.getLoaderForFile(stringArray[0]);
                ((AbstractFileLoader)object).setFile(new File(stringArray[0]));
                Explorer.m_explorer.m_PreprocessPanel.setInstancesFromFile((AbstractFileLoader)object);
            }
            object = new Thread(){

                public void run() {
                    while (true) {
                        try {
                            while (true) {
                                3.sleep(4000L);
                                System.gc();
                                if (!m_Memory.isOutOfMemory()) continue;
                                jFrame.dispose();
                                m_explorer = null;
                                System.gc();
                                m_Memory.stopThreads();
                                System.err.println("\ndisplayed message:");
                                m_Memory.showOutOfMemory();
                                System.err.println("\nexiting");
                                System.exit(-1);
                            }
                        }
                        catch (InterruptedException interruptedException) {
                            interruptedException.printStackTrace();
                            continue;
                        }
                        break;
                    }
                }
            };
            ((Thread)object).setPriority(10);
            ((Thread)object).start();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println(exception.getMessage());
        }
    }

    static {
        m_Memory = new Memory(true);
    }

    public static interface LogHandler {
        public void setLog(Logger var1);
    }

    public static interface ExplorerPanel {
        public void setExplorer(Explorer var1);

        public Explorer getExplorer();

        public void setInstances(Instances var1);

        public String getTabTitle();

        public String getTabTitleToolTip();
    }

    public static class CapabilitiesFilterChangeEvent
    extends ChangeEvent {
        private static final long serialVersionUID = 1194260517270385559L;
        protected Capabilities m_Filter;

        public CapabilitiesFilterChangeEvent(Object object, Capabilities capabilities) {
            super(object);
            this.m_Filter = capabilities;
        }

        public Capabilities getFilter() {
            return this.m_Filter;
        }
    }

    public static interface CapabilitiesFilterChangeListener
    extends EventListener {
        public void capabilitiesFilterChanged(CapabilitiesFilterChangeEvent var1);
    }
}

