/*
 * Decompiled with CFR 0.152.
 */
package weka.core.converters;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.util.Enumeration;
import java.util.Hashtable;
import weka.core.Attribute;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.converters.AbstractLoader;
import weka.core.converters.BatchConverter;
import weka.core.converters.ConverterUtils;
import weka.core.converters.FileSourcedConverter;

public class CSVLoader
extends AbstractLoader
implements FileSourcedConverter,
BatchConverter {
    static final long serialVersionUID = 5607529739745491340L;
    public static String FILE_EXTENSION = ".csv";
    protected String m_File = new File(System.getProperty("user.dir")).getAbsolutePath();
    protected Instances m_structure = null;
    protected File m_sourceFile = null;
    private FastVector m_cumulativeStructure;
    private FastVector m_cumulativeInstances;

    public CSVLoader() {
        this.setRetrieval(0);
    }

    public String getFileExtension() {
        return FILE_EXTENSION;
    }

    public String getFileDescription() {
        return "CSV data files";
    }

    public File retrieveFile() {
        return new File(this.m_File);
    }

    public void setFile(File file) throws IOException {
        this.m_File = file.getAbsolutePath();
        this.setSource(file);
    }

    public String globalInfo() {
        return "Reads a source that is in comma separated or tab separated format. Assumes that the first row in the file determines the number of and names of the attributes.";
    }

    public void reset() {
        this.m_structure = null;
        this.setRetrieval(0);
    }

    public void setSource(File file) throws IOException {
        this.reset();
        if (file == null) {
            throw new IOException("Source file object is null!");
        }
        this.m_sourceFile = file;
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            bufferedReader.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new IOException("File not found");
        }
    }

    public Instances getStructure() throws IOException {
        if (this.m_sourceFile == null) {
            throw new IOException("No source has been specified");
        }
        if (this.m_structure == null) {
            try {
                BufferedReader bufferedReader = new BufferedReader(new FileReader(this.m_sourceFile));
                StreamTokenizer streamTokenizer = new StreamTokenizer(bufferedReader);
                this.initTokenizer(streamTokenizer);
                this.readStructure(streamTokenizer);
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        return this.m_structure;
    }

    private void readStructure(StreamTokenizer streamTokenizer) throws IOException {
        this.readHeader(streamTokenizer);
    }

    public Instances getDataSet() throws IOException {
        Object object;
        Object object2;
        Object object3;
        FastVector fastVector;
        if (this.m_sourceFile == null) {
            throw new IOException("No source has been specified");
        }
        this.setSource(this.m_sourceFile);
        BufferedReader bufferedReader = new BufferedReader(new FileReader(this.m_sourceFile));
        StreamTokenizer streamTokenizer = new StreamTokenizer(bufferedReader);
        this.initTokenizer(streamTokenizer);
        this.readStructure(streamTokenizer);
        streamTokenizer.ordinaryChar(44);
        streamTokenizer.ordinaryChar(9);
        this.m_cumulativeStructure = new FastVector(this.m_structure.numAttributes());
        for (int i = 0; i < this.m_structure.numAttributes(); ++i) {
            this.m_cumulativeStructure.addElement(new Hashtable());
        }
        this.m_cumulativeInstances = new FastVector();
        while ((fastVector = this.getInstance(streamTokenizer)) != null) {
            this.m_cumulativeInstances.addElement(fastVector);
        }
        bufferedReader.close();
        FastVector fastVector2 = new FastVector(this.m_structure.numAttributes());
        for (int i = 0; i < this.m_structure.numAttributes(); ++i) {
            object3 = this.m_structure.attribute(i).name();
            Hashtable hashtable = (Hashtable)this.m_cumulativeStructure.elementAt(i);
            if (hashtable.size() == 0) {
                fastVector2.addElement(new Attribute((String)object3));
                continue;
            }
            object2 = new FastVector(hashtable.size());
            for (int j = 0; j < hashtable.size(); ++j) {
                ((FastVector)object2).addElement("dummy");
            }
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                object = enumeration.nextElement();
                int n = (Integer)hashtable.get(object);
                ((FastVector)object2).setElementAt(new String(object.toString()), n);
            }
            fastVector2.addElement(new Attribute((String)object3, (FastVector)object2));
        }
        String string = this.m_sourceFile.getName().replaceAll("\\.[cC][sS][vV]$", "");
        object3 = new Instances(string, fastVector2, this.m_cumulativeInstances.size());
        for (int i = 0; i < this.m_cumulativeInstances.size(); ++i) {
            fastVector = (FastVector)this.m_cumulativeInstances.elementAt(i);
            object2 = new double[((Instances)object3).numAttributes()];
            for (int j = 0; j < fastVector.size(); ++j) {
                int n;
                Hashtable hashtable;
                object = fastVector.elementAt(j);
                if (object instanceof String) {
                    if (((String)object).compareTo("?") == 0) {
                        object2[j] = Instance.missingValue();
                        continue;
                    }
                    if (!((Instances)object3).attribute(j).isNominal()) {
                        System.err.println("Wrong attribute type!!!");
                        System.exit(1);
                    }
                    hashtable = (Hashtable)this.m_cumulativeStructure.elementAt(j);
                    n = (Integer)hashtable.get(object);
                    object2[j] = (double)n;
                    continue;
                }
                if (((Instances)object3).attribute(j).isNominal()) {
                    hashtable = (Hashtable)this.m_cumulativeStructure.elementAt(j);
                    n = (Integer)hashtable.get(object);
                    object2[j] = (double)n;
                    continue;
                }
                object2[j] = (Double)object;
            }
            ((Instances)object3).add(new Instance(1.0, (double[])object2));
        }
        this.m_structure = new Instances((Instances)object3, 0);
        this.setRetrieval(1);
        this.m_cumulativeStructure = null;
        return object3;
    }

    public Instance getNextInstance() throws IOException {
        throw new IOException("CSVLoader can't read data sets incrementally.");
    }

    private FastVector getInstance(StreamTokenizer streamTokenizer) throws IOException {
        FastVector fastVector = new FastVector();
        ConverterUtils.getFirstToken(streamTokenizer);
        if (streamTokenizer.ttype == -1) {
            return null;
        }
        boolean bl = true;
        while (streamTokenizer.ttype != 10 && streamTokenizer.ttype != -1) {
            boolean bl2;
            if (!bl) {
                ConverterUtils.getToken(streamTokenizer);
            }
            if (streamTokenizer.ttype == 44 || streamTokenizer.ttype == 9 || streamTokenizer.ttype == 10) {
                fastVector.addElement("?");
                bl2 = true;
            } else {
                bl2 = false;
                try {
                    double d = Double.valueOf(streamTokenizer.sval);
                    fastVector.addElement(new Double(d));
                }
                catch (NumberFormatException numberFormatException) {
                    fastVector.addElement(new String(streamTokenizer.sval.replace(' ', '_')));
                }
            }
            if (!bl2) {
                ConverterUtils.getToken(streamTokenizer);
            }
            bl = false;
        }
        if (fastVector.size() != this.m_structure.numAttributes()) {
            ConverterUtils.errms(streamTokenizer, "wrong number of values. Read " + fastVector.size() + ", expected " + this.m_structure.numAttributes());
        }
        try {
            this.checkStructure(fastVector);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return fastVector;
    }

    private void checkStructure(FastVector fastVector) throws Exception {
        if (fastVector == null) {
            throw new Exception("current shouldn't be null in checkStructure");
        }
        for (int i = 0; i < fastVector.size(); ++i) {
            int n;
            Hashtable hashtable;
            Object object = fastVector.elementAt(i);
            if (object instanceof String) {
                if (((String)object).compareTo("?") == 0 || (hashtable = (Hashtable)this.m_cumulativeStructure.elementAt(i)).containsKey(object)) continue;
                if (hashtable.size() == 0) {
                    for (n = 0; n < this.m_cumulativeInstances.size(); ++n) {
                        FastVector fastVector2 = (FastVector)this.m_cumulativeInstances.elementAt(n);
                        Object object2 = fastVector2.elementAt(i);
                        if (object2 instanceof String || hashtable.containsKey(object2)) continue;
                        hashtable.put(new Double((Double)object2), new Integer(hashtable.size()));
                    }
                }
                n = hashtable.size();
                hashtable.put(object, new Integer(n));
                continue;
            }
            if (object instanceof Double) {
                hashtable = (Hashtable)this.m_cumulativeStructure.elementAt(i);
                if (hashtable.size() == 0 || hashtable.containsKey(object)) continue;
                n = hashtable.size();
                hashtable.put(new Double((Double)object), new Integer(n));
                continue;
            }
            throw new Exception("Wrong object type in checkStructure!");
        }
    }

    private void readHeader(StreamTokenizer streamTokenizer) throws IOException {
        FastVector fastVector = new FastVector();
        ConverterUtils.getFirstToken(streamTokenizer);
        if (streamTokenizer.ttype == -1) {
            ConverterUtils.errms(streamTokenizer, "premature end of file");
        }
        while (streamTokenizer.ttype != 10) {
            fastVector.addElement(new Attribute(streamTokenizer.sval));
            ConverterUtils.getToken(streamTokenizer);
        }
        String string = this.m_sourceFile.getName().replaceAll("\\.[cC][sS][vV]$", "");
        this.m_structure = new Instances(string, fastVector, 0);
    }

    private void initTokenizer(StreamTokenizer streamTokenizer) {
        streamTokenizer.resetSyntax();
        streamTokenizer.whitespaceChars(0, 31);
        streamTokenizer.wordChars(32, 255);
        streamTokenizer.whitespaceChars(44, 44);
        streamTokenizer.whitespaceChars(9, 9);
        streamTokenizer.commentChar(37);
        streamTokenizer.quoteChar(34);
        streamTokenizer.quoteChar(39);
        streamTokenizer.eolIsSignificant(true);
    }

    public static void main(String[] stringArray) {
        if (stringArray.length > 0) {
            File file = new File(stringArray[0]);
            try {
                CSVLoader cSVLoader = new CSVLoader();
                cSVLoader.setSource(file);
                System.out.println(cSVLoader.getDataSet());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            System.err.println("Usage:\n\tCSVLoader <file.csv>\n");
        }
    }
}

