/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.trees.j48;

import java.io.Serializable;
import weka.classifiers.trees.j48.ClassifierSplitModel;
import weka.classifiers.trees.j48.Distribution;
import weka.classifiers.trees.j48.ModelSelection;
import weka.core.Capabilities;
import weka.core.CapabilitiesHandler;
import weka.core.Drawable;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Utils;

public class ClassifierTree
implements Drawable,
Serializable,
CapabilitiesHandler {
    static final long serialVersionUID = -8722249377542734193L;
    protected ModelSelection m_toSelectModel;
    protected ClassifierSplitModel m_localModel;
    protected ClassifierTree[] m_sons;
    protected boolean m_isLeaf;
    protected boolean m_isEmpty;
    protected Instances m_train;
    protected Distribution m_test;
    protected int m_id;
    private static long PRINTED_NODES = 0L;

    protected static long nextID() {
        return PRINTED_NODES++;
    }

    protected static void resetID() {
        PRINTED_NODES = 0L;
    }

    public ClassifierTree(ModelSelection modelSelection) {
        this.m_toSelectModel = modelSelection;
    }

    public Capabilities getCapabilities() {
        return new Capabilities(this);
    }

    public void buildClassifier(Instances instances) throws Exception {
        this.getCapabilities().testWithFail(instances);
        instances = new Instances(instances);
        instances.deleteWithMissingClass();
        this.buildTree(instances, false);
    }

    public void buildTree(Instances instances, boolean bl) throws Exception {
        if (bl) {
            this.m_train = instances;
        }
        this.m_test = null;
        this.m_isLeaf = false;
        this.m_isEmpty = false;
        this.m_sons = null;
        this.m_localModel = this.m_toSelectModel.selectModel(instances);
        if (this.m_localModel.numSubsets() > 1) {
            Instances[] instancesArray = this.m_localModel.split(instances);
            instances = null;
            this.m_sons = new ClassifierTree[this.m_localModel.numSubsets()];
            for (int i = 0; i < this.m_sons.length; ++i) {
                this.m_sons[i] = this.getNewTree(instancesArray[i]);
                instancesArray[i] = null;
            }
        } else {
            this.m_isLeaf = true;
            if (Utils.eq(instances.sumOfWeights(), 0.0)) {
                this.m_isEmpty = true;
            }
            instances = null;
        }
    }

    public void buildTree(Instances instances, Instances instances2, boolean bl) throws Exception {
        if (bl) {
            this.m_train = instances;
        }
        this.m_isLeaf = false;
        this.m_isEmpty = false;
        this.m_sons = null;
        this.m_localModel = this.m_toSelectModel.selectModel(instances, instances2);
        this.m_test = new Distribution(instances2, this.m_localModel);
        if (this.m_localModel.numSubsets() > 1) {
            Instances[] instancesArray = this.m_localModel.split(instances);
            Instances[] instancesArray2 = this.m_localModel.split(instances2);
            instances2 = null;
            instances = null;
            this.m_sons = new ClassifierTree[this.m_localModel.numSubsets()];
            for (int i = 0; i < this.m_sons.length; ++i) {
                this.m_sons[i] = this.getNewTree(instancesArray[i], instancesArray2[i]);
                instancesArray[i] = null;
                instancesArray2[i] = null;
            }
        } else {
            this.m_isLeaf = true;
            if (Utils.eq(instances.sumOfWeights(), 0.0)) {
                this.m_isEmpty = true;
            }
            instances2 = null;
            instances = null;
        }
    }

    public double classifyInstance(Instance instance) throws Exception {
        double d = -1.0;
        int n = 0;
        for (int i = 0; i < instance.numClasses(); ++i) {
            double d2 = this.getProbs(i, instance, 1.0);
            if (!Utils.gr(d2, d)) continue;
            n = i;
            d = d2;
        }
        return n;
    }

    public final void cleanup(Instances instances) {
        this.m_train = instances;
        this.m_test = null;
        if (!this.m_isLeaf) {
            for (int i = 0; i < this.m_sons.length; ++i) {
                this.m_sons[i].cleanup(instances);
            }
        }
    }

    public final double[] distributionForInstance(Instance instance, boolean bl) throws Exception {
        double[] dArray = new double[instance.numClasses()];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = !bl ? this.getProbs(i, instance, 1.0) : this.getProbsLaplace(i, instance, 1.0);
        }
        return dArray;
    }

    public int assignIDs(int n) {
        int n2;
        this.m_id = n2 = n + 1;
        if (this.m_sons != null) {
            for (int i = 0; i < this.m_sons.length; ++i) {
                n2 = this.m_sons[i].assignIDs(n2);
            }
        }
        return n2;
    }

    public int graphType() {
        return 1;
    }

    public String graph() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        this.assignIDs(-1);
        stringBuffer.append("digraph J48Tree {\n");
        if (this.m_isLeaf) {
            stringBuffer.append("N" + this.m_id + " [label=\"" + this.m_localModel.dumpLabel(0, this.m_train) + "\" " + "shape=box style=filled ");
            if (this.m_train != null && this.m_train.numInstances() > 0) {
                stringBuffer.append("data =\n" + this.m_train + "\n");
                stringBuffer.append(",\n");
            }
            stringBuffer.append("]\n");
        } else {
            stringBuffer.append("N" + this.m_id + " [label=\"" + this.m_localModel.leftSide(this.m_train) + "\" ");
            if (this.m_train != null && this.m_train.numInstances() > 0) {
                stringBuffer.append("data =\n" + this.m_train + "\n");
                stringBuffer.append(",\n");
            }
            stringBuffer.append("]\n");
            this.graphTree(stringBuffer);
        }
        return stringBuffer.toString() + "}\n";
    }

    public String prefix() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.m_isLeaf) {
            stringBuffer.append("[" + this.m_localModel.dumpLabel(0, this.m_train) + "]");
        } else {
            this.prefixTree(stringBuffer);
        }
        return stringBuffer.toString();
    }

    public StringBuffer[] toSource(String string) throws Exception {
        StringBuffer[] stringBufferArray = new StringBuffer[2];
        if (this.m_isLeaf) {
            stringBufferArray[0] = new StringBuffer("    p = " + this.m_localModel.distribution().maxClass(0) + ";\n");
            stringBufferArray[1] = new StringBuffer("");
        } else {
            StringBuffer stringBuffer = new StringBuffer();
            StringBuffer stringBuffer2 = new StringBuffer();
            long l = ClassifierTree.nextID();
            stringBuffer.append("  static double N").append(Integer.toHexString(this.m_localModel.hashCode()) + l).append("(Object []i) {\n").append("    double p = Double.NaN;\n");
            stringBuffer.append("    if (").append(this.m_localModel.sourceExpression(-1, this.m_train)).append(") {\n");
            stringBuffer.append("      p = ").append(this.m_localModel.distribution().maxClass(0)).append(";\n");
            stringBuffer.append("    } ");
            for (int i = 0; i < this.m_sons.length; ++i) {
                stringBuffer.append("else if (" + this.m_localModel.sourceExpression(i, this.m_train) + ") {\n");
                if (this.m_sons[i].m_isLeaf) {
                    stringBuffer.append("      p = " + this.m_localModel.distribution().maxClass(i) + ";\n");
                } else {
                    StringBuffer[] stringBufferArray2 = this.m_sons[i].toSource(string);
                    stringBuffer.append(stringBufferArray2[0]);
                    stringBuffer2.append(stringBufferArray2[1]);
                }
                stringBuffer.append("    } ");
                if (i != this.m_sons.length - 1) continue;
                stringBuffer.append('\n');
            }
            stringBuffer.append("    return p;\n  }\n");
            stringBufferArray[0] = new StringBuffer("    p = " + string + ".N");
            stringBufferArray[0].append(Integer.toHexString(this.m_localModel.hashCode()) + l).append("(i);\n");
            stringBufferArray[1] = stringBuffer.append(stringBuffer2);
        }
        return stringBufferArray;
    }

    public int numLeaves() {
        int n = 0;
        if (this.m_isLeaf) {
            return 1;
        }
        for (int i = 0; i < this.m_sons.length; ++i) {
            n += this.m_sons[i].numLeaves();
        }
        return n;
    }

    public int numNodes() {
        int n = 1;
        if (!this.m_isLeaf) {
            for (int i = 0; i < this.m_sons.length; ++i) {
                n += this.m_sons[i].numNodes();
            }
        }
        return n;
    }

    public String toString() {
        try {
            StringBuffer stringBuffer = new StringBuffer();
            if (this.m_isLeaf) {
                stringBuffer.append(": ");
                stringBuffer.append(this.m_localModel.dumpLabel(0, this.m_train));
            } else {
                this.dumpTree(0, stringBuffer);
            }
            stringBuffer.append("\n\nNumber of Leaves  : \t" + this.numLeaves() + "\n");
            stringBuffer.append("\nSize of the tree : \t" + this.numNodes() + "\n");
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            return "Can't print classification tree.";
        }
    }

    protected ClassifierTree getNewTree(Instances instances) throws Exception {
        ClassifierTree classifierTree = new ClassifierTree(this.m_toSelectModel);
        classifierTree.buildTree(instances, false);
        return classifierTree;
    }

    protected ClassifierTree getNewTree(Instances instances, Instances instances2) throws Exception {
        ClassifierTree classifierTree = new ClassifierTree(this.m_toSelectModel);
        classifierTree.buildTree(instances, instances2, false);
        return classifierTree;
    }

    private void dumpTree(int n, StringBuffer stringBuffer) throws Exception {
        for (int i = 0; i < this.m_sons.length; ++i) {
            stringBuffer.append("\n");
            for (int j = 0; j < n; ++j) {
                stringBuffer.append("|   ");
            }
            stringBuffer.append(this.m_localModel.leftSide(this.m_train));
            stringBuffer.append(this.m_localModel.rightSide(i, this.m_train));
            if (this.m_sons[i].m_isLeaf) {
                stringBuffer.append(": ");
                stringBuffer.append(this.m_localModel.dumpLabel(i, this.m_train));
                continue;
            }
            this.m_sons[i].dumpTree(n + 1, stringBuffer);
        }
    }

    private void graphTree(StringBuffer stringBuffer) throws Exception {
        for (int i = 0; i < this.m_sons.length; ++i) {
            stringBuffer.append("N" + this.m_id + "->" + "N" + this.m_sons[i].m_id + " [label=\"" + this.m_localModel.rightSide(i, this.m_train).trim() + "\"]\n");
            if (this.m_sons[i].m_isLeaf) {
                stringBuffer.append("N" + this.m_sons[i].m_id + " [label=\"" + this.m_localModel.dumpLabel(i, this.m_train) + "\" " + "shape=box style=filled ");
                if (this.m_train != null && this.m_train.numInstances() > 0) {
                    stringBuffer.append("data =\n" + this.m_sons[i].m_train + "\n");
                    stringBuffer.append(",\n");
                }
                stringBuffer.append("]\n");
                continue;
            }
            stringBuffer.append("N" + this.m_sons[i].m_id + " [label=\"" + this.m_sons[i].m_localModel.leftSide(this.m_train) + "\" ");
            if (this.m_train != null && this.m_train.numInstances() > 0) {
                stringBuffer.append("data =\n" + this.m_sons[i].m_train + "\n");
                stringBuffer.append(",\n");
            }
            stringBuffer.append("]\n");
            this.m_sons[i].graphTree(stringBuffer);
        }
    }

    private void prefixTree(StringBuffer stringBuffer) throws Exception {
        int n;
        stringBuffer.append("[");
        stringBuffer.append(this.m_localModel.leftSide(this.m_train) + ":");
        for (n = 0; n < this.m_sons.length; ++n) {
            if (n > 0) {
                stringBuffer.append(",\n");
            }
            stringBuffer.append(this.m_localModel.rightSide(n, this.m_train));
        }
        for (n = 0; n < this.m_sons.length; ++n) {
            if (this.m_sons[n].m_isLeaf) {
                stringBuffer.append("[");
                stringBuffer.append(this.m_localModel.dumpLabel(n, this.m_train));
                stringBuffer.append("]");
                continue;
            }
            this.m_sons[n].prefixTree(stringBuffer);
        }
        stringBuffer.append("]");
    }

    private double getProbsLaplace(int n, Instance instance, double d) throws Exception {
        double d2 = 0.0;
        if (this.m_isLeaf) {
            return d * this.localModel().classProbLaplace(n, instance, -1);
        }
        int n2 = this.localModel().whichSubset(instance);
        if (n2 == -1) {
            double[] dArray = this.localModel().weights(instance);
            for (int i = 0; i < this.m_sons.length; ++i) {
                if (this.son((int)i).m_isEmpty) continue;
                if (!this.son((int)i).m_isLeaf) {
                    d2 += this.son(i).getProbsLaplace(n, instance, dArray[i] * d);
                    continue;
                }
                d2 += d * dArray[i] * this.localModel().classProbLaplace(n, instance, i);
            }
            return d2;
        }
        if (this.son((int)n2).m_isLeaf) {
            return d * this.localModel().classProbLaplace(n, instance, n2);
        }
        return this.son(n2).getProbsLaplace(n, instance, d);
    }

    private double getProbs(int n, Instance instance, double d) throws Exception {
        double d2 = 0.0;
        if (this.m_isLeaf) {
            return d * this.localModel().classProb(n, instance, -1);
        }
        int n2 = this.localModel().whichSubset(instance);
        if (n2 == -1) {
            double[] dArray = this.localModel().weights(instance);
            for (int i = 0; i < this.m_sons.length; ++i) {
                if (this.son((int)i).m_isEmpty) continue;
                d2 += this.son(i).getProbs(n, instance, dArray[i] * d);
            }
            return d2;
        }
        if (this.son((int)n2).m_isEmpty) {
            return d * this.localModel().classProb(n, instance, n2);
        }
        return this.son(n2).getProbs(n, instance, d);
    }

    private ClassifierSplitModel localModel() {
        return this.m_localModel;
    }

    private ClassifierTree son(int n) {
        return this.m_sons[n];
    }
}

