/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.instance;

import java.util.Enumeration;
import java.util.Vector;
import weka.core.Attribute;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.Range;
import weka.core.SingleIndex;
import weka.core.UnsupportedAttributeTypeException;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.StreamableFilter;
import weka.filters.UnsupervisedFilter;

public class RemoveWithValues
extends Filter
implements UnsupervisedFilter,
StreamableFilter,
OptionHandler {
    private SingleIndex m_AttIndex = new SingleIndex("last");
    protected Range m_Values = new Range("first-last");
    protected double m_Value = 0.0;
    protected boolean m_MatchMissingValues = false;
    protected boolean m_ModifyHeader = false;
    protected int[] m_NominalMapping;

    public String globalInfo() {
        return "Filters instances according to the value of an attribute.";
    }

    public RemoveWithValues() {
        this.m_Values.setInvert(true);
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>(5);
        vector.addElement(new Option("\tChoose attribute to be used for selection.", "C", 1, "-C <num>"));
        vector.addElement(new Option("\tNumeric value to be used for selection on numeric\n\tattribute.\n\tInstances with values smaller than given value will\n\tbe selected. (default 0)", "S", 1, "-S <num>"));
        vector.addElement(new Option("\tRange of label indices to be used for selection on\n\tnominal attribute.\n\tFirst and last are valid indexes. (default all values)", "L", 1, "-L <index1,index2-index4,...>"));
        vector.addElement(new Option("\tMissing values count as a match. This setting is\n\tindependent of the -V option.\n\t(default missing values don't match)", "M", 0, "-M"));
        vector.addElement(new Option("\tInvert matching sense.", "V", 0, "-V"));
        vector.addElement(new Option("\tWhen selecting on nominal attributes, removes header\n\treferences to excluded values.", "H", 0, "-H"));
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        String string = Utils.getOption('C', stringArray);
        if (string.length() != 0) {
            this.setAttributeIndex(string);
        } else {
            this.setAttributeIndex("last");
        }
        String string2 = Utils.getOption('S', stringArray);
        if (string2.length() != 0) {
            this.setSplitPoint(new Double(string2));
        } else {
            this.setSplitPoint(0.0);
        }
        String string3 = Utils.getOption('L', stringArray);
        if (string3.length() != 0) {
            this.setNominalIndices(string3);
        } else {
            this.setNominalIndices("first-last");
        }
        this.setInvertSelection(Utils.getFlag('V', stringArray));
        this.setMatchMissingValues(Utils.getFlag('M', stringArray));
        this.setModifyHeader(Utils.getFlag('H', stringArray));
        if (this.getInputFormat() != null) {
            this.setInputFormat(this.getInputFormat());
        }
    }

    public String[] getOptions() {
        String[] stringArray = new String[9];
        int n = 0;
        stringArray[n++] = "-S";
        stringArray[n++] = "" + this.getSplitPoint();
        stringArray[n++] = "-C";
        stringArray[n++] = "" + this.getAttributeIndex();
        if (!this.getNominalIndices().equals("")) {
            stringArray[n++] = "-L";
            stringArray[n++] = this.getNominalIndices();
        }
        if (this.getInvertSelection()) {
            stringArray[n++] = "-V";
        }
        if (this.getMatchMissingValues()) {
            stringArray[n++] = "-M";
        }
        if (this.getModifyHeader()) {
            stringArray[n++] = "-H";
        }
        while (n < stringArray.length) {
            stringArray[n++] = "";
        }
        return stringArray;
    }

    public boolean setInputFormat(Instances instances) throws Exception {
        super.setInputFormat(instances);
        this.m_AttIndex.setUpper(instances.numAttributes() - 1);
        if (!this.isNumeric() && !this.isNominal()) {
            throw new UnsupportedAttributeTypeException("Can only handle numeric or nominal attributes.");
        }
        this.m_Values.setUpper(instances.attribute(this.m_AttIndex.getIndex()).numValues() - 1);
        if (this.isNominal() && this.m_ModifyHeader) {
            int n;
            instances = new Instances(instances, 0);
            Attribute attribute = instances.attribute(this.m_AttIndex.getIndex());
            int[] nArray = this.m_Values.getSelection();
            FastVector fastVector = new FastVector();
            for (n = 0; n < nArray.length; ++n) {
                fastVector.addElement(attribute.value(nArray[n]));
            }
            instances.deleteAttributeAt(this.m_AttIndex.getIndex());
            instances.insertAttributeAt(new Attribute(attribute.name(), fastVector), this.m_AttIndex.getIndex());
            this.m_NominalMapping = new int[attribute.numValues()];
            for (n = 0; n < this.m_NominalMapping.length; ++n) {
                boolean bl = false;
                for (int i = 0; i < nArray.length; ++i) {
                    if (nArray[i] != n) continue;
                    this.m_NominalMapping[n] = i;
                    bl = true;
                    break;
                }
                if (bl) continue;
                this.m_NominalMapping[n] = -1;
            }
        }
        this.setOutputFormat(instances);
        return true;
    }

    public boolean input(Instance instance) {
        if (this.getInputFormat() == null) {
            throw new IllegalStateException("No input instance format defined");
        }
        if (this.m_NewBatch) {
            this.resetQueue();
            this.m_NewBatch = false;
        }
        if (instance.isMissing(this.m_AttIndex.getIndex())) {
            if (!this.getMatchMissingValues()) {
                this.push((Instance)instance.copy());
                return true;
            }
            return false;
        }
        if (this.isNumeric()) {
            if (!this.m_Values.getInvert()) {
                if (instance.value(this.m_AttIndex.getIndex()) < this.m_Value) {
                    this.push((Instance)instance.copy());
                    return true;
                }
            } else if (instance.value(this.m_AttIndex.getIndex()) >= this.m_Value) {
                this.push((Instance)instance.copy());
                return true;
            }
        }
        if (this.isNominal() && this.m_Values.isInRange((int)instance.value(this.m_AttIndex.getIndex()))) {
            Instance instance2 = (Instance)instance.copy();
            if (this.getModifyHeader()) {
                instance2.setValue(this.m_AttIndex.getIndex(), (double)this.m_NominalMapping[(int)instance.value(this.m_AttIndex.getIndex())]);
            }
            this.push(instance2);
            return true;
        }
        return false;
    }

    public boolean isNominal() {
        if (this.getInputFormat() == null) {
            return false;
        }
        return this.getInputFormat().attribute(this.m_AttIndex.getIndex()).isNominal();
    }

    public boolean isNumeric() {
        if (this.getInputFormat() == null) {
            return false;
        }
        return this.getInputFormat().attribute(this.m_AttIndex.getIndex()).isNumeric();
    }

    public String modifyHeaderTipText() {
        return "When selecting on nominal attributes, removes header references to excluded values.";
    }

    public boolean getModifyHeader() {
        return this.m_ModifyHeader;
    }

    public void setModifyHeader(boolean bl) {
        this.m_ModifyHeader = bl;
    }

    public String attributeIndexTipText() {
        return "Choose attribute to be used for selection (default last).";
    }

    public String getAttributeIndex() {
        return this.m_AttIndex.getSingleIndex();
    }

    public void setAttributeIndex(String string) {
        this.m_AttIndex.setSingleIndex(string);
    }

    public String splitPointTipText() {
        return "Numeric value to be used for selection on numeric attribute. Instances with values smaller than given value will be selected.";
    }

    public double getSplitPoint() {
        return this.m_Value;
    }

    public void setSplitPoint(double d) {
        this.m_Value = d;
    }

    public String matchMissingValuesTipText() {
        return "Missing values count as a match. This setting is independent of the invertSelection option.";
    }

    public boolean getMatchMissingValues() {
        return this.m_MatchMissingValues;
    }

    public void setMatchMissingValues(boolean bl) {
        this.m_MatchMissingValues = bl;
    }

    public String invertSelectionTipText() {
        return "Invert matching sense.";
    }

    public boolean getInvertSelection() {
        return !this.m_Values.getInvert();
    }

    public void setInvertSelection(boolean bl) {
        this.m_Values.setInvert(!bl);
    }

    public String nominalIndicesTipText() {
        return "Range of label indices to be used for selection on nominal attribute. First and last are valid indexes.";
    }

    public String getNominalIndices() {
        return this.m_Values.getRanges();
    }

    public void setNominalIndices(String string) {
        this.m_Values.setRanges(string);
    }

    public void setNominalIndicesArr(int[] nArray) {
        String string = "";
        for (int i = 0; i < nArray.length; ++i) {
            string = i == 0 ? "" + (nArray[i] + 1) : string + "," + (nArray[i] + 1);
        }
        this.setNominalIndices(string);
    }

    public static void main(String[] stringArray) {
        try {
            if (Utils.getFlag('b', stringArray)) {
                Filter.batchFilterFile(new RemoveWithValues(), stringArray);
            } else {
                Filter.filterFile(new RemoveWithValues(), stringArray);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println(exception.getMessage());
        }
    }
}

