% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readMapFile.R
\name{readMapFile}
\alias{readMapFile}
\title{Read file with information about SNPs chromosome and position, for example
from regular PLINK .map OR .bim file}
\usage{
readMapFile(filename = "NULL", morgans = TRUE)
}
\arguments{
\item{filename}{character, path to input file containing genomic
map data, e.g. a Plink
\href{http://pngu.mgh.harvard.edu/~purcell/plink/data.shtml#map}{\code{.map}},
\href{http://pngu.mgh.harvard.edu/~purcell/plink/data.shtml#tr}{\code{.bim}}
or \href{http://pngu.mgh.harvard.edu/~purcell/plink/data.shtml#bed}{\code{.tped}} file.}

\item{morgans}{logical, indicate whether input file contains column with
genetic distance between SNPs (in which case the bp positions are
in the fourth column)}
}
\value{
matrix object with columns contains chromosome, rsID
and position in bp
}
\description{
These files have (at least) the following columns (separated by
white space):
\itemize{
\item column 1: chromosome
\item column 2: variant name
\item column 3: genetic distance in morgans (optional, see the
\code{morgans} option)
\item column 4: base-pair position (bp units)
}
}
\author{
Sodbo Sharapov
}
\seealso{
\code{\link{read.haplo}},
\code{\link{read.haplo.pedfile}},
\code{\link{read.haplo.bedfile}},
\code{\link{read.haplo.shapeit_haps}}
}

