% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read.haplo.R
\name{read.haplo}
\alias{read.haplo}
\title{Read haplotype data, selected by region of interest, from PLINK formatted
files or ShapeIt output files}
\usage{
read.haplo(type = "bed", filename, map, chr = 0, startpos = 0,
  endpos = 0)
}
\arguments{
\item{type}{character, \code{'ped'}, \code{'bed'} (default) or
\code{'shapeit-haps'} format of input file containing haplotype
data}

\item{filename}{character, path to input file containing haplotype data}

\item{map}{object, data.frame contains 3 columns: rsID, chromosome,
position in bp as output by e.g. \code{\link{readMapFile}}.}

\item{chr}{character, chromosome number (basically from 1 to 22 as used by
\href{http://pngu.mgh.harvard.edu/~purcell/plink/data.shtml#ped}{Plink}),
on which the region of interest is located}

\item{startpos}{numeric, start position (in bp, base pairs) of the
region of interest (default: 0)}

\item{endpos}{numeric, end position (in bp, base pairs) of the
region of interest (default: 0)}
}
\value{
matrix object containing the haplotypes selected by the
region of interest
}
\description{
Read haplotype data, selected by region of interest, from PLINK formatted
files or ShapeIt output files
}
\seealso{
\code{\link{read.haplo.pedfile}},
\code{\link{read.haplo.bedfile}},
\code{\link{read.haplo.shapeit_haps}},
\code{\link{readMapFile}}
}
\keyword{internal}

