% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RVCompare.R
\name{isFunctionDensity}
\alias{isFunctionDensity}
\title{Check if a function is a (non-discrete) probability density function in a given domain.}
\usage{
isFunctionDensity(f, xlims, tol = 0.001)
}
\arguments{
\item{f}{the function to be checked.}

\item{xlims}{an interval that represents the domain of definition of f.}

\item{tol}{(optional parameter, default = 0.001) the integral of f is allowed to be in the interval (1-tol, 1+tol), to account for some reasonable error in the integration.}
}
\value{
Returns True if the function is a non discrete probability density function. Otherwise, returns False.
}
\description{
This function checks if an input function f is a non-discrete probability density function. For this to
be the case, the function needs to only return real values. The function also needs to be bounded, positive,
and its integral in the domain of definition needs to be 1.
}
\examples{
dist1 <- normalDensity(0,1)
# the integral of the density of the normal distribution is too low in the interval (-2,2)
isFunctionDensity(dist1, c(-2,2))
isFunctionDensity(dist1, c(-5,5)) # it is close enough from 1 in the interval (-5,5)
dist2 <- uniformDensity(c(0,1))
isFunctionDensity(dist2, xlims=c(-2,2))
isFunctionDensity(dist2, xlims=c(0.5,2)) # the integral is not 1

dist3 <- function(x) 0.5/sqrt(x)
# The integral of the function being 1 is not enough to be considered a density function.
# It also needs to be boounded.
isFunctionDensity(dist3, c(1e-14,1))

}
